/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.StrutsResourceBundle;
import com.liferay.portlet.internal.PortletResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;

public class PortletConfigImpl
implements LiferayPortletConfig {
    private final String _containerRuntimeOptionPrefix;
    private final boolean _copyRequestParameters;
    private final Portlet _portlet;
    private final PortletApp _portletApp;
    private final PortletContext _portletContext;
    private final Map<String, String> _portletInfos;
    private final String _portletName;
    private final Map<String, ResourceBundle> _resourceBundles = new ConcurrentHashMap<String, ResourceBundle>();

    public PortletConfigImpl(Portlet portlet, PortletContext portletContext) {
        this._portlet = portlet;
        this._portletContext = portletContext;
        this._portletInfos = PortletResourceBundle.getPortletInfos(this._portlet.getPortletInfo());
        this._copyRequestParameters = GetterUtil.getBoolean(this.getInitParameter("copy-request-parameters"));
        this._portletApp = portlet.getPortletApp();
        String portletName = portlet.getRootPortletId();
        int pos = portletName.indexOf("_WAR_");
        if (pos != -1) {
            portletName = portletName.substring(0, pos);
        }
        this._portletName = portletName;
        String className = LiferayPortletConfig.class.getName();
        this._containerRuntimeOptionPrefix = className.concat(this._portletName);
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        String name;
        Map<String, String[]> portletAppContainerRuntimeOptions = this._portletApp.getContainerRuntimeOptions();
        HashMap<String, String[]> containerRuntimeOptions = new HashMap<String, String[]>();
        String className = LiferayPortletConfig.class.getName();
        for (Map.Entry<String, String[]> portletAppContainerRuntimeOption : portletAppContainerRuntimeOptions.entrySet()) {
            name = portletAppContainerRuntimeOption.getKey();
            if (name.startsWith(className)) continue;
            containerRuntimeOptions.put(name, portletAppContainerRuntimeOption.getValue());
        }
        for (Map.Entry<String, String[]> portletAppContainerRuntimeOption : portletAppContainerRuntimeOptions.entrySet()) {
            name = portletAppContainerRuntimeOption.getKey();
            if (!name.startsWith(this._containerRuntimeOptionPrefix)) continue;
            containerRuntimeOptions.put(name.substring(this._containerRuntimeOptionPrefix.length()), portletAppContainerRuntimeOption.getValue());
        }
        Set keySet = containerRuntimeOptions.keySet();
        keySet.retainAll(SetUtil.fromEnumeration(this._portletContext.getContainerRuntimeOptions()));
        return Collections.unmodifiableMap(containerRuntimeOptions);
    }

    public String getDefaultNamespace() {
        return this._portletApp.getDefaultNamespace();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map<String, String> initParams = this._portlet.getInitParams();
        return initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        Map<String, String> initParams = this._portlet.getInitParams();
        return Collections.enumeration(initParams.keySet());
    }

    @Override
    public Portlet getPortlet() {
        return this._portlet;
    }

    @Override
    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    @Override
    public String getPortletId() {
        return this._portlet.getPortletId();
    }

    public Enumeration<PortletMode> getPortletModes(String mimeType) {
        Map<String, Set<String>> portletModeMap = this._portlet.getPortletModes();
        Set<String> portletModeNames = portletModeMap.get(mimeType);
        if (portletModeNames == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<PortletMode> portletModes = new ArrayList<PortletMode>(portletModeNames.size());
        for (String portletModeName : portletModeNames) {
            portletModes.add(PortletModeFactory.getPortletMode(portletModeName, this._portletApp.getSpecMajorVersion()));
        }
        return Collections.enumeration(portletModes);
    }

    public String getPortletName() {
        return this._portletName;
    }

    public Enumeration<QName> getProcessingEventQNames() {
        return Collections.enumeration(this.toJavaxQNames(this._portlet.getProcessingEvents()));
    }

    public Map<String, QName> getPublicRenderParameterDefinitions() {
        HashMap<String, QName> publicRenderParameterDefinitions = new HashMap<String, QName>();
        for (PublicRenderParameter publicRenderParameter : this._portlet.getPublicRenderParameters()) {
            com.liferay.portal.kernel.xml.QName qName = publicRenderParameter.getQName();
            publicRenderParameterDefinitions.put(publicRenderParameter.getIdentifier(), new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getNamespacePrefix()));
        }
        return publicRenderParameterDefinitions;
    }

    public Enumeration<String> getPublicRenderParameterNames() {
        ArrayList<String> publicRenderParameterNames = new ArrayList<String>();
        for (PublicRenderParameter publicRenderParameter : this._portlet.getPublicRenderParameters()) {
            publicRenderParameterNames.add(publicRenderParameter.getIdentifier());
        }
        return Collections.enumeration(publicRenderParameterNames);
    }

    public Enumeration<QName> getPublishingEventQNames() {
        return Collections.enumeration(this.toJavaxQNames(this._portlet.getPublishingEvents()));
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        String resourceBundleClassName = this._portlet.getResourceBundle();
        if (Validator.isNull(resourceBundleClassName)) {
            String resourceBundleId = this._portlet.getPortletId();
            ResourceBundle resourceBundle = this._resourceBundles.get(resourceBundleId);
            if (resourceBundle == null) {
                resourceBundle = new PortletResourceBundle(null, this._portletInfos);
                this._resourceBundles.put(resourceBundleId, resourceBundle);
            }
            return resourceBundle;
        }
        ResourceBundle resourceBundle = null;
        if (!this._portletApp.isWARFile() && resourceBundleClassName.equals(StrutsResourceBundle.class.getName())) {
            StringBundler sb = new StringBundler(4);
            sb.append(this._portlet.getPortletId());
            sb.append(locale.getLanguage());
            sb.append(locale.getCountry());
            sb.append(locale.getVariant());
            String resourceBundleId = sb.toString();
            resourceBundle = this._resourceBundles.get(resourceBundleId);
            if (resourceBundle == null) {
                resourceBundle = new StrutsResourceBundle(this._portletName, locale);
            }
            this._resourceBundles.put(resourceBundleId, resourceBundle);
        } else {
            PortletBag portletBag = PortletBagPool.get(this._portlet.getRootPortletId());
            resourceBundle = portletBag.getResourceBundle(locale);
        }
        return new PortletResourceBundle(resourceBundle, this._portletInfos);
    }

    public Enumeration<Locale> getSupportedLocales() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        for (String languageId : this._portlet.getSupportedLocales()) {
            supportedLocales.add(LocaleUtil.fromLanguageId(languageId));
        }
        return Collections.enumeration(supportedLocales);
    }

    public Enumeration<WindowState> getWindowStates(String mimeType) {
        Map<String, Set<String>> windowStateMap = this._portlet.getWindowStates();
        Set<String> windowStateNames = windowStateMap.get(mimeType);
        if (windowStateNames == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<WindowState> windowStates = new ArrayList<WindowState>(windowStateNames.size());
        for (String windowStateName : windowStateNames) {
            windowStates.add(WindowStateFactory.getWindowState(windowStateName, this._portletApp.getSpecMajorVersion()));
        }
        return Collections.enumeration(windowStates);
    }

    @Override
    public boolean isCopyRequestParameters() {
        return this._copyRequestParameters;
    }

    @Override
    public boolean isWARFile() {
        return this._portletApp.isWARFile();
    }

    protected Set<QName> toJavaxQNames(Set<com.liferay.portal.kernel.xml.QName> liferayQNames) {
        HashSet<QName> javaxQNames = new HashSet<QName>(liferayQNames.size());
        for (com.liferay.portal.kernel.xml.QName liferayQName : liferayQNames) {
            QName javaxQName = new QName(liferayQName.getNamespaceURI(), liferayQName.getLocalPart(), liferayQName.getNamespacePrefix());
            javaxQNames.add(javaxQName);
        }
        return javaxQNames;
    }
}

