/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.internal.PortletResponseImpl;
import com.liferay.portlet.internal.PortletURLImpl;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class LiferayPortletURLPrivilegedAction {
    private static final Log _log = LogFactoryUtil.getLog(LiferayPortletURLPrivilegedAction.class);
    private final Map<String, Constructor<? extends PortletURLImpl>> _constructors;
    private final MimeResponse.Copy _copy;
    private final HttpServletRequest _httpServletRequest;
    private final boolean _includeLinkToLayoutUuid;
    private final Layout _layout;
    private final String _lifecycle;
    private final long _plid;
    private final Portlet _portlet;
    private final String _portletName;
    private final PortletPreferences _portletPreferences;
    private final PortletRequest _portletRequest;
    private final PortletResponseImpl _portletResponseImpl;
    private final long _requestPlid;

    public LiferayPortletURLPrivilegedAction(long plid, String portletName, String lifecycle, MimeResponse.Copy copy, boolean includeLinkToLayoutUuid, Layout layout, Portlet portlet, PortletPreferences portletPreferences, PortletRequest portletRequest, PortletResponseImpl portletResponseImpl, long requestPlid, Map<String, Constructor<? extends PortletURLImpl>> constructors) {
        this._plid = plid;
        this._portletName = portletName;
        this._lifecycle = lifecycle;
        this._copy = copy;
        this._includeLinkToLayoutUuid = includeLinkToLayoutUuid;
        this._layout = layout;
        this._portlet = portlet;
        this._portletPreferences = portletPreferences;
        this._portletRequest = portletRequest;
        this._portletResponseImpl = portletResponseImpl;
        this._httpServletRequest = null;
        this._requestPlid = requestPlid;
        this._constructors = constructors;
    }

    public LiferayPortletURLPrivilegedAction(String portletName, String lifecycle, MimeResponse.Copy copy, Layout layout, Portlet portlet, HttpServletRequest httpServletRequest) {
        this._portletName = portletName;
        this._lifecycle = lifecycle;
        this._copy = copy;
        this._layout = layout;
        this._portlet = portlet;
        this._httpServletRequest = httpServletRequest;
        this._constructors = null;
        this._includeLinkToLayoutUuid = false;
        this._plid = 0L;
        this._portletPreferences = null;
        this._portletRequest = null;
        this._portletResponseImpl = null;
        this._requestPlid = 0L;
    }

    public LiferayPortletURL run() {
        if (this._httpServletRequest != null) {
            return PortletURLFactoryUtil.create(this._httpServletRequest, this._portlet, this._layout, this._lifecycle, this._copy);
        }
        long plid = this._plid;
        if (plid == 0L) {
            plid = this._requestPlid;
        }
        LiferayPortletURL portletURL = null;
        String portletURLClass = this._portlet.getPortletURLClass();
        String portletId = this._portlet.getPortletId();
        if (portletId.equals(this._portletName) && Validator.isNotNull(portletURLClass)) {
            try {
                Constructor<PortletURLImpl> constructor = this._constructors.get(portletURLClass);
                if (constructor == null) {
                    Class<?> portletURLClassObj = Class.forName(portletURLClass);
                    constructor = portletURLClassObj.getConstructor(PortletResponseImpl.class, Long.TYPE, String.class);
                    this._constructors.put(portletURLClass, constructor);
                }
                portletURL = constructor.newInstance(this._portletResponseImpl, plid, this._lifecycle);
            }
            catch (Exception e) {
                _log.error("Unable to create portlet URL", e);
            }
        }
        if (portletURL == null) {
            portletURL = this._portletName.equals(portletId) ? PortletURLFactoryUtil.create(this._portletRequest, this._portlet, plid, this._lifecycle, this._copy) : PortletURLFactoryUtil.create(this._portletRequest, this._portletName, plid, this._lifecycle, this._copy);
        }
        try {
            if (this._portlet.hasWindowState(this._portletRequest.getResponseContentType(), this._portletRequest.getWindowState())) {
                portletURL.setWindowState(this._portletRequest.getWindowState());
            }
        }
        catch (WindowStateException wse) {
            _log.error(wse.getMessage());
        }
        try {
            if (this._portlet.hasPortletMode(this._portletRequest.getResponseContentType(), this._portletRequest.getPortletMode())) {
                portletURL.setPortletMode(this._portletRequest.getPortletMode());
            }
        }
        catch (PortletModeException pme) {
            _log.error(pme.getMessage());
        }
        return portletURL;
    }
}

