/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletFilterUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.InvokerPortletUtil;
import com.liferay.portlet.internal.FilterChainImpl;
import com.liferay.portlet.internal.HeaderResponseImpl;
import com.liferay.portlet.internal.PortletTypeUtil;
import com.liferay.portlet.internal.RenderRequestImpl;
import com.liferay.portlet.internal.RenderResponseImpl;
import com.liferay.portlet.internal.StateAwareResponseImpl;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.UnavailableException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.StopWatch;

public class InvokerPortletImpl
implements InvokerFilterContainer,
InvokerPortlet {
    private static final Log _log = LogFactoryUtil.getLog(InvokerPortletImpl.class);
    private boolean _checkAuthToken;
    private String _errorKey;
    private Integer _expCache;
    private boolean _facesPortlet;
    private boolean _headerPortlet;
    private InvokerFilterContainer _invokerFilterContainer;
    private LiferayPortletConfig _liferayPortletConfig;
    private LiferayPortletContext _liferayPortletContext;
    private Portlet _portlet;
    private ClassLoader _portletClassLoader;
    private String _portletId;
    private com.liferay.portal.kernel.model.Portlet _portletModel;

    public InvokerPortletImpl(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer, boolean checkAuthToken, boolean facesPortlet, boolean headerPortlet) {
        this._initialize(portletModel, portlet, portletConfig, portletContext, invokerFilterContainer, checkAuthToken, facesPortlet, headerPortlet);
    }

    public InvokerPortletImpl(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer) {
        Map<String, String> initParams = portletModel.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean(initParams.get("check-auth-token"), true);
        boolean facesPortlet = false;
        Class<?> portletClass = portlet.getClass();
        if (ClassUtil.isSubclass(portletClass, "javax.portlet.faces.GenericFacesPortlet")) {
            facesPortlet = true;
        } else if (portlet instanceof InvokerPortlet) {
            InvokerPortlet invokerPortlet = (InvokerPortlet)portlet;
            facesPortlet = invokerPortlet.isFacesPortlet();
        }
        boolean headerPortlet = PortletTypeUtil.isHeaderPortlet(portlet);
        this._initialize(portletModel, portlet, null, portletContext, invokerFilterContainer, checkAuthToken, facesPortlet, headerPortlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PortletIdCodec.hasInstanceId(this._portletModel.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn("Destroying an instanced portlet is not allowed");
            }
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(this._portletClassLoader);
            }
            Closeable closeable = (Closeable)((Object)this._invokerFilterContainer);
            closeable.close();
            this._portlet.destroy();
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
        }
        finally {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    @Override
    public List<ActionFilter> getActionFilters() {
        return this._invokerFilterContainer.getActionFilters();
    }

    @Override
    public List<EventFilter> getEventFilters() {
        return this._invokerFilterContainer.getEventFilters();
    }

    @Override
    public Integer getExpCache() {
        return this._expCache;
    }

    @Override
    public List<HeaderFilter> getHeaderFilters() {
        return this._invokerFilterContainer.getHeaderFilters();
    }

    @Override
    public Portlet getPortlet() {
        return this._portlet;
    }

    @Override
    public ClassLoader getPortletClassLoader() {
        ClassLoader classLoader = (ClassLoader)this._liferayPortletContext.getAttribute("PLUGIN_CLASS_LOADER");
        if (classLoader == null) {
            classLoader = PortalClassLoaderUtil.getClassLoader();
        }
        return classLoader;
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this._liferayPortletConfig;
    }

    @Override
    public PortletContext getPortletContext() {
        return this._liferayPortletContext;
    }

    @Override
    public Portlet getPortletInstance() {
        return this._portlet;
    }

    @Override
    public List<RenderFilter> getRenderFilters() {
        return this._invokerFilterContainer.getRenderFilters();
    }

    @Override
    public List<ResourceFilter> getResourceFilters() {
        return this._invokerFilterContainer.getResourceFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PortletConfig portletConfig) throws PortletException {
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        this._portletClassLoader = this.getPortletClassLoader();
        try {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(this._portletClassLoader);
            }
            this._portlet.init(portletConfig);
        }
        finally {
            if (this._portletClassLoader != null) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    @Override
    public boolean isCheckAuthToken() {
        return this._checkAuthToken;
    }

    @Override
    public boolean isFacesPortlet() {
        return this._facesPortlet;
    }

    @Override
    public boolean isHeaderPortlet() {
        return this._headerPortlet;
    }

    @Override
    @Deprecated
    public boolean isStrutsBridgePortlet() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isStrutsPortlet() {
        return false;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeAction(actionRequest, actionResponse);
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("processAction for ", this._portletId, " takes ", stopWatch.getTime(), " ms"));
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeEvent(eventRequest, eventResponse);
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("processEvent for ", this._portletId, " takes ", stopWatch.getTime(), " ms"));
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletException portletException = (PortletException)((Object)renderRequest.getAttribute(this._errorKey));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String remoteUser = renderRequest.getRemoteUser();
        if (remoteUser == null || this._expCache == null || this._expCache == 0) {
            this.invokeRender(renderRequest, renderResponse);
        } else {
            String sessionResponseId;
            RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)renderResponseImpl.getHttpServletResponse();
            PortletSession portletSession = renderRequest.getPortletSession();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)renderRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletUtil.getResponses(portletSession);
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletUtil.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)renderRequest)));
            if (response == null) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response = new InvokerPortletResponse(title, bufferCacheServletResponse.getString(), now + 1000L * (long)this._expCache.intValue());
                sessionResponses.put(sessionResponseId, response);
            } else if (response.getTime() < now && this._expCache > 0) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response.setTitle(title);
                response.setContent(bufferCacheServletResponse.getString());
                response.setTime(now + 1000L * (long)this._expCache.intValue());
            } else {
                renderResponseImpl.setTitle(response.getTitle());
                PrintWriter printWriter = bufferCacheServletResponse.getWriter();
                printWriter.print(response.getContent());
            }
        }
        Map<String, String[]> properties = ((RenderResponseImpl)renderResponse).getProperties();
        if (properties.containsKey("clear-request-parameters")) {
            ((RenderRequestImpl)renderRequest).clearRenderParameters();
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("render for ", this._portletId, " takes ", stopWatch.getTime(), " ms"));
        }
    }

    public void renderHeaders(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        PortletException portletException = (PortletException)((Object)headerRequest.getAttribute(this._errorKey));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String remoteUser = headerRequest.getRemoteUser();
        if (remoteUser == null || this._expCache == null || this._expCache == 0) {
            this.invokeHeader(headerRequest, headerResponse);
        } else {
            String sessionResponseId;
            HeaderResponseImpl headerResponseImpl = (HeaderResponseImpl)headerResponse;
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)headerResponseImpl.getHttpServletResponse();
            PortletSession portletSession = headerRequest.getPortletSession();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)headerRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletUtil.getResponses(portletSession);
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletUtil.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)headerRequest)));
            if (response == null) {
                this.invokeHeader(headerRequest, headerResponse);
            } else if (response.getTime() < now && this._expCache > 0) {
                this.invokeHeader(headerRequest, headerResponse);
                response.setContent(bufferCacheServletResponse.getString());
            } else {
                headerResponseImpl.setTitle(response.getTitle());
                PrintWriter printWriter = bufferCacheServletResponse.getWriter();
                printWriter.print(response.getContent());
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("header for", this._portletId, " takes ", stopWatch.getTime(), " ms"));
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeResource(resourceRequest, resourceResponse);
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("serveResource for ", this._portletId, " takes ", stopWatch.getTime(), " ms"));
        }
    }

    @Override
    public void setPortletFilters() {
    }

    protected void invoke(LiferayPortletRequest portletRequest, LiferayPortletResponse portletResponse, String lifecycle, List<? extends PortletFilter> filters) throws IOException, PortletException {
        String[] expCache;
        FilterChainImpl filterChain = new FilterChainImpl(this._portlet, filters);
        if (this._liferayPortletConfig.isWARFile()) {
            String invokerPortletName = this._liferayPortletConfig.getInitParameter("com.liferay.portal.invokerPortletName");
            if (invokerPortletName == null) {
                invokerPortletName = this._liferayPortletConfig.getPortletName();
            }
            String path = "/" + invokerPortletName + "/invoke";
            ServletContext servletContext = this._liferayPortletContext.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            HttpServletRequest httpServletRequest = portletRequest.getHttpServletRequest();
            HttpServletResponse httpServletResponse = portletResponse.getHttpServletResponse();
            httpServletRequest.setAttribute("javax.portlet.portlet", (Object)this._portlet);
            httpServletRequest.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            httpServletRequest.setAttribute("com.liferay.portal.kernel.servlet.PortletServletFilterChain", (Object)filterChain);
            try {
                if (lifecycle.equals("RESOURCE_PHASE")) {
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (ServletException se) {
                Throwable cause = se.getRootCause();
                if (cause instanceof PortletException) {
                    throw (PortletException)cause;
                }
                throw new PortletException(cause);
            }
        } else {
            PortletFilterUtil.doFilter(portletRequest, portletResponse, lifecycle, filterChain);
        }
        portletResponse.transferMarkupHeadElements();
        Map<String, String[]> properties = portletResponse.getProperties();
        if (MapUtil.isNotEmpty(properties) && this._expCache != null && (expCache = properties.get("portlet.expiration-cache")) != null && expCache.length > 0 && expCache[0] != null) {
            this._expCache = GetterUtil.getInteger(expCache[0]);
        }
    }

    protected void invokeAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)actionRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)actionResponse);
        this.invoke(portletRequest, portletResponse, "ACTION_PHASE", this._invokerFilterContainer.getActionFilters());
    }

    protected void invokeEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)eventRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)eventResponse);
        this.invoke(portletRequest, portletResponse, "EVENT_PHASE", this._invokerFilterContainer.getEventFilters());
    }

    protected void invokeHeader(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)headerRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)headerResponse);
        try {
            this.invoke(portletRequest, portletResponse, "HEADER_PHASE", this._invokerFilterContainer.getHeaderFilters());
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)headerRequest, (PortletResponse)headerResponse);
            throw e;
        }
    }

    protected String invokeRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)renderRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)renderResponse);
        try {
            this.invoke(portletRequest, portletResponse, "RENDER_PHASE", this._invokerFilterContainer.getRenderFilters());
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
            throw e;
        }
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
        return renderResponseImpl.getTitle();
    }

    protected void invokeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)resourceRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)resourceResponse);
        this.invoke(portletRequest, portletResponse, "RESOURCE_PHASE", this._invokerFilterContainer.getResourceFilters());
    }

    protected void processException(Exception e, PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletResponse instanceof StateAwareResponseImpl) {
            StateAwareResponseImpl stateAwareResponseImpl = (StateAwareResponseImpl)portletResponse;
            stateAwareResponseImpl.reset();
        }
        if (e instanceof RuntimeException) {
            e = new PortletException(e);
        }
        if (e instanceof UnavailableException) {
            this.destroy();
            PortletLocalServiceUtil.deletePortlet(this._portletModel);
        }
        if (e instanceof PortletException) {
            if (portletResponse instanceof StateAwareResponseImpl && !(e instanceof UnavailableException)) {
                return;
            }
            if (!(portletRequest instanceof RenderRequest)) {
                portletRequest.setAttribute(this._errorKey, (Object)e);
            }
        } else {
            ReflectionUtil.throwException(e);
        }
    }

    private void _initialize(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer, boolean checkAuthToken, boolean facesPortlet, boolean headerPortlet) {
        this._portletModel = portletModel;
        this._portlet = portlet;
        this._invokerFilterContainer = invokerFilterContainer;
        this._checkAuthToken = checkAuthToken;
        this._facesPortlet = facesPortlet;
        this._headerPortlet = headerPortlet;
        this._expCache = portletModel.getExpCache();
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this._liferayPortletContext = (LiferayPortletContext)portletContext;
        this._portletId = this._portletModel.getPortletId();
        this._errorKey = this._portletId.concat(PortletException.class.getName());
        if (_log.isDebugEnabled()) {
            com.liferay.portal.kernel.model.Portlet portletContextPortet = this._liferayPortletContext.getPortlet();
            _log.debug("Create instance cache wrapper for " + portletContextPortet.getPortletId());
        }
    }
}

