/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.internal.FilterConfigImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

public class InvokerFilterContainerImpl
implements Closeable,
InvokerFilterContainer {
    public static final InvokerFilterContainer EMPTY_INVOKER_FILTER_CONTAINER = new EmptyInvokerFilterContainer();
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterContainerImpl.class);
    private final List<ActionFilter> _actionFilters = new CopyOnWriteArrayList<ActionFilter>();
    private final List<EventFilter> _eventFilters = new CopyOnWriteArrayList<EventFilter>();
    private final List<HeaderFilter> _headerFilters = new CopyOnWriteArrayList<HeaderFilter>();
    private final List<RenderFilter> _renderFilters = new CopyOnWriteArrayList<RenderFilter>();
    private final List<ResourceFilter> _resourceFilters = new CopyOnWriteArrayList<ResourceFilter>();
    private final List<ServiceRegistrationTuple> _serviceRegistrationTuples = new CopyOnWriteArrayList<ServiceRegistrationTuple>();
    private final ServiceTracker<PortletFilter, PortletFilter> _serviceTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokerFilterContainerImpl(Portlet portlet, PortletContext portletContext) throws PortletException {
        String rootPortletId = portlet.getRootPortletId();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter(StringBundler.concat("(&(javax.portlet.name=", rootPortletId, ")(objectClass=", PortletFilter.class.getName(), "))"));
        this._serviceTracker = registry.trackServices(filter, new PortletFilterServiceTrackerCustomizer(portletContext));
        this._serviceTracker.open();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.portlet.name", rootPortletId);
        properties.put("preinitialized.filter", Boolean.TRUE);
        Map<String, com.liferay.portal.kernel.model.PortletFilter> portletFilters = portlet.getPortletFilters();
        for (Map.Entry<String, com.liferay.portal.kernel.model.PortletFilter> entry : portletFilters.entrySet()) {
            com.liferay.portal.kernel.model.PortletFilter portletFilterModel = entry.getValue();
            PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
            HashMap<String, Object> portletFilterProperties = new HashMap<String, Object>();
            portletFilterProperties.putAll(properties);
            portletFilterProperties.put("filter.lifecycles", portletFilterModel.getLifecycles());
            ServiceRegistration<PortletFilter> serviceRegistration = registry.registerService(PortletFilter.class, portletFilter, portletFilterProperties);
            ServiceRegistrationTuple serviceRegistrationTuple = new ServiceRegistrationTuple(portletFilterModel, serviceRegistration);
            this._serviceRegistrationTuples.add(serviceRegistrationTuple);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            for (String portletFilterClassName : PropsValues.PORTLET_FILTERS_SYSTEM) {
                PortletFilterImpl portletFilterModel = new PortletFilterImpl(portletFilterClassName, portletFilterClassName, Collections.emptySet(), Collections.emptyMap(), portlet.getPortletApp());
                PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
                ServiceRegistration<PortletFilter> serviceRegistration = registry.registerService(PortletFilter.class, portletFilter, properties);
                this._serviceRegistrationTuples.add(new ServiceRegistrationTuple(portletFilterModel, serviceRegistration));
            }
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void close() {
        for (ServiceRegistrationTuple serviceRegistrationTuple : this._serviceRegistrationTuples) {
            PortletFilterFactory.destroy(serviceRegistrationTuple.getPortletFilterModel());
            ServiceRegistration<PortletFilter> serviceRegistration = serviceRegistrationTuple.getServiceRegistration();
            serviceRegistration.unregister();
        }
        this._serviceRegistrationTuples.clear();
        this._serviceTracker.close();
        this._actionFilters.clear();
        this._eventFilters.clear();
        this._headerFilters.clear();
        this._renderFilters.clear();
        this._resourceFilters.clear();
    }

    @Override
    public List<ActionFilter> getActionFilters() {
        return this._actionFilters;
    }

    @Override
    public List<EventFilter> getEventFilters() {
        return this._eventFilters;
    }

    @Override
    public List<HeaderFilter> getHeaderFilters() {
        return this._headerFilters;
    }

    @Override
    public List<RenderFilter> getRenderFilters() {
        return this._renderFilters;
    }

    @Override
    public List<ResourceFilter> getResourceFilters() {
        return this._resourceFilters;
    }

    private class PortletFilterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortletFilter, PortletFilter> {
        private final PortletContext _portletContext;

        public PortletFilterServiceTrackerCustomizer(PortletContext portletContext) {
            this._portletContext = portletContext;
        }

        @Override
        public PortletFilter addingService(ServiceReference<PortletFilter> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortletFilter portletFilter = registry.getService(serviceReference);
            boolean preinitializedFilter = GetterUtil.getBoolean(serviceReference.getProperty("preinitialized.filter"));
            if (!preinitializedFilter) {
                String filterName = GetterUtil.getString(serviceReference.getProperty("service.id"), ClassUtil.getClassName(portletFilter));
                HashMap<String, String> params = new HashMap<String, String>();
                for (String key : serviceReference.getPropertyKeys()) {
                    if (!key.startsWith("javax.portlet.init-param.")) continue;
                    params.put(key.substring("javax.portlet.init-param.".length()), GetterUtil.getString(serviceReference.getProperty(key)));
                }
                FilterConfigImpl filterConfig = new FilterConfigImpl(filterName, this._portletContext, params);
                try {
                    portletFilter.init((FilterConfig)filterConfig);
                }
                catch (PortletException pe) {
                    _log.error((Object)pe, pe);
                    registry.ungetService(serviceReference);
                    return null;
                }
            }
            Set lifecycles = (Set)serviceReference.getProperty("filter.lifecycles");
            if (portletFilter instanceof ActionFilter && this._isDeclaredLifecycle("ACTION_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._actionFilters.add((ActionFilter)portletFilter);
            }
            if (portletFilter instanceof EventFilter && this._isDeclaredLifecycle("EVENT_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._eventFilters.add((EventFilter)portletFilter);
            }
            if (portletFilter instanceof HeaderFilter && this._isDeclaredLifecycle("HEADER_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._headerFilters.add((HeaderFilter)portletFilter);
            }
            if (portletFilter instanceof RenderFilter && this._isDeclaredLifecycle("RENDER_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._renderFilters.add((RenderFilter)portletFilter);
            }
            if (portletFilter instanceof ResourceFilter && this._isDeclaredLifecycle("RESOURCE_PHASE", lifecycles)) {
                InvokerFilterContainerImpl.this._resourceFilters.add((ResourceFilter)portletFilter);
            }
            return portletFilter;
        }

        @Override
        public void modifiedService(ServiceReference<PortletFilter> serviceReference, PortletFilter portletFilter) {
        }

        @Override
        public void removedService(ServiceReference<PortletFilter> serviceReference, PortletFilter portletFilter) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            InvokerFilterContainerImpl.this._actionFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._eventFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._headerFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._renderFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._resourceFilters.remove(portletFilter);
            boolean preinitializedFilter = GetterUtil.getBoolean(serviceReference.getProperty("preinitialized.filter"));
            if (preinitializedFilter) {
                return;
            }
            portletFilter.destroy();
        }

        private boolean _isDeclaredLifecycle(String lifecycle, Set<String> lifecycles) {
            if (lifecycles == null || lifecycles.isEmpty()) {
                return true;
            }
            return lifecycles.contains(lifecycle);
        }
    }

    private static class ServiceRegistrationTuple {
        private final com.liferay.portal.kernel.model.PortletFilter _portletFilterModel;
        private final ServiceRegistration<PortletFilter> _serviceRegistration;

        public ServiceRegistrationTuple(com.liferay.portal.kernel.model.PortletFilter portletFilterModel, ServiceRegistration<PortletFilter> serviceRegistration) {
            this._portletFilterModel = portletFilterModel;
            this._serviceRegistration = serviceRegistration;
        }

        public com.liferay.portal.kernel.model.PortletFilter getPortletFilterModel() {
            return this._portletFilterModel;
        }

        public ServiceRegistration<PortletFilter> getServiceRegistration() {
            return this._serviceRegistration;
        }
    }

    private static class EmptyInvokerFilterContainer
    implements Closeable,
    InvokerFilterContainer {
        private EmptyInvokerFilterContainer() {
        }

        @Override
        public void close() {
        }

        @Override
        public List<ActionFilter> getActionFilters() {
            return Collections.emptyList();
        }

        @Override
        public List<EventFilter> getEventFilters() {
            return Collections.emptyList();
        }

        @Override
        public List<HeaderFilter> getHeaderFilters() {
            return Collections.emptyList();
        }

        @Override
        public List<RenderFilter> getRenderFilters() {
            return Collections.emptyList();
        }

        @Override
        public List<ResourceFilter> getResourceFilters() {
            return Collections.emptyList();
        }
    }
}

