/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.io.unsync.UnsyncPrintWriter;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.portlet.PortletDependency;
import com.liferay.portal.kernel.model.portlet.PortletDependencyFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayHeaderResponse;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.xml.StAXReaderUtil;
import com.liferay.portlet.internal.MimeResponseImpl;
import com.liferay.portlet.internal.PortletRequestImpl;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.HeaderRequest;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class HeaderResponseImpl
extends MimeResponseImpl
implements LiferayHeaderResponse {
    private static final Log _log = LogFactoryUtil.getLog(HeaderResponseImpl.class);
    private int _bufferSize;
    private boolean _calledFlushBuffer;
    private boolean _calledGetPortletOutputStream;
    private boolean _calledGetWriter;
    private OutputStream _portletOutputStream;
    private PrintWriter _printWriter;

    public void addDependency(String name, String scope, String version) {
        this.addDependency(name, scope, version, null);
    }

    public void addDependency(String name, String scope, String version, String xml) {
        PortletDependency portletDependency;
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        if (Objects.equals(name, "PortletHub") && Objects.equals(scope, "javax.portlet")) {
            return;
        }
        if (xml != null) {
            if ((xml = StringUtil.trim(xml)).isEmpty()) {
                return;
            }
            List<ParsedElement> parsedElements = this._parseElements(xml = HeaderResponseImpl._addClosingTags(xml));
            if (parsedElements.isEmpty()) {
                return;
            }
            if (parsedElements.size() > 1) {
                throw new IllegalArgumentException("More than one element in markup: " + xml);
            }
            ParsedElement parsedElement = parsedElements.get(0);
            if (!parsedElement.isValid()) {
                throw new IllegalArgumentException("Invalid dependency: " + xml);
            }
        }
        if (PortletDependency.Type.OTHER == (portletDependency = PortletDependencyFactoryUtil.createPortletDependency(name, scope, version, xml, this.portletRequestImpl)).getType()) {
            if (xml != null) {
                throw new IllegalArgumentException("Invalid dependency markup: " + xml);
            }
            _log.error("Unable to add dependency: " + portletDependency);
            return;
        }
        Portlet portlet = this.getPortlet();
        if (PortletDependency.Type.CSS == portletDependency.getType() && portlet.isPortletDependencyCssEnabled() || PortletDependency.Type.JAVASCRIPT == portletDependency.getType() && portlet.isPortletDependencyJavaScriptEnabled() || PortletDependency.Type.OTHER == portletDependency.getType()) {
            this._addDependencyToHead(name, scope, version, null, portletDependency);
        }
    }

    @Override
    public void flushBuffer() {
        if (this._printWriter != null) {
            this._printWriter.flush();
        }
        this._calledFlushBuffer = true;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    @Override
    public String getLifecycle() {
        return "HEADER_PHASE";
    }

    @Override
    public OutputStream getPortletOutputStream() {
        if (this._calledGetWriter) {
            throw new IllegalStateException("Unable to obtain OutputStream because Writer is already in use");
        }
        if (this._portletOutputStream == null) {
            this._portletOutputStream = new HeaderOutputStream();
        }
        this._calledGetPortletOutputStream = true;
        return this._portletOutputStream;
    }

    @Override
    public PrintWriter getWriter() {
        if (this._calledGetPortletOutputStream) {
            throw new IllegalStateException("Unable to obtain Writer because OutputStream is already in use");
        }
        if (this._printWriter == null) {
            this._printWriter = new HeaderPrintWriter(new UnsyncStringWriter());
        }
        this._calledGetWriter = true;
        return this._printWriter;
    }

    public void init(PortletRequestImpl portletRequestImpl, HttpServletResponse httpServletResponse, List<PortletDependency> portletDependencies) {
        super.init(portletRequestImpl, httpServletResponse);
        if (portletDependencies != null) {
            for (PortletDependency portletDependency : portletDependencies) {
                this.addDependency(portletDependency.getName(), portletDependency.getScope(), portletDependency.getVersion());
            }
        }
    }

    @Override
    public boolean isCalledFlushBuffer() {
        return this._calledFlushBuffer;
    }

    @Override
    public boolean isCalledGetPortletOutputStream() {
        return this._calledGetPortletOutputStream;
    }

    @Override
    public boolean isCalledGetWriter() {
        return this._calledGetWriter;
    }

    @Override
    public boolean isCommitted() {
        return this._calledFlushBuffer || super.isCommitted();
    }

    @Override
    public void reset() {
        if (this._calledFlushBuffer) {
            throw new IllegalStateException("Unable to reset a buffer that has been flushed");
        }
        this._portletOutputStream = null;
        this._printWriter = null;
    }

    @Override
    public void resetBuffer() {
        this.reset();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        if (this._calledFlushBuffer) {
            throw new IllegalStateException("Unable to set buffer size because buffer has been flushed");
        }
        this._bufferSize = bufferSize;
    }

    @Override
    public void setContentType(String contentType) {
        if (this._printWriter != null || this._portletOutputStream != null) {
            return;
        }
        super.setContentType(contentType);
    }

    public void setTitle(String title) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.portletRequestImpl.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        portletDisplay.setTitle(title);
    }

    @Override
    public void writeToHead() {
        if (this._portletOutputStream != null) {
            this._addXMLToHead(this.portletName, this.getNamespace(), this._portletOutputStream.toString());
        } else if (this._printWriter != null) {
            this._addXMLToHead(this.portletName, this.getNamespace(), this._printWriter.toString());
        }
    }

    private static String _addClosingTags(String xml) {
        xml = HeaderResponseImpl._addClosingTags(xml, "<link", "</link>");
        xml = HeaderResponseImpl._addClosingTags(xml, "<LINK", "</LINK>");
        xml = HeaderResponseImpl._addClosingTags(xml, "<meta", "</meta>");
        xml = HeaderResponseImpl._addClosingTags(xml, "<META", "</META>");
        return xml;
    }

    private static String _addClosingTags(String xml, String opening, String closing) {
        int openingEnd;
        StringBundler sb = null;
        int fromIndex = 0;
        int index = 0;
        int sbIndex = 0;
        while ((index = xml.indexOf(opening, fromIndex)) != -1 && (openingEnd = xml.indexOf(62, index)) != -1) {
            fromIndex = openingEnd + 1;
            if (xml.regionMatches(fromIndex, closing, 0, closing.length())) {
                fromIndex += closing.length();
                continue;
            }
            if (sb == null) {
                sb = new StringBundler();
            }
            if (xml.charAt(openingEnd - 1) == '/') {
                sb.append(xml.substring(sbIndex, fromIndex - 2));
                sb.append(">");
            } else {
                sb.append(xml.substring(sbIndex, fromIndex));
            }
            sbIndex = fromIndex;
            sb.append(closing);
        }
        if (sb == null) {
            return xml;
        }
        sb.append(xml.substring(sbIndex));
        return sb.toString();
    }

    private void _addDependencyToHead(String name, String scope, String version, ParsedElement parsedElement, PortletDependency portletDependency) {
        if (Validator.isNull(scope)) {
            scope = "";
        }
        SemVer semVer = SemVer._DEFAULT;
        String versionKey = version;
        if (Validator.isNull(version)) {
            versionKey = StringUtil.randomId();
        } else {
            semVer = new SemVer(version);
        }
        HeaderRequest headerRequest = (HeaderRequest)this.getPortletRequest();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)headerRequest);
        OutputData outputData = (OutputData)httpServletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
        if (outputData == null) {
            outputData = new OutputData();
            httpServletRequest.setAttribute("LIFERAY_SHARED_OUTPUT_DATA", (Object)outputData);
        }
        Set<String> outputKeys = outputData.getOutputKeys();
        Iterator<String> iterator = outputKeys.iterator();
        while (iterator.hasNext()) {
            String existingKey = iterator.next();
            String[] existingKeyParts = StringUtil.split(existingKey, ':');
            if (existingKeyParts.length != 3) continue;
            String existingName = existingKeyParts[0];
            String existingScope = existingKeyParts[1];
            if (!name.equals(existingName) || !scope.equals(existingScope)) continue;
            String existingVersion = existingKeyParts[2];
            SemVer existingSemVer = new SemVer(existingVersion);
            if (existingSemVer.compareTo(semVer) >= 0) break;
            iterator.remove();
            outputData.setDataSB(existingKey, "PAGE_TOP", null);
            break;
        }
        StringBundler sb = new StringBundler(5);
        sb.append(name);
        sb.append(":");
        sb.append(scope);
        sb.append(":");
        sb.append(versionKey);
        String outputKey = sb.toString();
        if (outputData.addOutputKey(outputKey)) {
            if (parsedElement != null) {
                outputData.addDataSB(outputKey, "PAGE_TOP", parsedElement.toStringBundler());
            } else if (portletDependency != null) {
                outputData.addDataSB(outputKey, "PAGE_TOP", portletDependency.toStringBundler());
            }
        }
    }

    private void _addXMLToHead(String name, String scope, String xml) {
        if (Validator.isBlank(xml = StringUtil.trim(xml))) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Markup before conversion to well-formed XML:" + xml);
        }
        if (!xml.startsWith("<head>")) {
            xml = "<head>".concat(xml);
        }
        if (!xml.endsWith("</head>")) {
            xml = xml.concat("</head>");
        }
        xml = HeaderResponseImpl._addClosingTags(xml);
        if (_log.isDebugEnabled()) {
            _log.debug("Markup after conversion to well-formed XML:" + xml);
        }
        for (ParsedElement parsedElement : this._parseElements(xml)) {
            this._addDependencyToHead(name, scope, null, parsedElement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ParsedElement> _parseElements(String xml) {
        ArrayList<ParsedElement> parsedElements = new ArrayList<ParsedElement>();
        XMLStreamReader xmlStreamReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(new UnsyncStringReader(xml));
            LinkedHashMap<String, String> elementAttributeValues = null;
            String elementName = null;
            StringBundler elementTextSB = null;
            while (xmlStreamReader.hasNext()) {
                String localName;
                int event = xmlStreamReader.next();
                if (elementTextSB == null) {
                    elementTextSB = new StringBundler();
                }
                if (event == 4) {
                    String text = xmlStreamReader.getText();
                    if (text == null || (text = StringUtil.trim(text)).isEmpty()) continue;
                    elementTextSB.append(text);
                    continue;
                }
                if (event == 5) {
                    if (elementName == null) continue;
                    elementTextSB.append("\n<!--");
                    elementTextSB.append(xmlStreamReader.getText());
                    elementTextSB.append("-->");
                    continue;
                }
                if (event == 2) {
                    if (elementName == null) continue;
                    parsedElements.add(new ParsedElement(elementName, elementAttributeValues, elementTextSB.toString(), true));
                    elementAttributeValues = null;
                    elementName = null;
                    elementTextSB.setIndex(0);
                    continue;
                }
                if (event != 1 || (localName = xmlStreamReader.getLocalName()).equals("head")) continue;
                if (localName.equals("link") || localName.equals("meta") || localName.equals("script") || localName.equals("style")) {
                    elementName = localName;
                    elementAttributeValues = new LinkedHashMap<String, String>();
                    int attributeCount = xmlStreamReader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        elementAttributeValues.put(xmlStreamReader.getAttributeLocalName(i), xmlStreamReader.getAttributeValue(i));
                    }
                    continue;
                }
                throw new XMLStreamException("Invalid element: " + localName);
            }
        }
        catch (XMLStreamException xmlse) {
            _log.error(xmlse, xmlse);
            parsedElements.add(new ParsedElement(null, null, null, false));
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (XMLStreamException xmlse) {
                    _log.error(xmlse, xmlse);
                }
            }
        }
        return parsedElements;
    }

    private class HeaderPrintWriter
    extends UnsyncPrintWriter {
        private final UnsyncStringWriter _unsyncStringWriter;

        public String toString() {
            return this._unsyncStringWriter.toString();
        }

        private HeaderPrintWriter(UnsyncStringWriter unsyncStringWriter) {
            super(unsyncStringWriter);
            this._unsyncStringWriter = unsyncStringWriter;
        }
    }

    private class HeaderOutputStream
    extends UnsyncByteArrayOutputStream {
        private HeaderOutputStream() {
        }

        @Override
        public String toString() {
            try {
                return this.toString(HeaderResponseImpl.this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                _log.error(uee, uee);
                return "";
            }
        }
    }

    private static class SemVer
    implements Comparable<SemVer> {
        private static final SemVer _DEFAULT = new SemVer(0, 0, 0);
        private final int _major;
        private final int _micro;
        private final int _minor;

        @Override
        public int compareTo(SemVer semVer) {
            int result = Integer.compare(this._major, semVer._major);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(this._minor, semVer._minor);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this._micro, semVer._micro);
        }

        private SemVer(int major, int minor, int micro) {
            this._major = major;
            this._minor = minor;
            this._micro = micro;
        }

        private SemVer(String version) {
            String[] parts = StringUtil.split(version, '.');
            this._major = parts.length > 0 ? GetterUtil.getInteger(parts[0]) : 0;
            this._minor = parts.length > 1 ? GetterUtil.getInteger(parts[1]) : 0;
            this._micro = parts.length > 2 ? GetterUtil.getInteger(parts[2]) : 0;
        }
    }

    private static class ParsedElement {
        private final Map<String, String> _attributes;
        private final String _name;
        private final String _text;
        private final boolean _valid;

        public boolean isValid() {
            return this._valid;
        }

        public StringBundler toStringBundler() {
            StringBundler sb = new StringBundler(this._attributes.size() * 5 + 7);
            sb.append("\n<");
            sb.append(this._name);
            for (Map.Entry<String, String> entry : this._attributes.entrySet()) {
                sb.append(" ");
                sb.append(entry.getKey());
                sb.append("=\"");
                sb.append(entry.getValue());
                sb.append("\"");
            }
            sb.append(">");
            if (!Objects.equals(this._name, "link") && !Objects.equals(this._name, "meta")) {
                if (this._text != null) {
                    sb.append(this._text);
                }
                sb.append("\n</");
                sb.append(this._name);
                sb.append(">");
            }
            return sb;
        }

        private ParsedElement(String name, Map<String, String> attributes, String text, boolean valid) {
            this._name = name;
            this._attributes = attributes == null ? Collections.emptyMap() : attributes;
            this._text = text;
            this._valid = valid;
        }
    }
}

