/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portlet.internal.RouterImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerFieldUpdaterCustomizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FriendlyURLMapperTrackerImpl
implements FriendlyURLMapperTracker {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLMapperTrackerImpl.class);
    private volatile FriendlyURLMapper _friendlyURLMapper;
    private final Portlet _portlet;
    private final Map<FriendlyURLMapper, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final ServiceTracker<FriendlyURLMapper, FriendlyURLMapper> _serviceTracker;

    public FriendlyURLMapperTrackerImpl(Portlet portlet) throws Exception {
        this._portlet = portlet;
        Registry registry = RegistryUtil.getRegistry();
        String filterString = null;
        String portletId = portlet.getPortletId();
        String portletName = portlet.getPortletName();
        filterString = portletId.equals(portletName) ? StringBundler.concat("(&(javax.portlet.name=", portletId, ")(objectClass=", FriendlyURLMapper.class.getName(), "))") : StringBundler.concat("(&(|(javax.portlet.name=", portletId, ")(javax.portlet.name=", portletName, "))(objectClass=", FriendlyURLMapper.class.getName(), "))");
        this._serviceTracker = registry.trackServices(registry.getFilter(filterString), new FriendlyURLMapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Override
    public void close() {
        for (Map.Entry<FriendlyURLMapper, ServiceRegistration<?>> entry : this._serviceRegistrations.entrySet()) {
            ServiceRegistration<?> serviceRegistration = entry.getValue();
            serviceRegistration.unregister();
        }
        this._serviceTracker.close();
    }

    @Override
    public FriendlyURLMapper getFriendlyURLMapper() {
        return this._friendlyURLMapper;
    }

    @Override
    public void register(FriendlyURLMapper friendlyURLMapper) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.portlet.name", this._portlet.getPortletId());
        ServiceRegistration<FriendlyURLMapper> serviceRegistration = registry.registerService(FriendlyURLMapper.class, friendlyURLMapper, properties);
        this._serviceRegistrations.put(friendlyURLMapper, serviceRegistration);
    }

    @Override
    public void unregister(FriendlyURLMapper friendlyURLMapper) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(friendlyURLMapper);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    protected String getContent(ClassLoader classLoader, String fileName) throws Exception {
        String queryString = HttpUtil.getQueryString(fileName);
        if (Validator.isNull(queryString)) {
            return StringUtil.read(classLoader, fileName);
        }
        int pos = fileName.indexOf("?");
        String xml = StringUtil.read(classLoader, fileName.substring(0, pos));
        Map<String, String[]> parameterMap = HttpUtil.getParameterMap(queryString);
        if (parameterMap == null) {
            return xml;
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values = entry.getValue();
            if (values.length == 0) continue;
            String value = values[0];
            xml = StringUtil.replace(xml, "@" + entry.getKey() + "@", value);
        }
        return xml;
    }

    private class FriendlyURLMapperServiceTrackerCustomizer
    extends ServiceTrackerFieldUpdaterCustomizer<FriendlyURLMapper, FriendlyURLMapper> {
        @Override
        protected FriendlyURLMapper doAddingService(ServiceReference<FriendlyURLMapper> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            FriendlyURLMapper friendlyURLMapper = registry.getService(serviceReference);
            try {
                if (Validator.isNotNull(FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping())) {
                    friendlyURLMapper.setMapping(FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping());
                }
                friendlyURLMapper.setPortletId(FriendlyURLMapperTrackerImpl.this._portlet.getPortletId());
                friendlyURLMapper.setPortletInstanceable(FriendlyURLMapperTrackerImpl.this._portlet.isInstanceable());
                String friendlyURLRoutes = (String)serviceReference.getProperty("com.liferay.portlet.friendly-url-routes");
                if (Validator.isNotNull(FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes())) {
                    friendlyURLRoutes = FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes();
                }
                String xml = null;
                if (Validator.isNotNull(friendlyURLRoutes)) {
                    Class<?> clazz = friendlyURLMapper.getClass();
                    xml = FriendlyURLMapperTrackerImpl.this.getContent(clazz.getClassLoader(), friendlyURLRoutes);
                }
                friendlyURLMapper.setRouter(this.newFriendlyURLRouter(xml));
            }
            catch (Exception e) {
                _log.error(e, e);
                return null;
            }
            return friendlyURLMapper;
        }

        protected Router newFriendlyURLRouter(String xml) throws Exception {
            if (Validator.isNull(xml)) {
                return null;
            }
            Document document = UnsecureSAXReaderUtil.read(xml, true);
            Element rootElement = document.getRootElement();
            List<Element> routeElements = rootElement.elements("route");
            RouterImpl router = new RouterImpl(routeElements.size());
            for (Element routeElement : routeElements) {
                String value;
                String name;
                String pattern = routeElement.elementText("pattern");
                Route route = router.addRoute(pattern);
                for (Element generatedParameterElement : routeElement.elements("generated-parameter")) {
                    name = generatedParameterElement.attributeValue("name");
                    value = generatedParameterElement.getText();
                    route.addGeneratedParameter(name, value);
                }
                for (Element ignoredParameterElement : routeElement.elements("ignored-parameter")) {
                    name = ignoredParameterElement.attributeValue("name");
                    route.addIgnoredParameter(name);
                }
                for (Element implicitParameterElement : routeElement.elements("implicit-parameter")) {
                    name = implicitParameterElement.attributeValue("name");
                    value = implicitParameterElement.getText();
                    route.addImplicitParameter(name, value);
                }
                for (Element overriddenParameterElement : routeElement.elements("overridden-parameter")) {
                    name = overriddenParameterElement.attributeValue("name");
                    value = overriddenParameterElement.getText();
                    route.addOverriddenParameter(name, value);
                }
            }
            return router;
        }

        private FriendlyURLMapperServiceTrackerCustomizer() throws Exception {
            super(ReflectionUtil.getDeclaredField(FriendlyURLMapperTrackerImpl.class, "_friendlyURLMapper"), FriendlyURLMapperTrackerImpl.this, null);
        }
    }
}

