/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.servlet.Header;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portlet.internal.MimeResponseImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.CacheControl;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CacheControlImpl
implements CacheControl {
    private String _eTag;
    private int _expirationTime;
    private final MimeResponseImpl _mimeResponseImpl;
    private boolean _publicScope;
    private boolean _useCachedContent;

    public CacheControlImpl(String eTag, int expirationTime, boolean publicScope, boolean useCachedContent, MimeResponseImpl mimeResponseImpl) {
        this._eTag = eTag;
        this._expirationTime = expirationTime;
        this._publicScope = publicScope;
        this._useCachedContent = useCachedContent;
        this._mimeResponseImpl = mimeResponseImpl;
    }

    public String getETag() {
        return this._eTag;
    }

    public int getExpirationTime() {
        return this._expirationTime;
    }

    public boolean isPublicScope() {
        return this._publicScope;
    }

    public void setETag(String eTag) {
        HttpServletResponse httpServletResponse;
        this._eTag = eTag;
        if (eTag == null && (httpServletResponse = this._mimeResponseImpl.getHttpServletResponse()).getHeader("portlet.ETag") != null) {
            this._removeETag(httpServletResponse);
            return;
        }
        this._mimeResponseImpl.setProperty("portlet.ETag", eTag);
    }

    public void setExpirationTime(int expirationTime) {
        this._expirationTime = expirationTime;
        this._mimeResponseImpl.setProperty("portlet.expiration-cache", String.valueOf(expirationTime));
    }

    public void setPublicScope(boolean publicScope) {
        this._publicScope = publicScope;
        this._mimeResponseImpl.setProperty("portlet.public-scope", String.valueOf(publicScope));
    }

    public void setUseCachedContent(boolean useCachedContent) {
        this._useCachedContent = useCachedContent;
        this._mimeResponseImpl.setProperty("portlet.use-cached-content", String.valueOf(useCachedContent));
    }

    public boolean useCachedContent() {
        return this._useCachedContent;
    }

    private void _removeETag(HttpServletResponse httpServletResponse) {
        while (httpServletResponse instanceof HttpServletResponseWrapper) {
            if (httpServletResponse instanceof MetaInfoCacheServletResponse) {
                MetaInfoCacheServletResponse metaInfoCacheServletResponse = (MetaInfoCacheServletResponse)httpServletResponse;
                Map<String, Set<Header>> headers = metaInfoCacheServletResponse.getHeaders();
                headers.remove("portlet.ETag");
            }
            HttpServletResponseWrapper httpServletResponseWrapper = (HttpServletResponseWrapper)httpServletResponse;
            ServletResponse servletResponse = httpServletResponseWrapper.getResponse();
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        HashMap<String, Collection> headers = new HashMap<String, Collection>();
        Collection headerNames = httpServletResponse.getHeaderNames();
        for (String headerName : headerNames) {
            if (headerName.equals("portlet.ETag")) continue;
            headers.put(headerName, httpServletResponse.getHeaders(headerName));
        }
        String characterEncoding = httpServletResponse.getCharacterEncoding();
        String contentType = httpServletResponse.getContentType();
        Locale locale = httpServletResponse.getLocale();
        int status = httpServletResponse.getStatus();
        httpServletResponse.reset();
        for (Map.Entry headerEntry : headers.entrySet()) {
            String headerName = (String)headerEntry.getKey();
            for (String header : (Collection)headerEntry.getValue()) {
                httpServletResponse.addHeader(headerName, header);
            }
        }
        if (characterEncoding != null) {
            httpServletResponse.setCharacterEncoding(characterEncoding);
        }
        if (contentType != null) {
            httpServletResponse.setContentType(contentType);
        }
        if (locale != null) {
            httpServletResponse.setLocale(locale);
        }
        if (status != 200) {
            httpServletResponse.setStatus(status);
        }
    }
}

