/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portlet.internal.BasePortletParametersImpl;
import com.liferay.portlet.internal.LiferayMutablePortletParameters;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.portlet.MutablePortletParameters;
import javax.portlet.PortletParameters;

public abstract class BaseMutablePortletParameters<T extends MutablePortletParameters>
extends BasePortletParametersImpl<T>
implements LiferayMutablePortletParameters {
    private boolean _mutated;

    public BaseMutablePortletParameters(Map<String, String[]> parameterMap, Function<Map<String, String[]>, T> mutablePortletParametersCreator) {
        super(parameterMap, null, mutablePortletParametersCreator);
    }

    public MutablePortletParameters add(PortletParameters portletParameters) {
        Object oldMutablePortletParameters = this.clone();
        Map<String, String[]> parameterMap = this.getParameterMap();
        if (portletParameters instanceof BasePortletParametersImpl) {
            BasePortletParametersImpl basePortletParametersImpl = (BasePortletParametersImpl)portletParameters;
            Map<String, String[]> liferayPortletParametersMap = basePortletParametersImpl.getParameterMap();
            for (Map.Entry<String, String[]> entry : liferayPortletParametersMap.entrySet()) {
                String[] values = entry.getValue();
                String[] copiedValues = (String[])values.clone();
                parameterMap.put(entry.getKey(), copiedValues);
            }
        } else {
            for (String newParameterName : portletParameters.getNames()) {
                String[] values = portletParameters.getValues(newParameterName);
                String[] copiedValues = (String[])values.clone();
                parameterMap.put(newParameterName, copiedValues);
            }
        }
        this._mutated = true;
        return oldMutablePortletParameters;
    }

    public void clear() {
        Map<String, String[]> parameterMap = this.getParameterMap();
        parameterMap.clear();
        this._mutated = true;
    }

    @Override
    public boolean isMutated() {
        return this._mutated;
    }

    public boolean removeParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map<String, String[]> parameterMap = this.getParameterMap();
        if (parameterMap.containsKey(name)) {
            parameterMap.remove(name);
            this._mutated = true;
            return true;
        }
        return false;
    }

    public MutablePortletParameters set(PortletParameters portletParameters) {
        Object oldMutablePortletParameters = this.clone();
        Set oldParameterNames = oldMutablePortletParameters.getNames();
        if (portletParameters instanceof BasePortletParametersImpl) {
            BasePortletParametersImpl basePortletParametersImpl = (BasePortletParametersImpl)portletParameters;
            Map<String, String[]> liferayPortletParametersMap = basePortletParametersImpl.getParameterMap();
            if (oldParameterNames.isEmpty() && liferayPortletParametersMap.isEmpty()) {
                return oldMutablePortletParameters;
            }
            Map<String, String[]> parameterMap = this.getParameterMap();
            parameterMap.clear();
            for (Map.Entry<String, String[]> entry : liferayPortletParametersMap.entrySet()) {
                String[] values = entry.getValue();
                String[] copiedValues = (String[])values.clone();
                parameterMap.put(entry.getKey(), copiedValues);
            }
        } else {
            Set newParameterNames = portletParameters.getNames();
            if (oldParameterNames.isEmpty() && newParameterNames.isEmpty()) {
                return oldMutablePortletParameters;
            }
            Map<String, String[]> parameterMap = this.getParameterMap();
            parameterMap.clear();
            for (String newParameterName : newParameterNames) {
                String[] values = portletParameters.getValues(newParameterName);
                String[] copiedValues = (String[])values.clone();
                parameterMap.put(newParameterName, copiedValues);
            }
        }
        this._mutated = true;
        return oldMutablePortletParameters;
    }

    public String setValue(String name, String value) {
        String[] oldValues = this.setValues(name, value);
        this._mutated = true;
        if (oldValues != null && oldValues.length > 0) {
            return oldValues[0];
        }
        return null;
    }

    @Override
    public String setValue(String name, String value, boolean append) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String[] oldValues = this.getValues(name);
        if (value == null) {
            this.removeParameter(name);
        } else {
            Map<String, String[]> parameterMap = this.getParameterMap();
            if (append && oldValues != null) {
                String[] newValues = ArrayUtil.append(oldValues, value);
                parameterMap.put(name, newValues);
            } else {
                parameterMap.put(name, new String[]{value});
            }
        }
        this._mutated = true;
        if (oldValues != null && oldValues.length > 0) {
            return oldValues[0];
        }
        return null;
    }

    public String[] setValues(String name, String ... values) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._mutated = true;
        Map<String, String[]> parameterMap = this.getParameterMap();
        return parameterMap.put(name, values);
    }

    @Override
    public String[] setValues(String name, String[] values, boolean append) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String[] oldValues = this.getValues(name);
        if (values == null) {
            this.removeParameter(name);
        } else {
            Map<String, String[]> parameterMap = this.getParameterMap();
            if (append && oldValues != null) {
                String[] newValues = ArrayUtil.append(oldValues, values);
                parameterMap.put(name, newValues);
            } else {
                parameterMap.put(name, values);
            }
        }
        this._mutated = true;
        return oldValues;
    }
}

