/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.StagingServiceBaseImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class StagingServiceImpl
extends StagingServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(StagingServiceImpl.class);

    @Override
    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive(true);
        try {
            this.checkPermission(stagingRequestId);
            this.stagingLocalService.cleanUpStagingRequest(stagingRequestId);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug("StagingServiceImpl#cleanUpStagingRequest(" + stagingRequestId + ")", pe);
            }
            throw pe;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive(stagingInProcessOnLive);
        }
    }

    @Override
    public long createStagingRequest(long groupId, String checksum) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive(true);
        try {
            GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_LAYOUTS");
            long l = this.stagingLocalService.createStagingRequest(this.getUserId(), groupId, checksum);
            return l;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("StagingServiceImpl#createStagingRequest(", groupId, ", ", checksum, ")"), pe);
            }
            throw pe;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive(stagingInProcessOnLive);
        }
    }

    @Override
    public boolean hasRemoteLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        try {
            GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_LAYOUTS");
            return this.layoutLocalService.hasLayout(uuid, groupId, privateLayout);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("StagingServiceImpl#hasRemoteLayout(", uuid, ", ", groupId, ", ", privateLayout, ")"), pe);
            }
            throw pe;
        }
    }

    @Override
    public void propagateExportImportLifecycleEvent(int code, int processFlag, String processId, List<Serializable> arguments) throws PortalException {
        try {
            Serializable serializable = arguments.get(0);
            long groupId = 0L;
            if (serializable instanceof PortletDataContext) {
                PortletDataContext portletDataContext = (PortletDataContext)serializable;
                groupId = portletDataContext.getGroupId();
            } else if (serializable instanceof ExportImportConfiguration) {
                ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)serializable;
                groupId = MapUtil.getLong(exportImportConfiguration.getSettingsMap(), "targetGroupId");
            }
            GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "EXPORT_IMPORT_LAYOUTS");
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(code, processFlag, processId, arguments.toArray(new Serializable[0]));
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(9);
                sb.append("StagingServiceImpl#propagateExportImportLifecycleEvent(");
                sb.append(code);
                sb.append(", ");
                sb.append(processFlag);
                sb.append(", ");
                sb.append(processId);
                sb.append(", ");
                sb.append(arguments);
                sb.append(")");
                _log.debug(sb.toString(), pe);
            }
            throw pe;
        }
    }

    @Override
    @Deprecated
    public MissingReferences publishStagingRequest(long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        this.checkPermission(stagingRequestId);
        return this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, privateLayout, parameterMap);
    }

    @Override
    public MissingReferences publishStagingRequest(long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive(true);
        try {
            this.checkPermission(stagingRequestId);
            MissingReferences missingReferences = this.stagingLocalService.publishStagingRequest(this.getUserId(), stagingRequestId, exportImportConfiguration);
            return missingReferences;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("StagingServiceImpl#publishStagingRequest(", stagingRequestId, ", ", exportImportConfiguration, ")"), pe);
            }
            throw pe;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive(stagingInProcessOnLive);
        }
    }

    @Override
    public void updateStagingRequest(long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive(true);
        try {
            this.checkPermission(stagingRequestId);
            this.stagingLocalService.updateStagingRequest(this.getUserId(), stagingRequestId, fileName, bytes);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("StagingServiceImpl#updateStagingRequest(", stagingRequestId, ", ", fileName, ", ", bytes.length, "bytes)"), pe);
            }
            throw pe;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive(stagingInProcessOnLive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public MissingReferences validateStagingRequest(long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        boolean stagingInProcessOnLive = ExportImportThreadLocal.isStagingInProcessOnRemoteLive();
        ExportImportThreadLocal.setStagingInProcessOnRemoteLive(true);
        try {
            this.checkPermission(stagingRequestId);
            MissingReferences missingReferences = this.stagingLocalService.validateStagingRequest(this.getUserId(), stagingRequestId, privateLayout, parameterMap);
            return missingReferences;
        }
        finally {
            ExportImportThreadLocal.setStagingInProcessOnRemoteLive(stagingInProcessOnLive);
        }
    }

    protected void checkPermission(long stagingRequestId) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder(stagingRequestId);
        GroupPermissionUtil.check(this.getPermissionChecker(), folder.getGroupId(), "EXPORT_IMPORT_LAYOUTS");
    }
}

