/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactoryUtil;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingURLHelperUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.IndexStatusManagerThreadLocal;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portlet.exportimport.service.base.StagingLocalServiceBaseImpl;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;

public class StagingLocalServiceImpl
extends StagingLocalServiceBaseImpl {
    private static final String _ASSEMBLED_LAR_PREFIX = "assembled_";
    private static final String _PORTLET_REPOSITORY_ID = "134";
    private static final Log _log = LogFactoryUtil.getLog(StagingLocalServiceImpl.class);

    @Override
    public void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws PortalException {
        long targetGroupId = 0L;
        if (remote) {
            targetGroupId = liveGroup.getGroupId();
        } else {
            Group stagingGroup = liveGroup.getStagingGroup();
            if (stagingGroup == null) {
                return;
            }
            targetGroupId = stagingGroup.getGroupId();
        }
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, false, "main-variation");
        if (branchingPublic && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), false, serviceContext);
        } else if (!branchingPublic && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, false);
        } else if (layoutSetBranch != null) {
            ExportImportDateUtil.clearLastPublishDate(targetGroupId, false);
        }
        layoutSetBranch = this.layoutSetBranchLocalService.fetchLayoutSetBranch(targetGroupId, true, "main-variation");
        if (branchingPrivate && layoutSetBranch == null) {
            this.addDefaultLayoutSetBranch(userId, targetGroupId, liveGroup.getDescriptiveName(), true, serviceContext);
        } else if (!branchingPrivate && layoutSetBranch != null) {
            this.deleteLayoutSetBranches(targetGroupId, true);
        } else if (layoutSetBranch != null) {
            ExportImportDateUtil.clearLastPublishDate(targetGroupId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException {
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly(true);
        try {
            PortletFileRepositoryUtil.deletePortletFolder(stagingRequestId);
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to clean up staging request " + stagingRequestId, nsfe);
            }
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly(indexReadOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createStagingRequest(long userId, long groupId, String checksum) throws PortalException {
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly(true);
        try {
            ServiceContext serviceContext = new ServiceContext();
            Repository repository = PortletFileRepositoryUtil.addPortletRepository(groupId, _PORTLET_REPOSITORY_ID, serviceContext);
            Folder folder = PortletFileRepositoryUtil.addPortletFolder(userId, repository.getRepositoryId(), 0L, checksum, serviceContext);
            long l = folder.getFolderId();
            return l;
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly(indexReadOnly);
        }
    }

    @Override
    public void disableStaging(Group liveGroup, ServiceContext serviceContext) throws PortalException {
        this.disableStaging(null, liveGroup, serviceContext);
    }

    @Override
    public void disableStaging(PortletRequest portletRequest, Group liveGroup, ServiceContext serviceContext) throws PortalException {
        if (liveGroup.isLayout()) {
            this.disableStaging(portletRequest, liveGroup.getParentGroup(), serviceContext);
            return;
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        boolean stagedLocally = GetterUtil.getBoolean(typeSettingsProperties.getProperty("staged"));
        boolean stagedRemotely = GetterUtil.getBoolean(typeSettingsProperties.getProperty("stagedRemotely"));
        if (!stagedLocally && !stagedRemotely) {
            return;
        }
        if (stagedRemotely) {
            String remoteURL = StagingURLHelperUtil.buildRemoteURL(typeSettingsProperties);
            long remoteGroupId = GetterUtil.getLong(typeSettingsProperties.getProperty("remoteGroupId"));
            boolean forceDisable = GetterUtil.getBoolean(serviceContext.getAttribute("forceDisable"));
            this.disableRemoteStaging(remoteURL, remoteGroupId, forceDisable);
        }
        typeSettingsProperties.remove("branchingPrivate");
        typeSettingsProperties.remove("branchingPublic");
        typeSettingsProperties.remove("remoteAddress");
        typeSettingsProperties.remove("remoteGroupId");
        typeSettingsProperties.remove("remotePathContext");
        typeSettingsProperties.remove("remotePort");
        typeSettingsProperties.remove("secureConnection");
        typeSettingsProperties.remove("staged");
        typeSettingsProperties.remove("stagedRemotely");
        HashSet<String> keys = new HashSet<String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            typeSettingsProperties.remove(key);
        }
        StagingUtil.deleteLastImportSettings(liveGroup, true);
        StagingUtil.deleteLastImportSettings(liveGroup, false);
        this.checkDefaultLayoutSetBranches(serviceContext.getUserId(), liveGroup, false, false, stagedRemotely, serviceContext);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            this.groupLocalService.deleteGroup(stagingGroup.getGroupId());
            liveGroup.clearStagingGroup();
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
    }

    @Override
    public void enableLocalStaging(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, ServiceContext serviceContext) throws PortalException {
        if (StagingUtil.isChangeTrackingEnabled(liveGroup.getCompanyId())) {
            return;
        }
        if (liveGroup.isLayout()) {
            this.enableLocalStaging(userId, liveGroup.getParentGroup(), branchingPublic, branchingPrivate, serviceContext);
            return;
        }
        if (liveGroup.isStagedRemotely()) {
            this.disableStaging(liveGroup, serviceContext);
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        boolean hasStagingGroup = liveGroup.hasStagingGroup();
        if (!hasStagingGroup) {
            serviceContext.setAttribute("staging", (Serializable)((Object)Boolean.TRUE.toString()));
            String languageId = typeSettingsProperties.getProperty("languageId");
            if (Validator.isNotNull(languageId)) {
                serviceContext.setLanguageId(languageId);
            }
            this.addStagingGroup(userId, liveGroup, serviceContext);
        }
        this.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, false, serviceContext);
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        if (!hasStagingGroup) {
            typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsProperties.setProperty("stagedRemotely", Boolean.FALSE.toString());
            this.setCommonStagingOptions(typeSettingsProperties, serviceContext);
        }
        this.groupLocalService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
        if (!hasStagingGroup) {
            Group stagingGroup = liveGroup.getStagingGroup();
            Map<String, String[]> parameterMap = ExportImportConfigurationParameterMapFactoryUtil.buildFullPublishParameterMap();
            if (liveGroup.hasPrivateLayouts()) {
                StagingUtil.publishLayouts(userId, liveGroup.getGroupId(), stagingGroup.getGroupId(), true, parameterMap);
                parameterMap = ExportImportConfigurationParameterMapFactoryUtil.buildParameterMap();
            }
            if (liveGroup.hasPublicLayouts() || !liveGroup.hasPrivateLayouts()) {
                StagingUtil.publishLayouts(userId, liveGroup.getGroupId(), stagingGroup.getGroupId(), false, parameterMap);
            }
        }
    }

    @Override
    public void enableRemoteStaging(long userId, Group stagingGroup, boolean branchingPublic, boolean branchingPrivate, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, ServiceContext serviceContext) throws PortalException {
        boolean stagedRemotely;
        if (StagingUtil.isChangeTrackingEnabled(stagingGroup.getCompanyId())) {
            return;
        }
        this.groupLocalService.validateRemote(stagingGroup.getGroupId(), remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        if (stagingGroup.hasStagingGroup()) {
            this.disableStaging(stagingGroup, serviceContext);
        }
        boolean oldStagedRemotely = stagedRemotely = stagingGroup.isStagedRemotely();
        UnicodeProperties typeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        String remoteURL = StagingURLHelperUtil.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
        if (stagedRemotely) {
            long oldRemoteGroupId = GetterUtil.getLong(typeSettingsProperties.getProperty("remoteGroupId"));
            String oldRemoteURL = StagingURLHelperUtil.buildRemoteURL(typeSettingsProperties);
            if (!remoteURL.equals(oldRemoteURL) || remoteGroupId != oldRemoteGroupId) {
                this.disableRemoteStaging(oldRemoteURL, oldRemoteGroupId, false);
                stagedRemotely = false;
            }
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        if (!stagedRemotely) {
            this.enableRemoteStaging(httpPrincipal, remoteGroupId);
        }
        Group remoteGroup = this.fetchRemoteGroup(httpPrincipal, remoteGroupId);
        this.checkDefaultLayoutSetBranches(userId, stagingGroup, branchingPublic, branchingPrivate, true, serviceContext);
        typeSettingsProperties.setProperty("branchingPrivate", String.valueOf(branchingPrivate));
        typeSettingsProperties.setProperty("branchingPublic", String.valueOf(branchingPublic));
        typeSettingsProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsProperties.setProperty("remoteGroupUUID", remoteGroup.getUuid());
        typeSettingsProperties.setProperty("remotePathContext", remotePathContext);
        typeSettingsProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        if (!oldStagedRemotely) {
            typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsProperties.setProperty("stagedRemotely", Boolean.TRUE.toString());
            this.setCommonStagingOptions(typeSettingsProperties, serviceContext);
        }
        this.groupLocalService.updateGroup(stagingGroup.getGroupId(), typeSettingsProperties.toString());
        this.updateStagedPortlets(remoteURL, remoteGroupId, typeSettingsProperties);
    }

    @Override
    @Deprecated
    public MissingReferences publishStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MissingReferences publishStagingRequest(long userId, long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        MissingReferences missingReferences;
        File file = null;
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        try {
            if (exportImportConfiguration.getType() == 9) {
                ExportImportThreadLocal.setPortletImportInProcess(true);
                ExportImportThreadLocal.setPortletStagingInProcess(true);
            } else {
                ExportImportThreadLocal.setLayoutImportInProcess(true);
                ExportImportThreadLocal.setLayoutStagingInProcess(true);
            }
            Folder folder = PortletFileRepositoryUtil.getPortletFolder(stagingRequestId);
            FileEntry stagingRequestFileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, stagingRequestFileEntry.getContentStream());
            Map<String, Serializable> settingsMap = exportImportConfiguration.getSettingsMap();
            settingsMap.put("userId", Long.valueOf(userId));
            long targetGroupId = MapUtil.getLong(settingsMap, "targetGroupId");
            LocaleThreadLocal.setSiteDefaultLocale(PortalUtil.getSiteDefaultLocale(targetGroupId));
            MissingReferences missingReferences2 = null;
            if (exportImportConfiguration.getType() == 9) {
                this.exportImportLocalService.importPortletDataDeletions(exportImportConfiguration, file);
                missingReferences2 = this.exportImportLocalService.validateImportPortletInfo(exportImportConfiguration, file);
                this.exportImportLocalService.importPortletInfo(exportImportConfiguration, file);
            } else {
                this.exportImportLocalService.importLayoutsDataDeletions(exportImportConfiguration, file);
                missingReferences2 = this.exportImportLocalService.validateImportLayoutsFile(exportImportConfiguration, file);
                this.exportImportLocalService.importLayouts(exportImportConfiguration, file);
            }
            missingReferences = missingReferences2;
        }
        catch (IOException ioe) {
            try {
                ExportImportIOException eiioe = new ExportImportIOException(StagingLocalServiceImpl.class.getName(), ioe);
                eiioe.setStagingRequestId(stagingRequestId);
                eiioe.setType(14);
                throw eiioe;
            }
            catch (Throwable throwable) {
                if (exportImportConfiguration.getType() == 9) {
                    ExportImportThreadLocal.setPortletImportInProcess(false);
                    ExportImportThreadLocal.setPortletStagingInProcess(false);
                } else {
                    ExportImportThreadLocal.setLayoutImportInProcess(false);
                    ExportImportThreadLocal.setLayoutStagingInProcess(false);
                }
                LocaleThreadLocal.setSiteDefaultLocale(siteDefaultLocale);
                FileUtil.delete(file);
                throw throwable;
            }
        }
        if (exportImportConfiguration.getType() == 9) {
            ExportImportThreadLocal.setPortletImportInProcess(false);
            ExportImportThreadLocal.setPortletStagingInProcess(false);
        } else {
            ExportImportThreadLocal.setLayoutImportInProcess(false);
            ExportImportThreadLocal.setLayoutStagingInProcess(false);
        }
        LocaleThreadLocal.setSiteDefaultLocale(siteDefaultLocale);
        FileUtil.delete(file);
        return missingReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStagingRequest(long userId, long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder(stagingRequestId);
        boolean indexReadOnly = IndexStatusManagerThreadLocal.isIndexReadOnly();
        IndexStatusManagerThreadLocal.setIndexReadOnly(true);
        try {
            PortletFileRepositoryUtil.addPortletFileEntry(folder.getGroupId(), userId, Group.class.getName(), folder.getGroupId(), _PORTLET_REPOSITORY_ID, folder.getFolderId(), new UnsyncByteArrayInputStream(bytes), fileName, "application/zip", false);
        }
        finally {
            IndexStatusManagerThreadLocal.setIndexReadOnly(indexReadOnly);
        }
    }

    @Override
    @Deprecated
    public MissingReferences validateStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) {
        return new MissingReferences();
    }

    protected void addDefaultLayoutSetBranch(long userId, long groupId, String groupName, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        block4: {
            String masterBranchDescription = "main-site-pages-variation-of-x";
            if (privateLayout) {
                masterBranchDescription = "main-site-pages-variation-of-x";
            }
            String description = LanguageUtil.format(PortalUtil.getSiteDefaultLocale(groupId), masterBranchDescription, (Object)groupName, false);
            try {
                serviceContext.setWorkflowAction(0);
                LayoutSetBranch layoutSetBranch = this.layoutSetBranchLocalService.addLayoutSetBranch(userId, groupId, privateLayout, "main-variation", description, true, 0L, serviceContext);
                List<LayoutRevision> layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), false);
                for (LayoutRevision layoutRevision : layoutRevisions) {
                    this.layoutRevisionLocalService.updateStatus(userId, layoutRevision.getLayoutRevisionId(), 0, serviceContext);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn("Unable to create master branch for " + (privateLayout ? "private" : "public") + " layouts", pe);
            }
        }
    }

    protected Group addStagingGroup(long userId, Group liveGroup, ServiceContext serviceContext) throws PortalException {
        long parentGroupId = liveGroup.getParentGroupId();
        Group stagingGroup = this.groupLocalService.addGroup(userId, parentGroupId, liveGroup.getClassName(), liveGroup.getClassPK(), liveGroup.getGroupId(), liveGroup.getNameMap(), liveGroup.getDescriptionMap(), liveGroup.getType(), liveGroup.isManualMembership(), liveGroup.getMembershipRestriction(), liveGroup.getFriendlyURL(), false, true, serviceContext);
        if (LanguageUtil.isInheritLocales(liveGroup.getGroupId())) {
            return stagingGroup;
        }
        UnicodeProperties liveTypeSettingsProperties = liveGroup.getTypeSettingsProperties();
        UnicodeProperties stagingTypeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        stagingTypeSettingsProperties.setProperty("inheritLocales", Boolean.FALSE.toString());
        stagingTypeSettingsProperties.setProperty("locales", liveTypeSettingsProperties.getProperty("locales"));
        stagingTypeSettingsProperties.setProperty("languageId", liveTypeSettingsProperties.getProperty("languageId", LocaleUtil.toLanguageId(LocaleUtil.getDefault())));
        return this.groupLocalService.updateGroup(stagingGroup.getGroupId(), stagingTypeSettingsProperties.toString());
    }

    protected void deleteLayoutSetBranches(long groupId, boolean privateLayout) throws PortalException {
        String lastPublishDateString;
        HashMap<Long, LayoutRevision> layoutRevisions = new HashMap<Long, LayoutRevision>();
        List<LayoutSetBranch> layoutSetBranches = this.layoutSetBranchLocalService.getLayoutSetBranches(groupId, privateLayout);
        boolean publishedToLive = false;
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (!Validator.isNotNull(lastPublishDateString)) continue;
            publishedToLive = true;
            break;
        }
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            lastPublishDateString = layoutSetBranch.getSettingsProperty("last-publish-date");
            if (Validator.isNull(lastPublishDateString) && publishedToLive) continue;
            Date lastPublishDate = null;
            if (Validator.isNotNull(lastPublishDateString)) {
                lastPublishDate = new Date(GetterUtil.getLong(lastPublishDateString));
            }
            List<LayoutRevision> headLayoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), true);
            for (LayoutRevision headLayoutRevision : headLayoutRevisions) {
                LayoutRevision layoutRevision = (LayoutRevision)layoutRevisions.get(headLayoutRevision.getPlid());
                if (layoutRevision == null) {
                    layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
                    continue;
                }
                Date statusDate = headLayoutRevision.getStatusDate();
                if (!statusDate.after(layoutRevision.getStatusDate()) || lastPublishDate != null && !lastPublishDate.after(statusDate)) continue;
                layoutRevisions.put(headLayoutRevision.getPlid(), headLayoutRevision);
            }
        }
        for (LayoutRevision layoutRevision : layoutRevisions.values()) {
            this.updateLayoutWithLayoutRevision(layoutRevision);
        }
        this.layoutSetBranchLocalService.deleteLayoutSetBranches(groupId, privateLayout, true);
    }

    protected void disableRemoteStaging(String remoteURL, long remoteGroupId, boolean forceDisable) throws PortalException {
        block10: {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            try {
                GroupServiceHttp.disableStaging(httpPrincipal, remoteGroupId);
            }
            catch (NoSuchGroupException nsge) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Remote live group was already deleted", nsge);
                }
            }
            catch (PrincipalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug(pe, pe);
                }
                RemoteExportException ree = new RemoteExportException(5);
                ree.setGroupId(remoteGroupId);
                throw ree;
            }
            catch (RemoteAuthException rae) {
                if (_log.isDebugEnabled()) {
                    _log.debug(rae, rae);
                }
                rae.setURL(remoteURL);
                throw rae;
            }
            catch (SystemException se) {
                if (_log.isDebugEnabled()) {
                    _log.debug(se, se);
                }
                if (!forceDisable) {
                    RemoteExportException ree = new RemoteExportException(1);
                    ree.setURL(remoteURL);
                    throw ree;
                }
                if (!_log.isWarnEnabled()) break block10;
                _log.warn("Forcibly disable remote staging");
            }
        }
    }

    protected void enableRemoteStaging(HttpPrincipal httpPrincipal, long remoteGroupId) throws PortalException {
        try {
            GroupServiceHttp.enableStaging(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException nsge) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsge, nsge);
            }
            RemoteExportException ree = new RemoteExportException(3);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            RemoteExportException ree = new RemoteExportException(5);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            if (_log.isDebugEnabled()) {
                _log.debug(rae, rae);
            }
            rae.setURL(httpPrincipal.getUrl());
            throw rae;
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug(se, se);
            }
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(httpPrincipal.getUrl());
            throw ree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Group fetchRemoteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            Group group = GroupServiceHttp.getGroup(httpPrincipal, groupId);
            return group;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected FileEntry fetchStagingRequestFileEntry(long stagingRequestId, Folder folder) throws PortalException {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry(folder.getGroupId(), folder.getFolderId(), this.getAssembledFileName(stagingRequestId));
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsfee, nsfee);
            }
            return null;
        }
    }

    protected String getAssembledFileName(long stagingRequestId) {
        return _ASSEMBLED_LAR_PREFIX + String.valueOf(stagingRequestId) + ".lar";
    }

    /*
     * Exception decompiling
     */
    protected FileEntry getStagingRequestFileEntry(long userId, long stagingRequestId, Folder folder) throws PortalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setCommonStagingOptions(UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) {
        typeSettingsProperties.putAll(PropertiesParamUtil.getProperties(serviceContext, "staged--"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layout updateLayoutWithLayoutRevision(LayoutRevision layoutRevision) throws PortalException {
        Layout layout = null;
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled(false);
            layout = this.layoutLocalService.fetchLayout(layoutRevision.getPlid());
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled(stagingAdvicesThreadLocalEnabled);
        }
        this.updatePortletPreferences(layoutRevision, layout);
        layout.setUserId(layoutRevision.getUserId());
        layout.setUserName(layoutRevision.getUserName());
        layout.setCreateDate(layoutRevision.getCreateDate());
        layout.setModifiedDate(layoutRevision.getModifiedDate());
        layout.setPrivateLayout(layoutRevision.isPrivateLayout());
        layout.setName(layoutRevision.getName());
        layout.setTitle(layoutRevision.getTitle());
        layout.setDescription(layoutRevision.getDescription());
        layout.setKeywords(layoutRevision.getKeywords());
        layout.setRobots(layoutRevision.getRobots());
        layout.setTypeSettings(layoutRevision.getTypeSettings());
        layout.setIconImageId(layoutRevision.getIconImageId());
        layout.setThemeId(layoutRevision.getThemeId());
        layout.setColorSchemeId(layoutRevision.getColorSchemeId());
        layout.setCss(layoutRevision.getCss());
        return this.layoutLocalService.updateLayout(layout);
    }

    protected void updatePortletPreferences(LayoutRevision layoutRevision, Layout layout) {
        this.portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        List<PortletPreferences> portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferencesByPlid(layoutRevision.getLayoutRevisionId());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            this.portletPreferencesLocalService.addPortletPreferences(layoutRevision.getCompanyId(), portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), layout.getPlid(), portletPreferences.getPortletId(), null, portletPreferences.getPreferences());
        }
    }

    protected void updateStagedPortlets(String remoteURL, long remoteGroupId, UnicodeProperties typeSettingsProperties) throws PortalException {
        RemoteExportException ree;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        HashMap<String, String> stagedPortletIds = new HashMap<String, String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            stagedPortletIds.put(key, typeSettingsProperties.getProperty(key));
        }
        try {
            GroupServiceHttp.updateStagedPortlets(httpPrincipal, remoteGroupId, stagedPortletIds);
        }
        catch (NoSuchGroupException nsge) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsge, nsge);
            }
            ree = new RemoteExportException(3);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            ree = new RemoteExportException(5);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            if (_log.isDebugEnabled()) {
                _log.debug(rae, rae);
            }
            rae.setURL(remoteURL);
            throw rae;
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug(se, se);
            }
            ree = new RemoteExportException(1);
            ree.setURL(remoteURL);
            throw ree;
        }
    }
}

