/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationFactory;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportControllerRegistryUtil;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.exportimport.kernel.exception.LARFileNameException;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portlet.exportimport.service.base.ExportImportLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ExportImportLocalServiceImpl
extends ExportImportLocalServiceBaseImpl {
    @Override
    public File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            ExportController layoutExportController = ExportImportControllerRegistryUtil.getExportController(Layout.class.getName());
            return layoutExportController.export(exportImportConfiguration);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    @Deprecated
    public File exportLayoutsAsFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationFactory.buildDefaultLocalPublishingExportImportConfiguration(user, groupId, 0L, privateLayout, parameterMap);
        return this.exportLayoutsAsFile(exportImportConfiguration);
    }

    @Override
    public long exportLayoutsAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        if (!DLValidatorUtil.isValidName(exportImportConfiguration.getName())) {
            throw new LARFileNameException(exportImportConfiguration.getName());
        }
        HashMap<String, Serializable> taskContextMap = new HashMap<String, Serializable>();
        taskContextMap.put("exportImportConfigurationId", Long.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), "com.liferay.exportimport.internal.background.task.LayoutExportBackgroundTaskExecutor", taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    @Override
    public long exportLayoutsAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.exportLayoutsAsFileInBackground(userId, exportImportConfiguration);
    }

    @Override
    public File exportPortletInfoAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            ExportController portletExportController = ExportImportControllerRegistryUtil.getExportController(Portlet.class.getName());
            return portletExportController.export(exportImportConfiguration);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public long exportPortletInfoAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map<String, Serializable> settingsMap = exportImportConfiguration.getSettingsMap();
        String fileName = MapUtil.getString(settingsMap, "fileName");
        if (!DLValidatorUtil.isValidName(fileName)) {
            throw new LARFileNameException(fileName);
        }
        HashMap<String, Serializable> taskContextMap = new HashMap<String, Serializable>();
        taskContextMap.put("exportImportConfigurationId", Long.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), "com.liferay.exportimport.internal.background.task.PortletExportBackgroundTaskExecutor", taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    @Override
    public long exportPortletInfoAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.exportPortletInfoAsFileInBackground(userId, exportImportConfiguration);
    }

    @Override
    public void importLayouts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController(Layout.class.getName());
            layoutImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public void importLayouts(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, inputStream);
            this.importLayouts(exportImportConfiguration, file);
        }
        catch (IOException ioe) {
            ExportImportIOException eiioe = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), ioe);
            if (file != null) {
                eiioe.setFileName(file.getName());
                eiioe.setType(6);
            } else {
                eiioe.setType(5);
            }
            throw eiioe;
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    @Deprecated
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationFactory.buildDefaultLocalPublishingExportImportConfiguration(user, 0L, groupId, privateLayout, parameterMap);
        this.importLayouts(exportImportConfiguration, file);
    }

    @Override
    public void importLayoutsDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController(Layout.class.getName());
            layoutImportController.importDataDeletions(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        HashMap<String, Serializable> taskContextMap = new HashMap<String, Serializable>();
        taskContextMap.put("exportImportConfigurationId", Long.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), "com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor", taskContextMap, new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    @Override
    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, inputStream);
            long l = this.importLayoutsInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioe) {
            ExportImportIOException eiioe = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), ioe);
            if (file != null) {
                eiioe.setFileName(file.getName());
                eiioe.setType(6);
            } else {
                eiioe.setType(5);
            }
            throw eiioe;
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
    }

    @Override
    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, InputStream inputStream) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importLayoutsInBackground(userId, exportImportConfiguration, inputStream);
    }

    @Override
    public void importPortletDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController(Portlet.class.getName());
            portletImportController.importDataDeletions(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController(Portlet.class.getName());
            portletImportController.importFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            for (Throwable cause = pe.getCause(); cause != null; cause = cause.getCause()) {
                if (cause instanceof LocaleException) {
                    throw (PortalException)cause;
                }
                if (!(cause instanceof PortletDataException)) break;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, inputStream);
            this.importPortletInfo(exportImportConfiguration, file);
        }
        catch (IOException ioe) {
            ExportImportIOException eiioe = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), ioe);
            if (file != null) {
                eiioe.setFileName(file.getName());
                eiioe.setType(11);
            } else {
                eiioe.setType(10);
            }
            throw eiioe;
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        HashMap<String, Serializable> taskContextMap = new HashMap<String, Serializable>();
        taskContextMap.put("exportImportConfigurationId", Long.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), "com.liferay.exportimport.internal.background.task.PortletImportBackgroundTaskExecutor", taskContextMap, new ServiceContext());
        backgroundTask.addAttachment(userId, file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    @Override
    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, inputStream);
            long l = this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
            return l;
        }
        catch (IOException ioe) {
            ExportImportIOException eiioe = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), ioe);
            if (file != null) {
                eiioe.setFileName(file.getName());
                eiioe.setType(11);
            } else {
                eiioe.setType(10);
            }
            throw eiioe;
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importPortletInfoInBackground(userId, exportImportConfiguration, file);
    }

    @Override
    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, InputStream inputStream) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.importPortletInfoInBackground(userId, exportImportConfiguration, inputStream);
    }

    @Override
    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController layoutImportController = ExportImportControllerRegistryUtil.getImportController(Layout.class.getName());
            return layoutImportController.validateFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, inputStream);
            MissingReferences missingReferences = this.validateImportLayoutsFile(exportImportConfiguration, file);
            return missingReferences;
        }
        catch (IOException ioe) {
            ExportImportIOException eiioe = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), ioe);
            if (file != null) {
                eiioe.setFileName(file.getName());
                eiioe.setType(8);
            } else {
                eiioe.setType(7);
            }
            throw eiioe;
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        try {
            ImportController portletImportController = ExportImportControllerRegistryUtil.getImportController(Portlet.class.getName());
            return portletImportController.validateFile(exportImportConfiguration, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            ExportImportRuntimeException eire = new ExportImportRuntimeException(e.getLocalizedMessage(), e);
            eire.setClassName(ExportImportLocalServiceImpl.class.getName());
            throw eire;
        }
    }

    @Override
    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile("lar");
            FileUtil.write(file, inputStream);
            MissingReferences missingReferences = this.validateImportPortletInfo(exportImportConfiguration, file);
            return missingReferences;
        }
        catch (IOException ioe) {
            ExportImportIOException eiioe = new ExportImportIOException(ExportImportLocalServiceImpl.class.getName(), ioe);
            if (file != null) {
                eiioe.setFileName(file.getName());
                eiioe.setType(13);
            } else {
                eiioe.setType(12);
            }
            throw eiioe;
        }
        finally {
            FileUtil.delete(file);
        }
    }
}

