/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.service.base.ExportImportConfigurationLocalServiceBaseImpl;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportImportConfigurationLocalServiceImpl
extends ExportImportConfigurationLocalServiceBaseImpl {
    @Override
    public ExportImportConfiguration addDraftExportImportConfiguration(long userId, int type, Map<String, Serializable> settingsMap) throws PortalException {
        return this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, GetterUtil.getString(settingsMap.get("portletId")), type, settingsMap);
    }

    @Override
    public ExportImportConfiguration addDraftExportImportConfiguration(long userId, String name, int type, Map<String, Serializable> settingsMap) throws PortalException {
        long groupId = GetterUtil.getLong(settingsMap.get("sourceGroupId"));
        if (type == 6 || type == 7) {
            groupId = GetterUtil.getLong(settingsMap.get("targetGroupId"));
        }
        return this.exportImportConfigurationLocalService.addExportImportConfiguration(userId, groupId, name, "", type, settingsMap, 2, new ServiceContext());
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration addExportImportConfiguration(long userId, long groupId, String name, String description, int type, Map<String, Serializable> settingsMap, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long exportImportConfigurationId = this.counterLocalService.increment();
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.create(exportImportConfigurationId);
        exportImportConfiguration.setGroupId(groupId);
        exportImportConfiguration.setCompanyId(user.getCompanyId());
        exportImportConfiguration.setUserId(userId);
        exportImportConfiguration.setUserName(user.getFullName());
        exportImportConfiguration.setName(name);
        exportImportConfiguration.setDescription(description);
        exportImportConfiguration.setType(type);
        if (settingsMap != null) {
            String settings = JSONFactoryUtil.serialize(settingsMap);
            exportImportConfiguration.setSettings(settings);
        }
        exportImportConfiguration.setStatus(status);
        exportImportConfiguration.setStatusByUserId(userId);
        exportImportConfiguration.setStatusByUserName(user.getScreenName());
        exportImportConfiguration.setStatusDate(now);
        return this.exportImportConfigurationPersistence.update(exportImportConfiguration);
    }

    @Override
    public ExportImportConfiguration addExportImportConfiguration(long userId, long groupId, String name, String description, int type, Map<String, Serializable> settingsMap, ServiceContext serviceContext) throws PortalException {
        return this.exportImportConfigurationLocalService.addExportImportConfiguration(userId, groupId, name, description, type, settingsMap, 0, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ExportImportConfiguration deleteExportImportConfiguration(ExportImportConfiguration exportImportConfiguration) {
        this.exportImportConfigurationPersistence.remove(exportImportConfiguration);
        return exportImportConfiguration;
    }

    @Override
    public ExportImportConfiguration deleteExportImportConfiguration(long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        return this.exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
    }

    @Override
    public void deleteExportImportConfigurations(long groupId) {
        List<ExportImportConfiguration> exportImportConfigurations = this.exportImportConfigurationPersistence.findByGroupId(groupId);
        for (ExportImportConfiguration exportImportConfiguration : exportImportConfigurations) {
            this.exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
        }
    }

    @Override
    public List<ExportImportConfiguration> getExportImportConfigurations(Hits hits) throws PortalException {
        List<Document> documents = hits.toList();
        ArrayList<ExportImportConfiguration> exportImportConfigurations = new ArrayList<ExportImportConfiguration>(documents.size());
        for (Document document : documents) {
            long exportImportConfigurationId = GetterUtil.getLong(document.get("exportImportConfigurationId"));
            ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
            if (exportImportConfiguration == null) {
                exportImportConfigurations = null;
                Indexer<ExportImportConfiguration> indexer = IndexerRegistryUtil.getIndexer(ExportImportConfiguration.class);
                long companyId = GetterUtil.getLong(document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (exportImportConfigurations == null) continue;
            exportImportConfigurations.add(exportImportConfiguration);
        }
        return exportImportConfigurations;
    }

    @Override
    public List<ExportImportConfiguration> getExportImportConfigurations(long groupId, int type) {
        return this.exportImportConfigurationPersistence.findByG_T_S(groupId, type, 0);
    }

    @Override
    public List<ExportImportConfiguration> getExportImportConfigurations(long groupId, int type, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationPersistence.findByG_T_S(groupId, type, 0, start, end, orderByComparator);
    }

    @Override
    public List<ExportImportConfiguration> getExportImportConfigurations(long companyId, long groupId, String keywords, int type, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationFinder.findByKeywords(companyId, groupId, keywords, type, 0, start, end, orderByComparator);
    }

    @Override
    public List<ExportImportConfiguration> getExportImportConfigurations(long companyId, long groupId, String name, String description, int type, boolean andSearch, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationFinder.findByC_G_N_D_T(companyId, groupId, name, description, type, 0, andSearch, start, end, orderByComparator);
    }

    @Override
    public int getExportImportConfigurationsCount(long groupId) {
        return this.exportImportConfigurationPersistence.countByG_S(groupId, 0);
    }

    @Override
    public int getExportImportConfigurationsCount(long groupId, int type) {
        return this.exportImportConfigurationPersistence.countByG_T_S(groupId, type, 0);
    }

    @Override
    public int getExportImportConfigurationsCount(long companyId, long groupId, String keywords, int type) {
        return this.exportImportConfigurationFinder.countByKeywords(companyId, groupId, keywords, type, 0);
    }

    @Override
    public int getExportImportConfigurationsCount(long companyId, long groupId, String name, String description, int type, boolean andSearch) {
        return this.exportImportConfigurationFinder.countByC_G_N_D_T(companyId, groupId, name, description, type, 0, andSearch);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration moveExportImportConfigurationToTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        if (exportImportConfiguration.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = exportImportConfiguration.getStatus();
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), 8);
        this.trashEntryLocalService.addTrashEntry(userId, exportImportConfiguration.getGroupId(), ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId(), null, null, oldStatus, null, null);
        return exportImportConfiguration;
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration restoreExportImportConfigurationFromTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        if (!exportImportConfiguration.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(ExportImportConfiguration.class.getName(), exportImportConfigurationId);
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), trashEntry.getStatus());
        this.trashEntryLocalService.deleteEntry(ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId());
        return exportImportConfiguration;
    }

    @Override
    public BaseModelSearchResult<ExportImportConfiguration> searchExportImportConfigurations(long companyId, long groupId, int type, String keywords, int start, int end, Sort sort) throws PortalException {
        String description = null;
        String name = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            description = keywords;
            name = keywords;
        } else {
            andOperator = true;
        }
        return this.searchExportImportConfigurations(companyId, groupId, type, name, description, andOperator, start, end, sort);
    }

    @Override
    public BaseModelSearchResult<ExportImportConfiguration> searchExportImportConfigurations(long companyId, long groupId, int type, String name, String description, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        Indexer<ExportImportConfiguration> indexer = IndexerRegistryUtil.nullSafeGetIndexer(ExportImportConfiguration.class);
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, type, name, description, andSearch, start, end, sort);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<ExportImportConfiguration> exportImportConfigurations = this.exportImportConfigurationLocalService.getExportImportConfigurations(hits);
            if (exportImportConfigurations == null) continue;
            return new BaseModelSearchResult<ExportImportConfiguration>(exportImportConfigurations, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration updateExportImportConfiguration(long userId, long exportImportConfigurationId, String name, String description, Map<String, Serializable> settingsMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        exportImportConfiguration.setUserId(userId);
        exportImportConfiguration.setUserName(user.getFullName());
        exportImportConfiguration.setName(name);
        exportImportConfiguration.setDescription(description);
        if (settingsMap != null) {
            String settings = JSONFactoryUtil.serialize(settingsMap);
            exportImportConfiguration.setSettings(settings);
        }
        return this.exportImportConfigurationPersistence.update(exportImportConfiguration);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration updateStatus(long userId, long exportImportConfigurationId, int status) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        exportImportConfiguration.setStatus(status);
        exportImportConfiguration.setStatusByUserId(userId);
        exportImportConfiguration.setStatusByUserName(user.getScreenName());
        exportImportConfiguration.setStatusDate(new Date());
        this.exportImportConfigurationPersistence.update(exportImportConfiguration);
        return exportImportConfiguration;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, int type, String name, String description, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("status", Integer.valueOf(0));
        attributes.put("description", (Serializable)((Object)description));
        attributes.put("groupId", Long.valueOf(groupId));
        attributes.put("name", (Serializable)((Object)name));
        attributes.put("type", Integer.valueOf(type));
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(sort);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }
}

