/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.http;

import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.StagingServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class StagingServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(StagingServiceHttp.class);
    private static final Class<?>[] _cleanUpStagingRequestParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _createStagingRequestParameterTypes1 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _hasRemoteLayoutParameterTypes2 = new Class[]{String.class, Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _propagateExportImportLifecycleEventParameterTypes3 = new Class[]{Integer.TYPE, Integer.TYPE, String.class, List.class};
    private static final Class<?>[] _publishStagingRequestParameterTypes4 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class};
    private static final Class<?>[] _publishStagingRequestParameterTypes5 = new Class[]{Long.TYPE, ExportImportConfiguration.class};
    private static final Class<?>[] _updateStagingRequestParameterTypes6 = new Class[]{Long.TYPE, String.class, byte[].class};
    private static final Class<?>[] _validateStagingRequestParameterTypes7 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class};

    public static void cleanUpStagingRequest(HttpPrincipal httpPrincipal, long stagingRequestId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "cleanUpStagingRequest", _cleanUpStagingRequestParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, stagingRequestId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static long createStagingRequest(HttpPrincipal httpPrincipal, long groupId, String checksum) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "createStagingRequest", _createStagingRequestParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, groupId, checksum);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static boolean hasRemoteLayout(HttpPrincipal httpPrincipal, String uuid, long groupId, boolean privateLayout) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "hasRemoteLayout", _hasRemoteLayoutParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, uuid, groupId, privateLayout);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void propagateExportImportLifecycleEvent(HttpPrincipal httpPrincipal, int code, int processFlag, String processId, List<Serializable> arguments) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "propagateExportImportLifecycleEvent", _propagateExportImportLifecycleEventParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, code, processFlag, processId, arguments);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static MissingReferences publishStagingRequest(HttpPrincipal httpPrincipal, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "publishStagingRequest", _publishStagingRequestParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, stagingRequestId, privateLayout, parameterMap);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (MissingReferences)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static MissingReferences publishStagingRequest(HttpPrincipal httpPrincipal, long stagingRequestId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "publishStagingRequest", _publishStagingRequestParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, stagingRequestId, exportImportConfiguration);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (MissingReferences)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void updateStagingRequest(HttpPrincipal httpPrincipal, long stagingRequestId, String fileName, byte[] bytes) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "updateStagingRequest", _updateStagingRequestParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, stagingRequestId, fileName, bytes);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static MissingReferences validateStagingRequest(HttpPrincipal httpPrincipal, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(StagingServiceUtil.class, "validateStagingRequest", _validateStagingRequestParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, stagingRequestId, privateLayout, parameterMap);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (MissingReferences)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

