/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.permission.ExpandoColumnPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.service.base.ExpandoValueServiceBaseImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class ExpandoValueServiceImpl
extends ExpandoValueServiceBaseImpl {
    @Override
    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Object data) throws PortalException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoColumnPermissionUtil.check(this.getPermissionChecker(), column, "UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    @Override
    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String data) throws PortalException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoColumnPermissionUtil.check(this.getPermissionChecker(), column, "UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    @Override
    public void addValues(long companyId, String className, String tableName, long classPK, Map<String, Serializable> attributeValues) throws PortalException {
        for (Map.Entry<String, Serializable> entry : attributeValues.entrySet()) {
            this.addValue(companyId, className, tableName, entry.getKey(), classPK, entry.getValue());
        }
    }

    @Override
    public Map<String, Serializable> getData(long companyId, String className, String tableName, Collection<String> columnNames, long classPK) throws PortalException {
        Map<String, Serializable> attributeValues = this.expandoValueLocalService.getData(companyId, className, tableName, columnNames, classPK);
        for (String columnName : columnNames) {
            ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
            if (ExpandoColumnPermissionUtil.contains(this.getPermissionChecker(), column, "VIEW")) continue;
            attributeValues.remove(columnName);
        }
        return attributeValues;
    }

    @Override
    public Serializable getData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (ExpandoColumnPermissionUtil.contains(this.getPermissionChecker(), column, "VIEW")) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK);
        }
        return null;
    }

    @Override
    public JSONObject getJSONData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (!ExpandoColumnPermissionUtil.contains(this.getPermissionChecker(), column, "VIEW")) {
            return null;
        }
        Serializable dataSerializable = this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK);
        String data = dataSerializable.toString();
        if (Validator.isNull(data)) {
            return null;
        }
        if (data.startsWith("{")) {
            return JSONFactoryUtil.createJSONObject(data);
        }
        return JSONUtil.put("data", (Object)data);
    }
}

