/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.exception.DuplicateTableNameException;
import com.liferay.expando.kernel.exception.TableNameException;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.service.base.ExpandoTableLocalServiceBaseImpl;
import java.util.List;

public class ExpandoTableLocalServiceImpl
extends ExpandoTableLocalServiceBaseImpl {
    @Override
    public ExpandoTable addDefaultTable(long companyId, long classNameId) throws PortalException {
        return this.addTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoTable addDefaultTable(long companyId, String className) throws PortalException {
        return this.addTable(companyId, className, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoTable addTable(long companyId, long classNameId, String name) throws PortalException {
        ExpandoTable expandoTable = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
        if (expandoTable != null) {
            return expandoTable;
        }
        this.validate(companyId, 0L, classNameId, name);
        long tableId = this.counterLocalService.increment();
        ExpandoTable table = this.expandoTablePersistence.create(tableId);
        table.setCompanyId(companyId);
        table.setClassNameId(classNameId);
        table.setName(name);
        this.expandoTablePersistence.update(table);
        return table;
    }

    @Override
    public ExpandoTable addTable(long companyId, String className, String name) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.addTable(companyId, classNameId, name);
    }

    @Override
    public void deleteTable(ExpandoTable table) {
        this.expandoTablePersistence.remove(table);
        this.runSQL("delete from ExpandoColumn where tableId = " + table.getTableId());
        this.expandoColumnPersistence.clearCache();
        this.runSQL("delete from ExpandoRow where tableId = " + table.getTableId());
        this.expandoRowPersistence.clearCache();
        this.runSQL("delete from ExpandoValue where tableId = " + table.getTableId());
        this.expandoValuePersistence.clearCache();
    }

    @Override
    public void deleteTable(long tableId) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        this.deleteTable(table);
    }

    @Override
    public void deleteTable(long companyId, long classNameId, String name) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
        this.deleteTable(table);
    }

    @Override
    public void deleteTable(long companyId, String className, String name) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.deleteTable(companyId, classNameId, name);
    }

    @Override
    public void deleteTables(long companyId, long classNameId) {
        List<ExpandoTable> tables = this.expandoTablePersistence.findByC_C(companyId, classNameId);
        for (ExpandoTable table : tables) {
            this.deleteTable(table);
        }
    }

    @Override
    public void deleteTables(long companyId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.deleteTables(companyId, classNameId);
    }

    @Override
    public ExpandoTable fetchDefaultTable(long companyId, long classNameId) {
        return this.fetchTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoTable fetchDefaultTable(long companyId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.fetchTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoTable fetchTable(long companyId, long classNameId, String name) {
        return this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
    }

    @Override
    public ExpandoTable getDefaultTable(long companyId, long classNameId) throws PortalException {
        return this.getTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoTable getDefaultTable(long companyId, String className) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoTable getTable(long tableId) throws PortalException {
        return this.expandoTablePersistence.findByPrimaryKey(tableId);
    }

    @Override
    public ExpandoTable getTable(long companyId, long classNameId, String name) throws PortalException {
        return this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
    }

    @Override
    public ExpandoTable getTable(long companyId, String className, String name) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getTable(companyId, classNameId, name);
    }

    @Override
    public List<ExpandoTable> getTables(long companyId, long classNameId) {
        return this.expandoTablePersistence.findByC_C(companyId, classNameId);
    }

    @Override
    public List<ExpandoTable> getTables(long companyId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getTables(companyId, classNameId);
    }

    @Override
    public ExpandoTable updateTable(long tableId, String name) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        String tableName = table.getName();
        if (tableName.equals("CUSTOM_FIELDS")) {
            throw new TableNameException("Cannot rename CUSTOM_FIELDS");
        }
        this.validate(table.getCompanyId(), tableId, table.getClassNameId(), name);
        table.setName(name);
        return this.expandoTablePersistence.update(table);
    }

    protected void validate(long companyId, long tableId, long classNameId, String name) throws PortalException {
        if (Validator.isNull(name)) {
            throw new TableNameException("Name is null");
        }
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
        if (table != null && table.getTableId() != tableId) {
            throw new DuplicateTableNameException("{tableId=" + tableId + "}");
        }
    }
}

