/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portlet.expando.service.base.ExpandoRowLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

public class ExpandoRowLocalServiceImpl
extends ExpandoRowLocalServiceBaseImpl {
    @Override
    public ExpandoRow addRow(long tableId, long classPK) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        long rowId = this.counterLocalService.increment();
        ExpandoRow row = this.expandoRowPersistence.create(rowId);
        row.setCompanyId(table.getCompanyId());
        row.setTableId(tableId);
        row.setClassPK(classPK);
        this.expandoRowPersistence.update(row);
        return row;
    }

    @Override
    public void deleteRow(ExpandoRow row) {
        this.expandoRowPersistence.remove(row);
        this.expandoValueLocalService.deleteRowValues(row.getRowId());
    }

    @Override
    public void deleteRow(long rowId) throws PortalException {
        ExpandoRow row = this.expandoRowPersistence.findByPrimaryKey(rowId);
        this.deleteRow(row);
    }

    @Override
    public void deleteRow(long tableId, long classPK) throws PortalException {
        ExpandoRow row = this.expandoRowPersistence.findByT_C(tableId, classPK);
        this.deleteRow(row);
    }

    @Override
    public void deleteRow(long companyId, long classNameId, String tableName, long classPK) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.expandoRowLocalService.deleteRow(table.getTableId(), classPK);
    }

    @Override
    public void deleteRow(long companyId, String className, String tableName, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.expandoRowLocalService.deleteRow(companyId, classNameId, tableName, classPK);
    }

    @Override
    public void deleteRows(long classPK) {
        List<ExpandoRow> rows = this.expandoRowPersistence.findByClassPK(classPK);
        for (ExpandoRow row : rows) {
            this.deleteRow(row);
        }
    }

    @Override
    public ExpandoRow fetchRow(long tableId, long classPK) {
        return this.expandoRowPersistence.fetchByT_C(tableId, classPK);
    }

    @Override
    public List<ExpandoRow> getDefaultTableRows(long companyId, long classNameId, int start, int end) {
        return this.expandoRowLocalService.getRows(companyId, classNameId, "CUSTOM_FIELDS", start, end);
    }

    @Override
    public List<ExpandoRow> getDefaultTableRows(long companyId, String className, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoRowLocalService.getDefaultTableRows(companyId, classNameId, start, end);
    }

    @Override
    public int getDefaultTableRowsCount(long companyId, long classNameId) {
        return this.expandoRowLocalService.getRowsCount(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public int getDefaultTableRowsCount(long companyId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoRowLocalService.getDefaultTableRowsCount(companyId, classNameId);
    }

    @Override
    public ExpandoRow getRow(long rowId) throws PortalException {
        return this.expandoRowPersistence.findByPrimaryKey(rowId);
    }

    @Override
    public ExpandoRow getRow(long tableId, long classPK) throws PortalException {
        return this.expandoRowPersistence.findByT_C(tableId, classPK);
    }

    @Override
    public ExpandoRow getRow(long companyId, long classNameId, String tableName, long classPK) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        return this.expandoRowPersistence.fetchByT_C(table.getTableId(), classPK);
    }

    @Override
    public ExpandoRow getRow(long companyId, String className, String tableName, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoRowLocalService.getRow(companyId, classNameId, tableName, classPK);
    }

    @Override
    public List<ExpandoRow> getRows(long tableId, int start, int end) {
        return this.expandoRowPersistence.findByTableId(tableId, start, end);
    }

    @Override
    public List<ExpandoRow> getRows(long companyId, long classNameId, String tableName, int start, int end) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoRowPersistence.findByTableId(table.getTableId(), start, end);
    }

    @Override
    public List<ExpandoRow> getRows(long companyId, String className, String tableName, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoRowLocalService.getRows(companyId, classNameId, tableName, start, end);
    }

    @Override
    public int getRowsCount(long tableId) {
        return this.expandoRowPersistence.countByTableId(tableId);
    }

    @Override
    public int getRowsCount(long companyId, long classNameId, String tableName) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoRowPersistence.countByTableId(table.getTableId());
    }

    @Override
    public int getRowsCount(long companyId, String className, String tableName) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoRowLocalService.getRowsCount(companyId, classNameId, tableName);
    }
}

