/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.exception.ColumnNameException;
import com.liferay.expando.kernel.exception.ColumnTypeException;
import com.liferay.expando.kernel.exception.DuplicateColumnNameException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.model.adapter.StagedExpandoColumn;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import com.liferay.portlet.expando.service.base.ExpandoColumnLocalServiceBaseImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ExpandoColumnLocalServiceImpl
extends ExpandoColumnLocalServiceBaseImpl {
    @Override
    public ExpandoColumn addColumn(long tableId, String name, int type) throws PortalException {
        return this.addColumn(tableId, name, type, null);
    }

    @Override
    public ExpandoColumn addColumn(long tableId, String name, int type, Object defaultData) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        ExpandoValue value = this.validate(0L, tableId, name, type, defaultData);
        long columnId = this.counterLocalService.increment();
        ExpandoColumn column = this.expandoColumnPersistence.create(columnId);
        column.setCompanyId(table.getCompanyId());
        column.setTableId(tableId);
        column.setName(name);
        column.setType(type);
        column.setDefaultData(value.getData());
        this.expandoColumnPersistence.update(column);
        this.resourceLocalService.addResources(table.getCompanyId(), 0L, 0L, ExpandoColumn.class.getName(), column.getColumnId(), false, false, false);
        return column;
    }

    @Override
    public void deleteColumn(ExpandoColumn column) {
        this.addDeletionSystemEvent(column);
        this.expandoColumnPersistence.remove(column);
        this.expandoValueLocalService.deleteColumnValues(column.getColumnId());
    }

    @Override
    public void deleteColumn(long columnId) throws PortalException {
        ExpandoColumn column = this.expandoColumnPersistence.findByPrimaryKey(columnId);
        this.deleteColumn(column);
    }

    @Override
    public void deleteColumn(long companyId, long classNameId, String tableName, String name) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.deleteColumn(table.getTableId(), name);
    }

    @Override
    public void deleteColumn(long tableId, String name) {
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(tableId, name);
        if (column != null) {
            this.deleteColumn(column);
        }
    }

    @Override
    public void deleteColumn(long companyId, String className, String tableName, String name) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.deleteColumn(companyId, classNameId, tableName, name);
    }

    @Override
    public void deleteColumns(long tableId) {
        List<ExpandoColumn> columns = this.expandoColumnPersistence.findByTableId(tableId);
        for (ExpandoColumn column : columns) {
            this.deleteColumn(column);
        }
    }

    @Override
    public void deleteColumns(long companyId, long classNameId, String tableName) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.deleteColumns(table.getTableId());
    }

    @Override
    public void deleteColumns(long companyId, String className, String tableName) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.deleteColumns(companyId, classNameId, tableName);
    }

    @Override
    public ExpandoColumn getColumn(long columnId) throws PortalException {
        return this.expandoColumnPersistence.findByPrimaryKey(columnId);
    }

    @Override
    public ExpandoColumn getColumn(long companyId, long classNameId, String tableName, String name) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        return this.expandoColumnPersistence.fetchByT_N(table.getTableId(), name);
    }

    @Override
    public ExpandoColumn getColumn(long tableId, String name) {
        return this.expandoColumnPersistence.fetchByT_N(tableId, name);
    }

    @Override
    public ExpandoColumn getColumn(long companyId, String className, String tableName, String name) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumn(companyId, classNameId, tableName, name);
    }

    @Override
    public List<ExpandoColumn> getColumns(long tableId) {
        return this.expandoColumnPersistence.findByTableId(tableId);
    }

    @Override
    public List<ExpandoColumn> getColumns(long tableId, Collection<String> names) {
        return this.expandoColumnPersistence.findByT_N(tableId, names.toArray(new String[0]));
    }

    @Override
    public List<ExpandoColumn> getColumns(long companyId, long classNameId, String tableName) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoColumnPersistence.findByTableId(table.getTableId());
    }

    @Override
    public List<ExpandoColumn> getColumns(long companyId, long classNameId, String tableName, Collection<String> names) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoColumnPersistence.findByT_N(table.getTableId(), names.toArray(new String[0]));
    }

    @Override
    public List<ExpandoColumn> getColumns(long companyId, String className, String tableName) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumns(companyId, classNameId, tableName);
    }

    @Override
    public List<ExpandoColumn> getColumns(long companyId, String className, String tableName, Collection<String> columnNames) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumns(companyId, classNameId, tableName, columnNames);
    }

    @Override
    public int getColumnsCount(long tableId) {
        return this.expandoColumnPersistence.countByTableId(tableId);
    }

    @Override
    public int getColumnsCount(long companyId, long classNameId, String tableName) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoColumnPersistence.countByTableId(table.getTableId());
    }

    @Override
    public int getColumnsCount(long companyId, String className, String tableName) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumnsCount(companyId, classNameId, tableName);
    }

    @Override
    public ExpandoColumn getDefaultTableColumn(long companyId, long classNameId, String name) {
        return this.getColumn(companyId, classNameId, "CUSTOM_FIELDS", name);
    }

    @Override
    public ExpandoColumn getDefaultTableColumn(long companyId, String className, String name) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumn(companyId, classNameId, "CUSTOM_FIELDS", name);
    }

    @Override
    public List<ExpandoColumn> getDefaultTableColumns(long companyId, long classNameId) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "CUSTOM_FIELDS");
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoColumnPersistence.findByTableId(table.getTableId());
    }

    @Override
    public List<ExpandoColumn> getDefaultTableColumns(long companyId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumns(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public int getDefaultTableColumnsCount(long companyId, long classNameId) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "CUSTOM_FIELDS");
        if (table == null) {
            return 0;
        }
        return this.expandoColumnPersistence.countByTableId(table.getTableId());
    }

    @Override
    public int getDefaultTableColumnsCount(long companyId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getColumnsCount(companyId, classNameId, "CUSTOM_FIELDS");
    }

    @Override
    public ExpandoColumn updateColumn(long columnId, String name, int type) throws PortalException {
        return this.expandoColumnLocalService.updateColumn(columnId, name, type, null);
    }

    @Override
    public ExpandoColumn updateColumn(long columnId, String name, int type, Object defaultData) throws PortalException {
        ExpandoColumn column = this.expandoColumnPersistence.findByPrimaryKey(columnId);
        ExpandoValue value = this.validate(columnId, column.getTableId(), name, type, defaultData);
        column.setName(name);
        column.setType(type);
        column.setDefaultData(value.getData());
        this.expandoColumnPersistence.update(column);
        return column;
    }

    @Override
    public ExpandoColumn updateTypeSettings(long columnId, String typeSettings) throws PortalException {
        ExpandoColumn column = this.expandoColumnPersistence.findByPrimaryKey(columnId);
        column.setTypeSettings(typeSettings);
        this.expandoColumnPersistence.update(column);
        return column;
    }

    protected void addDeletionSystemEvent(ExpandoColumn expandoColumn) {
        StagedExpandoColumn stagedExpandoColumn = ModelAdapterUtil.adapt(expandoColumn, ExpandoColumn.class, StagedExpandoColumn.class);
        StagedModelType stagedModelType = stagedExpandoColumn.getStagedModelType();
        JSONObject extraDataJSONObject = JSONUtil.put("companyId", (Object)stagedExpandoColumn.getCompanyId()).put("uuid", stagedExpandoColumn.getUuid());
        try {
            this.systemEventLocalService.addSystemEvent(stagedExpandoColumn.getCompanyId(), stagedModelType.getClassName(), stagedExpandoColumn.getPrimaryKey(), "", null, 1, extraDataJSONObject.toString());
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected ExpandoValue validate(long columnId, long tableId, String name, int type, Object defaultData) throws PortalException {
        if (Validator.isNull(name)) {
            throw new ColumnNameException("Name is null");
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(tableId, name);
        if (column != null && column.getColumnId() != columnId) {
            StringBundler sb = new StringBundler(7);
            sb.append("{tableId=");
            sb.append(tableId);
            sb.append(", columnId=");
            sb.append(columnId);
            sb.append(", name=");
            sb.append(name);
            sb.append("}");
            throw new DuplicateColumnNameException(sb.toString());
        }
        if (type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6 && type != 7 && type != 8 && type != 21 && type != 9 && type != 10 && type != 11 && type != 12 && type != 17 && type != 18 && type != 13 && type != 14 && type != 15 && type != 16 && type != 19 && type != 20) {
            throw new ColumnTypeException("Invalid type " + type);
        }
        ExpandoValueImpl value = new ExpandoValueImpl();
        if (defaultData == null) {
            return value;
        }
        value.setColumnId(columnId);
        if (type == 1) {
            value.setBoolean((Boolean)defaultData);
        } else if (type == 2) {
            value.setBooleanArray((boolean[])defaultData);
        } else if (type == 3) {
            value.setDate((Date)defaultData);
        } else if (type == 4) {
            value.setDateArray((Date[])defaultData);
        } else if (type == 5) {
            value.setDouble((Double)defaultData);
        } else if (type == 6) {
            value.setDoubleArray((double[])defaultData);
        } else if (type == 7) {
            value.setFloat(((Float)defaultData).floatValue());
        } else if (type == 8) {
            value.setFloatArray((float[])defaultData);
        } else if (type == 21) {
            value.setGeolocationJSONObject((JSONObject)defaultData);
        } else if (type == 9) {
            value.setInteger((Integer)defaultData);
        } else if (type == 10) {
            value.setIntegerArray((int[])defaultData);
        } else if (type == 11) {
            value.setLong((Long)defaultData);
        } else if (type == 12) {
            value.setLongArray((long[])defaultData);
        } else if (type == 17) {
            value.setNumber((Number)defaultData);
        } else if (type == 18) {
            value.setNumberArray((Number[])defaultData);
        } else if (type == 13) {
            value.setShort((Short)defaultData);
        } else if (type == 14) {
            value.setShortArray((short[])defaultData);
        } else if (type == 15) {
            value.setString((String)defaultData);
        } else if (type == 16) {
            value.setStringArray((String[])defaultData);
        } else if (type == 19) {
            value.setStringArrayMap((Map)defaultData, LocaleUtil.getDefault());
        } else if (type == 20) {
            value.setStringMap((Map)defaultData, LocaleUtil.getDefault());
        }
        return value;
    }
}

