/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.http;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnSoap;
import com.liferay.expando.kernel.service.ExpandoColumnServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.rmi.RemoteException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ExpandoColumnServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(ExpandoColumnServiceSoap.class);

    public static ExpandoColumnSoap addColumn(long tableId, String name, int type) throws RemoteException {
        try {
            ExpandoColumn returnValue = ExpandoColumnServiceUtil.addColumn(tableId, name, type);
            return ExpandoColumnSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ExpandoColumnSoap addColumn(long tableId, String name, int type, Object defaultData) throws RemoteException {
        try {
            ExpandoColumn returnValue = ExpandoColumnServiceUtil.addColumn(tableId, name, type, defaultData);
            return ExpandoColumnSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteColumn(long columnId) throws RemoteException {
        try {
            ExpandoColumnServiceUtil.deleteColumn(columnId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ExpandoColumnSoap fetchExpandoColumn(long columnId) throws RemoteException {
        try {
            ExpandoColumn returnValue = ExpandoColumnServiceUtil.fetchExpandoColumn(columnId);
            return ExpandoColumnSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ExpandoColumnSoap updateColumn(long columnId, String name, int type) throws RemoteException {
        try {
            ExpandoColumn returnValue = ExpandoColumnServiceUtil.updateColumn(columnId, name, type);
            return ExpandoColumnSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ExpandoColumnSoap updateColumn(long columnId, String name, int type, Object defaultData) throws RemoteException {
        try {
            ExpandoColumn returnValue = ExpandoColumnServiceUtil.updateColumn(columnId, name, type, defaultData);
            return ExpandoColumnSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static ExpandoColumnSoap updateTypeSettings(long columnId, String typeSettings) throws RemoteException {
        try {
            ExpandoColumn returnValue = ExpandoColumnServiceUtil.updateTypeSettings(columnId, typeSettings);
            return ExpandoColumnSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

