/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.model.impl;

import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.model.impl.ExpandoValueBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExpandoValueImpl
extends ExpandoValueBaseImpl {
    private static final String _EXPANDO_COMMA = "[$LIFERAY_EXPANDO_COMMA$]";
    private transient ExpandoColumn _column;

    @Override
    public List<Locale> getAvailableLocales() throws PortalException {
        if (!this.isColumnLocalized()) {
            return null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String languageId : LocalizationUtil.getAvailableLanguageIds(this.getData())) {
            locales.add(LocaleUtil.fromLanguageId(languageId));
        }
        return locales;
    }

    @Override
    public boolean getBoolean() throws PortalException {
        this.validate(1);
        return GetterUtil.getBoolean(this.getData());
    }

    @Override
    public boolean[] getBooleanArray() throws PortalException {
        this.validate(2);
        return GetterUtil.getBooleanValues(StringUtil.split(this.getData()));
    }

    @Override
    public ExpandoColumn getColumn() throws PortalException {
        if (this._column != null) {
            return this._column;
        }
        long columnId = this.getColumnId();
        if (columnId <= 0L) {
            return null;
        }
        return ExpandoColumnLocalServiceUtil.getColumn(columnId);
    }

    @Override
    public Date getDate() throws PortalException {
        this.validate(3);
        return new Date(GetterUtil.getLong(this.getData()));
    }

    @Override
    public Date[] getDateArray() throws PortalException {
        this.validate(4);
        String[] data = StringUtil.split(this.getData());
        Date[] dateArray = new Date[data.length];
        for (int i = 0; i < data.length; ++i) {
            dateArray[i] = new Date(GetterUtil.getLong(data[i]));
        }
        return dateArray;
    }

    @Override
    public Locale getDefaultLocale() throws PortalException {
        if (!this.isColumnLocalized()) {
            return null;
        }
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId(this.getData());
        return LocaleUtil.fromLanguageId(defaultLanguageId);
    }

    @Override
    public double getDouble() throws PortalException {
        this.validate(5);
        return GetterUtil.getDouble(this.getData());
    }

    @Override
    public double[] getDoubleArray() throws PortalException {
        this.validate(6);
        return GetterUtil.getDoubleValues(StringUtil.split(this.getData()));
    }

    @Override
    public float getFloat() throws PortalException {
        this.validate(7);
        return GetterUtil.getFloat(this.getData());
    }

    @Override
    public float[] getFloatArray() throws PortalException {
        this.validate(8);
        return GetterUtil.getFloatValues(StringUtil.split(this.getData()));
    }

    @Override
    public JSONObject getGeolocationJSONObject() throws PortalException {
        this.validate(21);
        return JSONFactoryUtil.createJSONObject(this.getData());
    }

    @Override
    public int getInteger() throws PortalException {
        this.validate(9);
        return GetterUtil.getInteger(this.getData());
    }

    @Override
    public int[] getIntegerArray() throws PortalException {
        this.validate(10);
        return GetterUtil.getIntegerValues(StringUtil.split(this.getData()));
    }

    @Override
    public long getLong() throws PortalException {
        this.validate(11);
        return GetterUtil.getLong(this.getData());
    }

    @Override
    public long[] getLongArray() throws PortalException {
        this.validate(12);
        return GetterUtil.getLongValues(StringUtil.split(this.getData()));
    }

    @Override
    public Number getNumber() throws PortalException {
        this.validate(17);
        return GetterUtil.getNumber(this.getData());
    }

    @Override
    public Number[] getNumberArray() throws PortalException {
        this.validate(18);
        return GetterUtil.getNumberValues(StringUtil.split(this.getData()));
    }

    @Override
    public Serializable getSerializable() throws PortalException {
        ExpandoColumn column = this.getColumn();
        int type = column.getType();
        if (type == 1) {
            return Boolean.valueOf(this.getBoolean());
        }
        if (type == 2) {
            return this.getBooleanArray();
        }
        if (type == 3) {
            return this.getDate();
        }
        if (type == 4) {
            return this.getDateArray();
        }
        if (type == 5) {
            return Double.valueOf(this.getDouble());
        }
        if (type == 6) {
            return this.getDoubleArray();
        }
        if (type == 7) {
            return Float.valueOf(this.getFloat());
        }
        if (type == 8) {
            return this.getFloatArray();
        }
        if (type == 9) {
            return Integer.valueOf(this.getInteger());
        }
        if (type == 10) {
            return this.getIntegerArray();
        }
        if (type == 11) {
            return Long.valueOf(this.getLong());
        }
        if (type == 12) {
            return this.getLongArray();
        }
        if (type == 17) {
            return this.getNumber();
        }
        if (type == 18) {
            return this.getNumberArray();
        }
        if (type == 13) {
            return Short.valueOf(this.getShort());
        }
        if (type == 14) {
            return this.getShortArray();
        }
        if (type == 16) {
            return this.getStringArray();
        }
        if (type == 19) {
            return (Serializable)((Object)this.getStringArrayMap());
        }
        if (type == 20) {
            return (Serializable)((Object)this.getStringMap());
        }
        return this.getData();
    }

    @Override
    public short getShort() throws PortalException {
        this.validate(13);
        return GetterUtil.getShort(this.getData());
    }

    @Override
    public short[] getShortArray() throws PortalException {
        this.validate(14);
        return GetterUtil.getShortValues(StringUtil.split(this.getData()));
    }

    @Override
    public String getString() throws PortalException {
        this.validate(15);
        return this.getData();
    }

    @Override
    public String getString(Locale locale) throws PortalException {
        this.validate(20);
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getData(languageId);
    }

    @Override
    public String[] getStringArray() throws PortalException {
        this.validate(16);
        return this.split(this.getData());
    }

    @Override
    public String[] getStringArray(Locale locale) throws PortalException {
        this.validate(19);
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.split(this.getData(languageId));
    }

    @Override
    public Map<Locale, String[]> getStringArrayMap() throws PortalException {
        this.validate(19);
        Map<Locale, String> stringMap = LocalizationUtil.getLocalizationMap(this.getData());
        HashMap<Locale, String[]> stringArrayMap = new HashMap<Locale, String[]>(stringMap.size());
        for (Map.Entry<Locale, String> entry : stringMap.entrySet()) {
            stringArrayMap.put(entry.getKey(), this.split(entry.getValue()));
        }
        return stringArrayMap;
    }

    @Override
    public Map<Locale, String> getStringMap() throws PortalException {
        this.validate(20);
        return LocalizationUtil.getLocalizationMap(this.getData());
    }

    @Override
    public void setBoolean(boolean data) throws PortalException {
        this.validate(1);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setBooleanArray(boolean[] data) throws PortalException {
        this.validate(2);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setColumn(ExpandoColumn column) {
        this._column = column;
        this.setColumnId(this._column.getColumnId());
    }

    @Override
    public void setDate(Date data) throws PortalException {
        this.validate(3);
        this.setData(String.valueOf(data.getTime()));
    }

    @Override
    public void setDateArray(Date[] data) throws PortalException {
        this.validate(4);
        if (data.length > 0) {
            StringBundler sb = new StringBundler(data.length * 2);
            for (Date date : data) {
                sb.append(date.getTime());
                sb.append(",");
            }
            sb.setIndex(sb.index() - 1);
            this.setData(sb.toString());
        } else {
            this.setData("");
        }
    }

    @Override
    public void setDouble(double data) throws PortalException {
        this.validate(5);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setDoubleArray(double[] data) throws PortalException {
        this.validate(6);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setFloat(float data) throws PortalException {
        this.validate(7);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setFloatArray(float[] data) throws PortalException {
        this.validate(8);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setGeolocationJSONObject(JSONObject data) throws PortalException {
        this.validate(21);
        this.setData(data.toJSONString());
    }

    @Override
    public void setInteger(int data) throws PortalException {
        this.validate(9);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setIntegerArray(int[] data) throws PortalException {
        this.validate(10);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setLong(long data) throws PortalException {
        this.validate(11);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setLongArray(long[] data) throws PortalException {
        this.validate(12);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setNumber(Number data) throws PortalException {
        this.validate(17);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setNumberArray(Number[] data) throws PortalException {
        this.validate(18);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setShort(short data) throws PortalException {
        this.validate(13);
        this.setData(String.valueOf(data));
    }

    @Override
    public void setShortArray(short[] data) throws PortalException {
        this.validate(14);
        this.setData(StringUtil.merge(data));
    }

    @Override
    public void setString(String data) throws PortalException {
        this.validate(15);
        this.setData(data);
    }

    @Override
    public void setString(String data, Locale locale, Locale defaultLocale) throws PortalException {
        this.validate(20);
        this.doSetString(data, locale, defaultLocale);
    }

    @Override
    public void setStringArray(String[] data) throws PortalException {
        this.validate(16);
        this.setData(this.merge(data));
    }

    @Override
    public void setStringArray(String[] data, Locale locale, Locale defaultLocale) throws PortalException {
        this.validate(19);
        this.doSetString(this.merge(data), locale, defaultLocale);
    }

    @Override
    public void setStringArrayMap(Map<Locale, String[]> dataMap, Locale defaultLocale) throws PortalException {
        this.validate(19);
        HashMap<Locale, String> stringMap = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String[]> entry : dataMap.entrySet()) {
            stringMap.put(entry.getKey(), this.merge(entry.getValue()));
        }
        this.doSetStringMap(stringMap, defaultLocale);
    }

    @Override
    public void setStringMap(Map<Locale, String> dataMap, Locale defaultLocale) throws PortalException {
        this.validate(20);
        this.doSetStringMap(dataMap, defaultLocale);
    }

    protected void doSetString(String data, Locale locale, Locale defaultLocale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        if (Validator.isNotNull(data)) {
            String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);
            data = LocalizationUtil.updateLocalization(this.getData(), "Data", data, languageId, defaultLanguageId);
        } else {
            data = LocalizationUtil.removeLocalization(this.getData(), "Data", languageId);
        }
        this.setData(data);
    }

    protected void doSetStringMap(Map<Locale, String> dataMap, Locale defaultLocale) {
        if (dataMap == null) {
            return;
        }
        String data = LocalizationUtil.updateLocalization(dataMap, this.getData(), "Data", LocaleUtil.toLanguageId(defaultLocale));
        this.setData(data);
    }

    protected String getData(String languageId) {
        return LocalizationUtil.getLocalization(this.getData(), languageId);
    }

    protected boolean isColumnLocalized() throws PortalException {
        ExpandoColumn column = this.getColumn();
        if (column == null) {
            return false;
        }
        return column.getType() == 19 || column.getType() == 20;
    }

    protected String merge(String[] data) {
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = StringUtil.replace(data[i], ',', _EXPANDO_COMMA);
            }
        }
        return StringUtil.merge(data);
    }

    protected String[] split(String data) {
        String[] dataArray = StringUtil.split(data);
        for (int i = 0; i < dataArray.length; ++i) {
            dataArray[i] = StringUtil.replace(dataArray[i], _EXPANDO_COMMA, ",");
        }
        return dataArray;
    }

    protected void validate(int type) throws PortalException {
        ExpandoColumn column = this.getColumn();
        if (column == null) {
            return;
        }
        if (column.getType() == type) {
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("Column ");
        sb.append(this.getColumnId());
        sb.append(" has type ");
        sb.append(ExpandoColumnConstants.getTypeLabel(column.getType()));
        sb.append(" and is not compatible with type ");
        sb.append(ExpandoColumnConstants.getTypeLabel(type));
        throw new ValueDataException(sb.toString());
    }
}

