/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import java.io.InputStream;

public class DLFileEntryResourceImpl
extends BaseResourceImpl {
    public DLFileEntryResourceImpl(WebDAVRequest webDAVRequest, FileEntry fileEntry, boolean appendPath) {
        super(webDAVRequest.getRootPath() + webDAVRequest.getPath(), DLFileEntryResourceImpl._getName(fileEntry, appendPath), DLFileEntryResourceImpl._getName(fileEntry, true), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize());
        this.setModel(fileEntry);
        this.setClassName(DLFileEntry.class.getName());
        this.setPrimaryKey(fileEntry.getPrimaryKey());
    }

    @Override
    public InputStream getContentAsStream() throws WebDAVException {
        FileEntry fileEntry = this.getModel();
        try {
            FileVersion fileVersion = fileEntry.getLatestFileVersion();
            return fileVersion.getContentStream(true);
        }
        catch (Exception e) {
            throw new WebDAVException(e);
        }
    }

    @Override
    public String getContentType() {
        FileEntry fileEntry = this.getModel();
        try {
            FileVersion fileVersion = fileEntry.getLatestFileVersion();
            return fileVersion.getMimeType();
        }
        catch (Exception e) {
            return fileEntry.getMimeType();
        }
    }

    @Override
    public Lock getLock() {
        FileEntry fileEntry = this.getModel();
        return fileEntry.getLock();
    }

    @Override
    public FileEntry getModel() {
        return (FileEntry)super.getModel();
    }

    @Override
    public long getSize() {
        FileEntry fileEntry = this.getModel();
        try {
            FileVersion fileVersion = fileEntry.getLatestFileVersion();
            return fileVersion.getSize();
        }
        catch (Exception e) {
            return fileEntry.getSize();
        }
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isLocked() {
        FileEntry fileEntry = this.getModel();
        try {
            return fileEntry.hasLock();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String _getName(FileEntry fileEntry, boolean appendPath) {
        if (appendPath) {
            String name = fileEntry.getTitle();
            name = DLWebDAVUtil.escapeRawTitle(name);
            return name;
        }
        return "";
    }
}

