/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util.test;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.TestDataConstants;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.Serializable;
import java.util.HashMap;

public abstract class DLAppTestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileEntry addFileEntryWithWorkflow(long userId, long groupId, long folderId, String sourceFileName, String title, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled(true);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            FileEntry fileEntry = DLAppLocalServiceUtil.addFileEntry(userId, groupId, folderId, sourceFileName, "text/plain", title, "", "", TestDataConstants.TEST_BYTE_ARRAY, serviceContext);
            if (approved) {
                FileEntry fileEntry2 = DLAppTestUtil.updateStatus(fileEntry, serviceContext);
                return fileEntry2;
            }
            FileEntry fileEntry3 = fileEntry;
            return fileEntry3;
        }
        finally {
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
    }

    public static void populateNotificationsServiceContext(ServiceContext serviceContext, String command) throws Exception {
        serviceContext.setAttribute("entryURL", (Serializable)((Object)"http://localhost"));
        if (Validator.isNotNull(command)) {
            serviceContext.setCommand(command);
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    public static void populateServiceContext(ServiceContext serviceContext, long fileEntryTypeId) throws Exception {
        if (fileEntryTypeId != -1L) {
            serviceContext.setAttribute("fileEntryTypeId", Long.valueOf(fileEntryTypeId));
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    protected static FileEntry updateStatus(FileEntry fileEntry, ServiceContext serviceContext) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        HashMap<String, Serializable> workflowContext = new HashMap<String, Serializable>();
        workflowContext.put("url", (Serializable)((Object)"http://localhost"));
        workflowContext.put("event", (Serializable)((Object)"add"));
        DLFileEntryLocalServiceUtil.updateStatus(TestPropsValues.getUserId(), fileVersion.getFileVersionId(), 0, serviceContext, workflowContext);
        return DLAppLocalServiceUtil.getFileEntry(fileEntry.getFileEntryId());
    }
}

