/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileShortcut;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RepositoryModelUtil {
    public static List<FileEntry> toFileEntries(List<DLFileEntry> dlFileEntries) {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>(dlFileEntries.size());
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            fileEntries.add(fileEntry);
        }
        if (ListUtil.isUnmodifiableList(dlFileEntries)) {
            return Collections.unmodifiableList(fileEntries);
        }
        return fileEntries;
    }

    public static List<FileShortcut> toFileShortcuts(List<DLFileShortcut> dlFileShortcuts) {
        ArrayList<FileShortcut> fileShortcuts = new ArrayList<FileShortcut>(dlFileShortcuts.size());
        for (DLFileShortcut dlFileShortcut : dlFileShortcuts) {
            LiferayFileShortcut fileShortcut = new LiferayFileShortcut(dlFileShortcut);
            fileShortcuts.add(fileShortcut);
        }
        if (ListUtil.isUnmodifiableList(dlFileShortcuts)) {
            return Collections.unmodifiableList(fileShortcuts);
        }
        return fileShortcuts;
    }

    public static List<FileVersion> toFileVersions(List<DLFileVersion> dlFileVersions) {
        ArrayList<FileVersion> fileVersions = new ArrayList<FileVersion>(dlFileVersions.size());
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileVersion);
            fileVersions.add(fileVersion);
        }
        if (ListUtil.isUnmodifiableList(dlFileVersions)) {
            return Collections.unmodifiableList(fileVersions);
        }
        return fileVersions;
    }

    public static List<Folder> toFolders(List<DLFolder> dlFolders) {
        ArrayList<Folder> folders = new ArrayList<Folder>(dlFolders.size());
        for (DLFolder dlFolder : dlFolders) {
            LiferayFolder folder = new LiferayFolder(dlFolder);
            folders.add(folder);
        }
        if (ListUtil.isUnmodifiableList(dlFolders)) {
            return Collections.unmodifiableList(folders);
        }
        return folders;
    }

    public static List<RepositoryEntry> toRepositoryEntries(List<Object> dlFoldersAndDLFileEntriesAndDLFileShortcuts) {
        ArrayList<RepositoryEntry> repositoryEntries = new ArrayList<RepositoryEntry>(dlFoldersAndDLFileEntriesAndDLFileShortcuts.size());
        for (Object object : dlFoldersAndDLFileEntriesAndDLFileShortcuts) {
            if (object instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
                repositoryEntries.add(fileEntry);
                continue;
            }
            if (object instanceof DLFolder) {
                DLFolder dlFolder = (DLFolder)object;
                LiferayFolder folder = new LiferayFolder(dlFolder);
                repositoryEntries.add(folder);
                continue;
            }
            if (object instanceof DLFileShortcut) {
                DLFileShortcut dlFileShortcut = (DLFileShortcut)object;
                LiferayFileShortcut fileShortcut = new LiferayFileShortcut(dlFileShortcut);
                repositoryEntries.add(fileShortcut);
                continue;
            }
            throw new IllegalArgumentException(String.format("Expected an instance of one of: %s; got %s", Arrays.asList(DLFileEntry.class.getName(), DLFolder.class.getName(), DLFileShortcutConstants.getClassName()), object));
        }
        if (ListUtil.isUnmodifiableList(dlFoldersAndDLFileEntriesAndDLFileShortcuts)) {
            return Collections.unmodifiableList(repositoryEntries);
        }
        return repositoryEntries;
    }
}

