/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.RawMetadataProcessor;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class RawMetadataProcessorImpl
implements DLProcessor,
RawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(RawMetadataProcessorImpl.class);

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public void cleanUp(FileEntry fileEntry) {
    }

    @Override
    public void cleanUp(FileVersion fileVersion) {
    }

    @Override
    public void copy(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    @Override
    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    @Override
    public void generateMetadata(FileVersion fileVersion) {
        long fileEntryMetadataCount = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatasCount(fileVersion.getFileVersionId());
        if (fileEntryMetadataCount == 0L) {
            this.trigger(fileVersion);
        }
    }

    @Override
    public String getType() {
        return "RawMetadataProcessor";
    }

    @Override
    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) {
    }

    @Override
    public boolean isSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion.getMimeType());
    }

    @Override
    public boolean isSupported(String mimeType) {
        return !ArrayUtil.contains(PropsValues.DL_FILE_ENTRY_RAW_METADATA_PROCESSOR_EXCLUDED_MIME_TYPES, mimeType);
    }

    @Override
    public void saveMetadata(FileVersion fileVersion) throws PortalException {
        Map<String, DDMFormValues> rawMetadataMap;
        block24: {
            Serializable file;
            rawMetadataMap = null;
            if (fileVersion instanceof LiferayFileVersion) {
                try {
                    LiferayFileVersion liferayFileVersion = (LiferayFileVersion)fileVersion;
                    file = liferayFileVersion.getFile(false);
                    rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap(fileVersion.getExtension(), fileVersion.getMimeType(), (File)file);
                }
                catch (UnsupportedOperationException liferayFileVersion) {
                    // empty catch block
                }
            }
            if (rawMetadataMap == null) {
                try {
                    InputStream inputStream = fileVersion.getContentStream(false);
                    file = null;
                    try {
                        if (inputStream == null) {
                            if (_log.isWarnEnabled()) {
                                _log.warn("No metadata is available for file version " + fileVersion.getFileVersionId());
                            }
                            return;
                        }
                        rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap(fileVersion.getExtension(), fileVersion.getMimeType(), inputStream);
                    }
                    catch (Throwable throwable) {
                        file = throwable;
                        throw throwable;
                    }
                    finally {
                        if (inputStream != null) {
                            if (file != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)file).addSuppressed(throwable);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block24;
                    _log.warn(ioe, ioe);
                }
            }
        }
        List<DDMStructure> ddmStructures = DDMStructureManagerUtil.getClassStructures(fileVersion.getCompanyId(), PortalUtil.getClassNameId(RawMetadataProcessor.class), -1, -1);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(fileVersion.getGroupId());
        serviceContext.setUserId(fileVersion.getUserId());
        DLFileEntryMetadataLocalServiceUtil.updateFileEntryMetadata(fileVersion.getCompanyId(), ddmStructures, fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), rawMetadataMap, serviceContext);
        FileEntry fileEntry = fileVersion.getFileEntry();
        if (fileEntry instanceof LiferayFileEntry) {
            Indexer<DLFileEntry> indexer = IndexerRegistryUtil.getIndexer(DLFileEntryConstants.getClassName());
            LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
            indexer.reindex(liferayFileEntry.getDLFileEntry());
        }
    }

    @Override
    public void trigger(FileVersion fileVersion) {
        this.trigger(fileVersion, fileVersion);
    }

    @Override
    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        MessageBusUtil.sendMessage("liferay/document_library_raw_metadata_processor", destinationFileVersion);
    }
}

