/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.PDFProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.fabric.InputResource;
import com.liferay.portal.fabric.OutputResource;
import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.event.FileVersionPreviewEventListener;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.util.LiferayPDFBoxConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;

public class PDFProcessorImpl
extends DLPreviewableProcessor
implements PDFProcessor {
    private static final Log _log = LogFactoryUtil.getLog(PDFProcessorImpl.class);
    private static volatile FileVersionPreviewEventListener _fileVersionPreviewEventListener = ServiceProxyFactory.newServiceTrackedInstance(FileVersionPreviewEventListener.class, PDFProcessorImpl.class, "_fileVersionPreviewEventListener", false, false);
    private static volatile ProcessExecutor _processExecutor = ServiceProxyFactory.newServiceTrackedInstance(ProcessExecutor.class, PDFProcessorImpl.class, "_processExecutor", true);
    private final List<Long> _fileVersionIds = new Vector<Long>();
    private boolean _ghostscriptInitialized;

    @Override
    public void afterPropertiesSet() {
        FileUtil.mkdirs(DECRYPT_TMP_PATH);
        FileUtil.mkdirs(PREVIEW_TMP_PATH);
        FileUtil.mkdirs(THUMBNAIL_TMP_PATH);
    }

    @Override
    public void destroy() {
        FileUtil.deltree(TMP_PATH);
    }

    @Override
    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateImages(sourceFileVersion, destinationFileVersion);
    }

    @Override
    public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, index, "png");
    }

    @Override
    public int getPreviewFileCount(FileVersion fileVersion) {
        try {
            return this.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception e) {
            _log.error(e, e);
            return 0;
        }
    }

    @Override
    public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, index);
    }

    @Override
    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    @Override
    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    @Override
    public String getType() {
        return "PDFProcessor";
    }

    @Override
    public boolean hasImages(FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return hasImages;
    }

    @Override
    public boolean isDocumentSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    @Override
    public boolean isDocumentSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    @Override
    public boolean isSupported(String mimeType) {
        if (Validator.isNull(mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set<String> extensions = MimeTypesUtil.getExtensions(mimeType);
            for (String extension : extensions) {
                Object[] targetExtensions = DocumentConversionUtil.getConversions(extension = extension.substring(1));
                if (Arrays.binarySearch(targetExtensions, "pdf") < 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    @Override
    protected void copyPreviews(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            return;
        }
        try {
            if (this.hasPreview(sourceFileVersion) && !this.hasPreview(destinationFileVersion)) {
                int count = this.getPreviewFileCount(sourceFileVersion);
                for (int i = 0; i < count; ++i) {
                    String previewFilePath = this.getPreviewFilePath(destinationFileVersion, i + 1);
                    InputStream is = this.doGetPreviewAsStream(sourceFileVersion, i + 1, "png");
                    this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", previewFilePath, is);
                }
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "pdf");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    @Override
    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this._hasImages(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            fileEntryElement.addAttribute("bin-path-pdf-preview-count", String.valueOf(previewFileCount));
            for (int i = 0; i < previewFileCount; ++i) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "pdf", "png", i);
            }
        }
    }

    @Override
    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    @Override
    protected String getPreviewType(FileVersion fileVersion) {
        return "png";
    }

    @Override
    protected String getThumbnailType(FileVersion fileVersion) {
        return "png";
    }

    protected boolean hasPreview(FileVersion fileVersion) throws Exception {
        return this.hasPreview(fileVersion, null);
    }

    @Override
    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, 1);
        return DLStoreUtil.hasFile(fileVersion.getCompanyId(), 0L, previewFilePath);
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        int previewFileCount = GetterUtil.getInteger(fileEntryElement.attributeValue("bin-path-pdf-preview-count"));
        for (int i = 0; i < previewFileCount; ++i) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf", "png", i);
        }
    }

    private void _addDimensions(List<String> arguments, File file) throws Exception {
        Map<String, Integer> scaledDimensions = this._getScaledDimensions(file);
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH != 0 && PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            arguments.add("-dDEVICEWIDTH=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
            arguments.add("-dDEVICEHEIGHT=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT);
        } else if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH != 0 && PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT == 0) {
            arguments.add("-dDEVICEWIDTH=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH);
            arguments.add("-dDEVICEHEIGHT=" + scaledDimensions.get("height"));
        } else if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH == 0 && PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            arguments.add("-dDEVICEWIDTH=" + scaledDimensions.get("width"));
            arguments.add("-dDEVICEHEIGHT=" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT);
        }
    }

    private void _generateImages(FileVersion fileVersion, File file) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            if (!this._ghostscriptInitialized) {
                GhostscriptUtil.reset();
                this._ghostscriptInitialized = true;
            }
            this._generateImagesGS(fileVersion, file);
        } else {
            this._generateImagesPB(fileVersion, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void _generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block38: {
            block39: {
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (this._hasImages(destinationFileVersion)) {
                    return;
                }
                extension = destinationFileVersion.getExtension();
                if (!extension.equals("pdf")) break block39;
                if (!(destinationFileVersion instanceof LiferayFileVersion)) ** GOTO lbl-1000
                try {
                    liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                    file = liferayFileVersion.getFile(false);
                    this._generateImages(destinationFileVersion, file);
                    return;
                }
                catch (UnsupportedOperationException liferayFileVersion) lbl-1000:
                // 2 sources

                {
                    inputStream = destinationFileVersion.getContentStream(false);
                    var5_10 = null;
                    try {
                        this._generateImages(destinationFileVersion, inputStream);
                        break block38;
                    }
                    catch (Throwable var6_13) {
                        var5_10 = var6_13;
                        throw var6_13;
                    }
                    finally {
                        if (inputStream != null) {
                            if (var5_10 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable var6_12) {
                                    var5_10.addSuppressed(var6_12);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
            }
            if (!DocumentConversionUtil.isEnabled()) break block38;
            inputStream = destinationFileVersion.getContentStream(false);
            var5_11 = null;
            try {
                tempFileId = DLUtil.getTempFileId(destinationFileVersion.getFileEntryId(), destinationFileVersion.getVersion());
                if (Objects.equals(destinationFileVersion.getVersion(), "PWC") || destinationFileVersion.isPending()) {
                    file = new File(DocumentConversionUtil.getFilePath(tempFileId, "pdf"));
                    FileUtil.delete(file);
                }
                file = DocumentConversionUtil.convert(tempFileId, inputStream, extension, "pdf");
                this._generateImages(destinationFileVersion, file);
            }
            catch (Throwable var6_16) {
                var5_11 = var6_16;
                throw var6_16;
            }
            finally {
                if (inputStream != null) {
                    if (var5_11 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable var6_15) {
                            var5_11.addSuppressed(var6_15);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                if (PDFProcessorImpl._log.isDebugEnabled()) {
                    PDFProcessorImpl._log.debug(nsfee, nsfee);
                }
                break block38;
            }
            finally {
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            }
        }
    }

    private void _generateImages(FileVersion fileVersion, InputStream inputStream) throws Exception {
        if (GhostscriptUtil.isEnabled()) {
            this._generateImagesGS(fileVersion, inputStream);
        } else {
            this._generateImagesPB(fileVersion, inputStream);
        }
    }

    private void _generateImagesGS(FileVersion fileVersion, File file) throws Exception {
        StopWatch stopWatch;
        if (this._isGeneratePreview(fileVersion)) {
            stopWatch = new StopWatch();
            stopWatch.start();
            this._generateImagesGS(fileVersion, file, false);
            if (_log.isInfoEnabled()) {
                int previewFileCount = this.getPreviewFileCount(fileVersion);
                _log.info(StringBundler.concat("Ghostscript generated ", previewFileCount, " preview pages for ", fileVersion.getTitle(), " in ", stopWatch.getTime(), " ms"));
            }
        }
        if (this._isGenerateThumbnail(fileVersion)) {
            stopWatch = new StopWatch();
            stopWatch.start();
            this._generateImagesGS(fileVersion, file, true);
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat("Ghostscript generated a thumbnail for ", fileVersion.getTitle(), " in ", stopWatch.getTime(), " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesGS(FileVersion fileVersion, File file, boolean thumbnail) throws Exception {
        String tempFileId = DLUtil.getTempFileId(fileVersion.getFileEntryId(), fileVersion.getVersion());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-sDEVICE=png16m");
        if (thumbnail) {
            arguments.add("-sOutputFile=" + this.getThumbnailTempFilePath(tempFileId));
            arguments.add("-dFirstPage=1");
            arguments.add("-dLastPage=1");
        } else {
            arguments.add("-sOutputFile=" + this.getPreviewTempFilePath(tempFileId, -1));
        }
        arguments.add("-dPDFFitPage");
        arguments.add("-dTextAlphaBits=4");
        arguments.add("-dGraphicsAlphaBits=4");
        arguments.add("-r" + PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI);
        this._addDimensions(arguments, file);
        arguments.add(file.getPath());
        Future<?> future = GhostscriptUtil.execute(arguments);
        String processIdentity = String.valueOf(fileVersion.getFileVersionId());
        long ghostscriptTimeout = PropsValues.DL_FILE_ENTRY_PREVIEW_GENERATION_TIMEOUT_GHOSTSCRIPT;
        if (_log.isDebugEnabled()) {
            if (thumbnail) {
                _log.debug(StringBundler.concat("Waiting for ", ghostscriptTimeout, " seconds to generate thumbnail for ", file.getPath()));
            } else {
                _log.debug(StringBundler.concat("Waiting for ", ghostscriptTimeout, " seconds to generate preview for ", file.getPath()));
            }
        }
        try {
            future.get(ghostscriptTimeout, TimeUnit.SECONDS);
            this.futures.put(processIdentity, future);
        }
        catch (TimeoutException te) {
            String errorMessage = "Timeout when generating preview for " + file.getPath();
            if (thumbnail) {
                errorMessage = "Timeout when generating thumbanil for " + file.getPath();
            }
            if (future.cancel(true)) {
                errorMessage = errorMessage + " resulted in a canceled timeout for " + future;
            }
            _fileVersionPreviewEventListener.onFailure(fileVersion);
            _log.error(errorMessage);
            throw te;
        }
        catch (Exception e) {
            _fileVersionPreviewEventListener.onFailure(fileVersion);
            _log.error(e, e);
            throw e;
        }
        if (thumbnail) {
            File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
            try {
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
            }
            finally {
                FileUtil.delete(thumbnailTempFile);
            }
        } else {
            int total = this.getPreviewTempFileCount(fileVersion);
            for (int i = 0; i < total; ++i) {
                File previewTempFile = this.getPreviewTempFile(tempFileId, i + 2);
                try {
                    this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, i + 1), previewTempFile);
                    _fileVersionPreviewEventListener.onSuccess(fileVersion);
                    continue;
                }
                finally {
                    FileUtil.delete(previewTempFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesGS(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile(inputStream);
            this._generateImagesGS(fileVersion, file);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesPB(FileVersion fileVersion, File file) throws Exception {
        String tempFileId = DLUtil.getTempFileId(fileVersion.getFileEntryId(), fileVersion.getVersion());
        File decryptedFile = this.getDecryptedTempFile(tempFileId);
        int previewFilesCount = this._getPreviewFilesCount(file, decryptedFile);
        if (previewFilesCount == 0) {
            _log.error("Unable to decrypt PDF document for file version " + fileVersion.getFileVersionId());
            _fileVersionPreviewEventListener.onFailure(fileVersion);
            return;
        }
        File thumbnailFile = this.getThumbnailTempFile(tempFileId);
        File[] previewFiles = new File[previewFilesCount];
        for (int i = 0; i < previewFilesCount; ++i) {
            previewFiles[i] = this.getPreviewTempFile(tempFileId, i);
        }
        boolean generatePreview = this._isGeneratePreview(fileVersion);
        boolean generateThumbnail = this._isGenerateThumbnail(fileVersion);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
            LiferayPDFBoxProcessCallable processCallable = new LiferayPDFBoxProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), decryptedFile, thumbnailFile, previewFiles, this.getThumbnailType(fileVersion), this.getPreviewType(fileVersion), PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, generatePreview, generateThumbnail);
            ProcessChannel<String> processChannel = _processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), processCallable);
            NoticeableFuture<String> future = processChannel.getProcessNoticeableFuture();
            String processIdentity = String.valueOf(fileVersion.getFileVersionId());
            long pdfBoxTimeout = PropsValues.DL_FILE_ENTRY_PREVIEW_GENERATION_TIMEOUT_PDFBOX;
            if (_log.isDebugEnabled()) {
                if (generateThumbnail && generatePreview) {
                    _log.debug(StringBundler.concat("Waiting for ", pdfBoxTimeout, " seconds to generate thumbnail and preview for ", decryptedFile.getPath()));
                } else {
                    if (generateThumbnail) {
                        _log.debug(StringBundler.concat("Waiting for ", pdfBoxTimeout, " seconds to generate thumbnail for ", decryptedFile.getPath()));
                    }
                    if (generatePreview) {
                        _log.debug(StringBundler.concat("Waiting for ", pdfBoxTimeout, " seconds to generate preview for ", decryptedFile.getPath()));
                    }
                }
            }
            try {
                future.get(pdfBoxTimeout, TimeUnit.SECONDS);
                this.futures.put(processIdentity, future);
            }
            catch (TimeoutException te) {
                String errorMessage = null;
                if (generateThumbnail && generatePreview) {
                    errorMessage = "Timeout when generating thumbnail and preview for " + decryptedFile.getPath();
                } else {
                    if (generateThumbnail) {
                        errorMessage = "Timeout when generating thumbnail for " + decryptedFile.getPath();
                    }
                    if (generatePreview) {
                        errorMessage = "Timeout when generating preview for " + decryptedFile.getPath();
                    }
                }
                if (future.cancel(true)) {
                    errorMessage = errorMessage + " resulted in a canceled timeout for " + future;
                }
                _log.error(errorMessage);
                _fileVersionPreviewEventListener.onFailure(fileVersion);
                throw te;
            }
            catch (Exception e) {
                _log.error(e, e);
                _fileVersionPreviewEventListener.onFailure(fileVersion);
                throw e;
            }
        } else {
            LiferayPDFBoxConverter liferayConverter = new LiferayPDFBoxConverter(decryptedFile, thumbnailFile, previewFiles, this.getPreviewType(fileVersion), this.getThumbnailType(fileVersion), PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH, generatePreview, generateThumbnail);
            liferayConverter.generateImagesPB();
        }
        FileUtil.delete(decryptedFile);
        if (generateThumbnail) {
            try {
                this.storeThumbnailImages(fileVersion, thumbnailFile);
            }
            finally {
                FileUtil.delete(thumbnailFile);
            }
        }
        if (generatePreview) {
            int index = 0;
            for (File previewFile : previewFiles) {
                try {
                    this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, index + 1), previewFile);
                    _fileVersionPreviewEventListener.onSuccess(fileVersion);
                }
                finally {
                    FileUtil.delete(previewFile);
                }
                ++index;
            }
        }
        if (_log.isInfoEnabled()) {
            long fileVersionId = fileVersion.getFileVersionId();
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            long time = stopWatch.getTime();
            if (generateThumbnail && generatePreview) {
                _log.info(StringBundler.concat("PDFBox generated a thumbnail and ", previewFileCount, " preview pages for ", fileVersionId, " in ", time, " ms"));
            } else {
                if (generateThumbnail) {
                    _log.info(StringBundler.concat("PDFBox generated a thumbnail for ", fileVersionId, " in ", time, " ms"));
                }
                if (generatePreview) {
                    _log.info(StringBundler.concat("PDFBox generated ", previewFileCount, " preview pages for ", fileVersionId, " in ", time, " ms"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateImagesPB(FileVersion fileVersion, InputStream inputStream) throws Exception {
        File file = null;
        try {
            file = FileUtil.createTempFile(inputStream);
            this._generateImagesPB(fileVersion, file);
        }
        finally {
            FileUtil.delete(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _getPreviewFilesCount(File encryptedFile, File decryptedFile) {
        String[] decryptPasswords;
        String[] stringArray = decryptPasswords = ArrayUtil.append(PropsValues.DL_FILE_ENTRY_PREVIEW_GENERATION_DECRYPT_PASSWORDS_PDFBOX, "");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String decryptPassword = stringArray[n2];
            try (PDDocument pdDocument = PDDocument.load((File)encryptedFile, (String)decryptPassword);){
                pdDocument.setAllSecurityToBeRemoved(true);
                pdDocument.save(decryptedFile);
                int n3 = pdDocument.getNumberOfPages();
                return n3;
            }
            catch (IOException ioe) {
                if (!(ioe instanceof InvalidPasswordException)) {
                    _log.error(ioe, ioe);
                }
                ++n2;
            }
        }
        return 0;
    }

    private Map<String, Integer> _getScaledDimensions(File file) throws Exception {
        try (PDDocument pdDocument = PDDocument.load((File)file);){
            HashMap<String, Integer> scaledDimensions = new HashMap<String, Integer>();
            PDDocumentCatalog pdDocumentCatalog = pdDocument.getDocumentCatalog();
            PDPageTree pages = pdDocumentCatalog.getPages();
            PDPage pdPage = pages.get(0);
            PDRectangle pdRectangle = pdPage.getMediaBox();
            float width = pdRectangle.getWidth();
            double widthFactor = (double)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH / (double)width;
            float height = pdRectangle.getHeight();
            int scaledHeight = (int)Math.round(widthFactor * (double)height);
            scaledDimensions.put("height", scaledHeight);
            double heightFactor = (double)PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT / (double)height;
            int scaledWidth = (int)Math.round(heightFactor * (double)width);
            scaledDimensions.put("width", scaledWidth);
            HashMap<String, Integer> hashMap = scaledDimensions;
            return hashMap;
        }
    }

    private boolean _hasImages(FileVersion fileVersion) throws Exception {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion)) {
            return false;
        }
        return this.hasThumbnails(fileVersion);
    }

    private boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        return PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !this.hasPreview(fileVersion);
    }

    private boolean _isGenerateThumbnail(FileVersion fileVersion) {
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !this.hasThumbnail(fileVersion, 0);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = destinationFileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            for (String conversion : conversions = DocumentConversionUtil.getConversions(extension)) {
                if (!conversion.equals("pdf")) continue;
                generateImages = true;
                break;
            }
        }
        if (generateImages) {
            this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
            this.sendGenerationMessage("liferay/document_library_pdf_processor", sourceFileVersion, destinationFileVersion);
        }
    }

    private static class LiferayPDFBoxProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> _customLogSettings;
        private final int _dpi;
        private final String _extension;
        private final boolean _generatePreview;
        private final boolean _generateThumbnail;
        private final int _height;
        @InputResource
        private final File _inputFile;
        private final String _liferayHome;
        @OutputResource
        private final File[] _previewFiles;
        private final String _serverId;
        private final String _thumbnailExtension;
        @OutputResource
        private final File _thumbnailFile;
        private final int _width;

        public LiferayPDFBoxProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, File inputFile, File thumbnailFile, File[] previewFiles, String extension, String thumbnailExtension, int dpi, int height, int width, boolean generatePreview, boolean generateThumbnail) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputFile = inputFile;
            this._thumbnailFile = thumbnailFile;
            this._previewFiles = previewFiles;
            this._extension = extension;
            this._thumbnailExtension = thumbnailExtension;
            this._dpi = dpi;
            this._height = height;
            this._width = width;
            this._generatePreview = generatePreview;
            this._generateThumbnail = generateThumbnail;
        }

        @Override
        public String call() throws ProcessException {
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties(systemProperties);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J(this._serverId, this._liferayHome, classLoader, new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayPDFBoxConverter liferayConverter = new LiferayPDFBoxConverter(this._inputFile, this._thumbnailFile, this._previewFiles, this._extension, this._thumbnailExtension, this._dpi, this._height, this._width, this._generatePreview, this._generateThumbnail);
                liferayConverter.generateImagesPB();
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
            return "";
        }
    }
}

