/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IAudioResampler;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import java.util.Properties;

public class LiferayAudioConverter
extends LiferayConverter {
    private static final Log _log = LogFactoryUtil.getLog(LiferayAudioConverter.class);
    private int _audioBitRate;
    private final String _audioContainer;
    private int _audioSampleRate;
    private IContainer _inputIContainer;
    private final String _inputURL;
    private IContainer _outputIContainer;
    private final String _outputURL;

    public LiferayAudioConverter(String inputURL, String outputURL, String audioContainer, Properties audioProperties) {
        this._inputURL = inputURL;
        this._outputURL = outputURL;
        this._audioContainer = audioContainer;
        this.initAudioBitRate(audioProperties);
        this.initAudioSampleRate(audioProperties);
    }

    @Override
    public void convert() throws Exception {
        try {
            this.doConvert();
        }
        finally {
            if (this._inputIContainer != null && this._inputIContainer.isOpened()) {
                this._inputIContainer.close();
            }
            if (this._outputIContainer != null && this._outputIContainer.isOpened()) {
                this._outputIContainer.close();
            }
        }
    }

    protected void doConvert() throws Exception {
        this._inputIContainer = IContainer.make();
        this._outputIContainer = IContainer.make();
        this.openContainer(this._inputIContainer, this._inputURL, false);
        this.openContainer(this._outputIContainer, this._outputURL, true);
        int inputStreamsCount = this._inputIContainer.getNumStreams();
        if (inputStreamsCount < 0) {
            throw new RuntimeException("Input URL does not have any streams");
        }
        IAudioResampler[] iAudioResamplers = new IAudioResampler[inputStreamsCount];
        IAudioSamples[] inputIAudioSamples = new IAudioSamples[inputStreamsCount];
        IAudioSamples[] outputIAudioSamples = new IAudioSamples[inputStreamsCount];
        IStream[] outputIStreams = new IStream[inputStreamsCount];
        IStreamCoder[] inputIStreamCoders = new IStreamCoder[inputStreamsCount];
        IStreamCoder[] outputIStreamCoders = new IStreamCoder[inputStreamsCount];
        for (int i = 0; i < inputStreamsCount; ++i) {
            IStreamCoder inputIStreamCoder;
            IStream inputIStream = this._inputIContainer.getStream((long)i);
            inputIStreamCoders[i] = inputIStreamCoder = inputIStream.getStreamCoder();
            ICodec.Type inputICodecType = inputIStreamCoder.getCodecType();
            if (inputICodecType == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.prepareAudio(iAudioResamplers, inputIAudioSamples, outputIAudioSamples, inputIStreamCoder, outputIStreamCoders, this._outputIContainer, outputIStreams, inputICodecType, this._outputURL, i);
            }
            this.openStreamCoder(inputIStreamCoders[i]);
            this.openStreamCoder(outputIStreamCoders[i]);
        }
        if (this._outputIContainer.writeHeader() < 0) {
            throw new RuntimeException("Unable to write container header");
        }
        IPacket inputIPacket = IPacket.make();
        IPacket outputIPacket = IPacket.make();
        int previousPacketSize = -1;
        this._inputIContainer.readNextPacket(inputIPacket);
        while (this._inputIContainer.readNextPacket(inputIPacket) == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug("Current packet size " + inputIPacket.getSize());
            }
            int streamIndex = inputIPacket.getStreamIndex();
            IStreamCoder inputIStreamCoder = inputIStreamCoders[streamIndex];
            IStreamCoder outputIStreamCoder = outputIStreamCoders[streamIndex];
            if (outputIStreamCoder == null) continue;
            if (inputIStreamCoder.getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
                IStream iStream = this._inputIContainer.getStream((long)streamIndex);
                long timeStampOffset = this.getStreamTimeStampOffset(iStream);
                this.decodeAudio(iAudioResamplers[streamIndex], inputIAudioSamples[streamIndex], outputIAudioSamples[streamIndex], inputIPacket, outputIPacket, inputIStreamCoder, outputIStreamCoder, this._outputIContainer, inputIPacket.getSize(), previousPacketSize, streamIndex, timeStampOffset);
            }
            previousPacketSize = inputIPacket.getSize();
        }
        this.flush(outputIStreamCoders, this._outputIContainer);
        if (this._outputIContainer.writeTrailer() < 0) {
            throw new RuntimeException("Unable to write trailer to output file");
        }
        this.cleanUp((RefCounted[])iAudioResamplers, null);
        this.cleanUp((RefCounted[])inputIAudioSamples, (RefCounted[])outputIAudioSamples);
        this.cleanUp(inputIStreamCoders, outputIStreamCoders);
        this.cleanUp(inputIPacket, outputIPacket);
    }

    @Override
    protected int getAudioBitRate(ICodec outputICodec, int originalBitRate) {
        return this.getCodecBitRate(outputICodec, this.getProperty(originalBitRate, this._audioBitRate, 500000));
    }

    @Override
    protected int getAudioSampleRate() {
        return this._audioSampleRate;
    }

    @Override
    protected IContainer getInputIContainer() {
        return this._inputIContainer;
    }

    protected void initAudioBitRate(Properties audioProperties) {
        this._audioBitRate = this.getProperty(audioProperties, "dl.file.entry.preview.audio.bit.rate", "audio bit rate", this._audioContainer, 64000, 500000);
    }

    protected void initAudioSampleRate(Properties audioProperties) {
        this._audioSampleRate = this.getProperty(audioProperties, "dl.file.entry.preview.audio.sample.rate", "audio sample rate", this._audioContainer, 44100, 192000);
    }
}

