/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DL;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelReadCountComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelSizeComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletLayoutFinderRegistryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLImpl
implements DL {
    private static final String _DEFAULT_FILE_ICON = "page";
    private static final String _DEFAULT_GENERIC_NAME = "default";
    private static final long _DIVISOR = 256L;
    private static final String[] _MICROSOFT_OFFICE_EXTENSIONS;
    private static final String _STRUCTURE_KEY_PREFIX = "AUTO_";
    private static final Log _log;
    private static final Set<String> _allMediaGalleryMimeTypes;
    private static final Set<String> _fileIcons;
    private static final Map<String, String> _genericNames;

    @Override
    public int compareVersions(String version1, String version2) {
        int[] splitVersion1 = StringUtil.split(version1, ".", 0);
        int[] splitVersion2 = StringUtil.split(version2, ".", 0);
        if (splitVersion1.length != 2 && splitVersion2.length != 2) {
            return 0;
        }
        if (splitVersion1.length != 2) {
            return -1;
        }
        if (splitVersion2.length != 2) {
            return 1;
        }
        if (splitVersion1[0] > splitVersion2[0]) {
            return 1;
        }
        if (splitVersion1[0] < splitVersion2[0]) {
            return -1;
        }
        if (splitVersion1[1] > splitVersion2[1]) {
            return 1;
        }
        if (splitVersion1[1] < splitVersion2[1]) {
            return -1;
        }
        return 0;
    }

    public void destroy() {
    }

    @Override
    public String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        Folder folder = DLAppLocalServiceUtil.getFolder(folderId);
        List<Folder> folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (Folder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    @Override
    public Set<String> getAllMediaGalleryMimeTypes() {
        return _allMediaGalleryMimeTypes;
    }

    @Override
    public String getDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDDMStructureKey(dlFileEntryType.getUuid());
    }

    @Override
    public String getDDMStructureKey(String fileEntryTypeUuid) {
        return _STRUCTURE_KEY_PREFIX + StringUtil.toUpperCase(fileEntryTypeUuid);
    }

    @Override
    public String getDeprecatedDDMStructureKey(DLFileEntryType dlFileEntryType) {
        return this.getDeprecatedDDMStructureKey(dlFileEntryType.getFileEntryTypeId());
    }

    @Override
    public String getDeprecatedDDMStructureKey(long fileEntryTypeId) {
        return _STRUCTURE_KEY_PREFIX + fileEntryTypeId;
    }

    @Override
    public String getDividedPath(long id) {
        StringBundler sb = new StringBundler(16);
        long dividend = id;
        while (dividend / 256L != 0L) {
            sb.append("/");
            sb.append(dividend % 256L);
            dividend /= 256L;
        }
        sb.append("/");
        sb.append(id);
        return sb.toString();
    }

    @Override
    @Deprecated
    public String getDLFileEntryControlPanelLink(PortletRequest portletRequest, long fileEntryId) {
        String portletId = PortletProviderUtil.getPortletId(FileEntry.class.getName(), PortletProvider.Action.MANAGE);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntryId));
        return portletURL.toString();
    }

    @Override
    @Deprecated
    public String getDLFolderControlPanelLink(PortletRequest portletRequest, long folderId) {
        String portletId = PortletProviderUtil.getPortletId(Folder.class.getName(), PortletProvider.Action.MANAGE);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    @Override
    @Deprecated
    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getDownloadURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    @Override
    @Deprecated
    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String previewURL = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        return HttpUtil.addParameter(previewURL, "download", true);
    }

    @Override
    public Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get(themeDisplay.getLocale(), "the-company-id-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get(themeDisplay.getLocale(), "the-company-mx-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-company-name-associated-with-the-document"));
        definitionTerms.put("[$DOCUMENT_TITLE$]", LanguageUtil.get(themeDisplay.getLocale(), "the-document-title"));
        definitionTerms.put("[$DOCUMENT_TYPE$]", LanguageUtil.get(themeDisplay.getLocale(), "the-document-type"));
        definitionTerms.put("[$DOCUMENT_URL$]", LanguageUtil.get(themeDisplay.getLocale(), "the-document-url"));
        definitionTerms.put("[$DOCUMENT_USER_ADDRESS$]", LanguageUtil.get(themeDisplay.getLocale(), "the-email-address-of-the-user-who-added-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-user-who-added-the-document"));
        definitionTerms.put("[$FOLDER_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-folder-in-which-the-document-has-been-added"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape(emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape(emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape(portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-site-name-associated-with-the-document"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get(themeDisplay.getLocale(), "the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    @Override
    public Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get(themeDisplay.getLocale(), "the-company-id-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get(themeDisplay.getLocale(), "the-company-mx-associated-with-the-document"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-company-name-associated-with-the-document"));
        definitionTerms.put("[$DOCUMENT_STATUS_BY_USER_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-user-who-updated-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_ADDRESS$]", LanguageUtil.get(themeDisplay.getLocale(), "the-email-address-of-the-user-who-added-the-document"));
        definitionTerms.put("[$DOCUMENT_USER_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-user-who-added-the-document"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape(portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get(themeDisplay.getLocale(), "the-site-name-associated-with-the-document"));
        return definitionTerms;
    }

    @Override
    public List<FileEntry> getFileEntries(Hits hits) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        for (Document document : hits.getDocs()) {
            long fileEntryId = GetterUtil.getLong(document.get("entryClassPK"));
            try {
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry(fileEntryId);
                entries.add(fileEntry);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Documents and Media search index is stale and contains file entry " + fileEntryId);
            }
        }
        return entries;
    }

    @Override
    public String getFileEntryImage(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler(5);
        sb.append("<img src=\"");
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/file_system/small/");
        sb.append(fileEntry.getIcon());
        sb.append(".png\" style=\"border-width: 0; text-align: left;\">");
        return sb.toString();
    }

    @Override
    @Deprecated
    public Set<Long> getFileEntryTypeSubscriptionClassPKs(long userId) {
        List<Subscription> subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions(userId, DLFileEntryType.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    @Override
    public String getFileIcon(String extension) {
        if (!_fileIcons.contains(extension)) {
            extension = _DEFAULT_FILE_ICON;
        }
        return extension;
    }

    @Override
    public String getFileIconCssClass(String extension) {
        return "documents-and-media";
    }

    @Override
    public String getGenericName(String extension) {
        String genericName = _genericNames.get(extension);
        if (genericName == null) {
            genericName = _DEFAULT_GENERIC_NAME;
        }
        return genericName;
    }

    @Override
    @Deprecated
    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) {
        return this.getImagePreviewURL(fileEntry, fileVersion, themeDisplay, null, true, true);
    }

    @Override
    @Deprecated
    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String previewQueryString = queryString;
        if (Validator.isNull(previewQueryString)) {
            previewQueryString = "";
        }
        if (ImageProcessorUtil.isSupported(fileVersion.getMimeType())) {
            previewQueryString = previewQueryString.concat("&imagePreview=1");
        } else if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            if (PDFProcessorUtil.hasImages(fileVersion)) {
                previewQueryString = previewQueryString.concat("&previewFileIndex=1");
            } else if (VideoProcessorUtil.hasVideo(fileVersion)) {
                previewQueryString = previewQueryString.concat("&videoThumbnail=1");
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, previewQueryString, appendVersion, absoluteURL);
    }

    @Override
    @Deprecated
    public String getImagePreviewURL(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    @Override
    @Deprecated
    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    @Override
    @Deprecated
    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        StringBundler sb = new StringBundler(15);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        String fileName = fileEntry.getFileName();
        if (fileEntry.isInTrash()) {
            fileName = TrashUtil.getOriginalTitle(fileEntry.getFileName());
        }
        sb.append(URLCodec.encodeURL(HtmlUtil.unescape(fileName)));
        sb.append("/");
        sb.append(URLCodec.encodeURL(fileEntry.getUuid()));
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
            sb.append("&t=");
        } else {
            sb.append("?t=");
        }
        Date modifiedDate = fileVersion.getModifiedDate();
        sb.append(modifiedDate.getTime());
        sb.append(queryString);
        String previewURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId(previewURL, themeDisplay.getSessionId());
        }
        return previewURL;
    }

    @Override
    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType) {
        return this.getRepositoryModelOrderByComparator(orderByCol, orderByType, false);
    }

    @Override
    public <T> OrderByComparator<T> getRepositoryModelOrderByComparator(String orderByCol, String orderByType, boolean orderByModel) {
        boolean orderByAsc = true;
        if (orderByType.equals("desc")) {
            orderByAsc = false;
        }
        OrderByComparator orderByComparator = null;
        orderByComparator = orderByCol.equals("creationDate") ? new RepositoryModelCreateDateComparator(orderByAsc, orderByModel) : (orderByCol.equals("downloads") ? new RepositoryModelReadCountComparator(orderByAsc, orderByModel) : (orderByCol.equals("modifiedDate") ? new RepositoryModelModifiedDateComparator(orderByAsc, orderByModel) : (orderByCol.equals("size") ? new RepositoryModelSizeComparator(orderByAsc, orderByModel) : (orderByCol.equals("title") ? new RepositoryModelTitleComparator(orderByAsc, orderByModel) : new RepositoryModelModifiedDateComparator(orderByAsc, orderByModel)))));
        return orderByComparator;
    }

    @Override
    public String getSanitizedFileName(String title, String extension) {
        String fileName = StringUtil.replace(title, '/', '_');
        if (Validator.isNotNull(extension) && !StringUtil.endsWith(fileName, "." + extension)) {
            fileName = fileName + "." + extension;
        }
        if (fileName.length() > 255) {
            int x = fileName.length() - 1;
            if (Validator.isNotNull(extension)) {
                x = fileName.lastIndexOf(".");
            }
            int y = x - (fileName.length() - 255);
            fileName = fileName.substring(0, y) + fileName.substring(x);
        }
        return fileName;
    }

    @Override
    public String getTempFileId(long id, String version) {
        return this.getTempFileId(id, version, null);
    }

    @Override
    public String getTempFileId(long id, String version, String languageId) {
        if (Validator.isNull(languageId)) {
            return String.valueOf(id).concat(".").concat(version);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(id);
        sb.append(".");
        sb.append(version);
        sb.append(".");
        sb.append(languageId);
        return sb.toString();
    }

    @Override
    @Deprecated
    public String getThumbnailSrc(FileEntry fileEntry, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    @Override
    @Deprecated
    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, DLFileShortcut dlFileShortcut, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileVersion, themeDisplay);
    }

    @Override
    @Deprecated
    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) throws Exception {
        String thumbnailQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages(fileVersion)) {
                thumbnailQueryString = "&imageThumbnail=1";
            } else if (PDFProcessorUtil.hasImages(fileVersion)) {
                thumbnailQueryString = "&documentThumbnail=1";
            } else if (VideoProcessorUtil.hasVideo(fileVersion)) {
                thumbnailQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, thumbnailQueryString);
    }

    @Override
    @Deprecated
    public String getThumbnailSrc(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    @Override
    public String getThumbnailStyle() {
        return this.getThumbnailStyle(true, 0);
    }

    @Override
    public String getThumbnailStyle(boolean max, int margin) {
        return this.getThumbnailStyle(max, margin, PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.height"), PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.width"));
    }

    @Override
    public String getThumbnailStyle(boolean max, int margin, int height, int width) {
        StringBundler sb = new StringBundler(5);
        if (max) {
            sb.append("max-height: ");
        } else {
            sb.append("height: ");
        }
        sb.append(height += 2 * margin);
        if (max) {
            sb.append("px; max-width: ");
        } else {
            sb.append("px; width: ");
        }
        sb.append(width += 2 * margin);
        sb.append("px;");
        return sb.toString();
    }

    @Override
    public String getTitleWithExtension(FileEntry fileEntry) {
        String title = fileEntry.getTitle();
        String extension = fileEntry.getExtension();
        return this.getTitleWithExtension(title, extension);
    }

    @Override
    public String getTitleWithExtension(String title, String extension) {
        String periodAndExtension;
        if (Validator.isNotNull(extension) && !title.endsWith(periodAndExtension = ".".concat(extension))) {
            title = title + periodAndExtension;
        }
        return title;
    }

    @Override
    public String getUniqueFileName(long groupId, long folderId, String fileName) {
        String uniqueFileName = fileName;
        int i = 1;
        while (true) {
            try {
                DLAppLocalServiceUtil.getFileEntry(groupId, folderId, uniqueFileName);
                uniqueFileName = FileUtil.appendParentheticalSuffix(fileName, String.valueOf(i));
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
        return uniqueFileName;
    }

    @Override
    @Deprecated
    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, false);
    }

    @Override
    @Deprecated
    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, manualCheckInRequired, false);
    }

    @Override
    @Deprecated
    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired, boolean openDocumentUrl) throws PortalException {
        StringBundler webDavURLSB = new StringBundler(7);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL(themeDisplay.getServerName(), themeDisplay.getServerPort(), secure);
        webDavURLSB.append(portalURL);
        webDavURLSB.append(themeDisplay.getPathContext());
        webDavURLSB.append("/webdav");
        if (manualCheckInRequired) {
            webDavURLSB.append("/manualCheckInRequired");
        }
        Group group = null;
        group = fileEntry != null ? GroupLocalServiceUtil.getGroup(fileEntry.getGroupId()) : themeDisplay.getScopeGroup();
        webDavURLSB.append(group.getFriendlyURL());
        webDavURLSB.append("/document_library");
        StringBuilder sb = new StringBuilder();
        if (folder != null && folder.getFolderId() != 0L) {
            Folder curFolder = folder;
            while (true) {
                sb.insert(0, URLCodec.encodeURL(curFolder.getName(), true));
                sb.insert(0, "/");
                if (curFolder.getParentFolderId() == 0L) break;
                curFolder = DLAppLocalServiceUtil.getFolder(curFolder.getParentFolderId());
            }
        }
        if (fileEntry != null) {
            sb.append("/");
            sb.append(DLWebDAVUtil.escapeURLTitle(fileEntry.getTitle()));
        }
        webDavURLSB.append(sb.toString());
        return webDavURLSB.toString();
    }

    @Override
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, long folderId, long fileEntryTypeId) throws Exception {
        while (folderId != 0L) {
            DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolder(folderId);
            if (dlFolder == null) {
                return false;
            }
            if (dlFolder.getRestrictionType() != 0) break;
            folderId = dlFolder.getParentFolderId();
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink(companyId, groupId, DLFolderConstants.getClassName(), folderId, fileEntryTypeId) || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink(companyId, groupId, DLFolderConstants.getClassName(), folderId, -1L);
    }

    @Override
    public boolean isAutoGeneratedDLFileEntryTypeDDMStructureKey(String ddmStructureKey) {
        return ddmStructureKey.startsWith(_STRUCTURE_KEY_PREFIX);
    }

    @Override
    public boolean isOfficeExtension(String extension) {
        return ArrayUtil.contains(_MICROSOFT_OFFICE_EXTENSIONS, extension);
    }

    @Override
    @Deprecated
    public boolean isSubscribedToFileEntryType(long companyId, long groupId, long userId, long fileEntryTypeId) {
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        return SubscriptionLocalServiceUtil.isSubscribed(companyId, userId, DLFileEntryType.class.getName(), fileEntryTypeId);
    }

    @Override
    @Deprecated
    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId) throws PortalException {
        return this.isSubscribedToFolder(companyId, groupId, userId, folderId, true);
    }

    @Override
    @Deprecated
    public boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId, boolean recursive) throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        if (folderId != 0L) {
            Folder folder = DLAppLocalServiceUtil.getFolder(folderId);
            ancestorFolderIds.add(folderId);
            if (recursive) {
                ancestorFolderIds.addAll(folder.getAncestorFolderIds());
                ancestorFolderIds.add(groupId);
            }
        } else {
            ancestorFolderIds.add(groupId);
        }
        long[] folderIdsArray = ArrayUtil.toLongArray(ancestorFolderIds);
        return SubscriptionLocalServiceUtil.isSubscribed(companyId, userId, DLFolder.class.getName(), folderIdsArray);
    }

    @Override
    public boolean isValidVersion(String version) {
        if (version.equals("PWC")) {
            return true;
        }
        String[] versionParts = StringUtil.split(version, ".");
        if (versionParts.length != 2) {
            return false;
        }
        return Validator.isNumber(versionParts[0]) && Validator.isNumber(versionParts[1]);
    }

    @Override
    public void startWorkflowInstance(long userId, DLFileVersion dlFileVersion, String syncEventType, ServiceContext serviceContext) throws PortalException {
        HashMap<String, Serializable> workflowContext = new HashMap<String, Serializable>();
        workflowContext.put("url", (Serializable)((Object)this.getEntryURL(dlFileVersion, serviceContext)));
        workflowContext.put("event", (Serializable)((Object)syncEventType));
        WorkflowHandlerRegistryUtil.startWorkflowInstance(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), userId, DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId(), dlFileVersion, serviceContext, workflowContext);
    }

    protected String getEntryURL(DLFileVersion dlFileVersion, ServiceContext serviceContext) throws PortalException {
        if (Objects.equals(serviceContext.getCommand(), "add_webdav") || Objects.equals(serviceContext.getCommand(), "update_webdav")) {
            return serviceContext.getPortalURL() + serviceContext.getCurrentURL();
        }
        String entryURL = GetterUtil.getString(serviceContext.getAttribute("entryURL"));
        if (Validator.isNotNull(entryURL)) {
            return entryURL;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (httpServletRequest == null || themeDisplay == null) {
            return "";
        }
        Object portletURL = null;
        long plid = serviceContext.getPlid();
        long controlPanelPlid = PortalUtil.getControlPanelPlid(serviceContext.getCompanyId());
        String portletId = PortletProviderUtil.getPortletId(FileEntry.class.getName(), PortletProvider.Action.VIEW);
        DLFileEntry fileEntry = dlFileVersion.getFileEntry();
        PortletLayoutFinder portletLayoutFinder = PortletLayoutFinderRegistryUtil.getPortletLayoutFinder(DLFileEntryConstants.getClassName());
        PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, fileEntry.getGroupId());
        if (result != null) {
            portletId = result.getPortletId();
            plid = result.getPlid();
        }
        portletURL = plid == controlPanelPlid || plid == 0L ? PortalUtil.getControlPanelPortletURL(httpServletRequest, portletId, "RENDER_PHASE") : PortletURLFactoryUtil.create(httpServletRequest, portletId, plid, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(dlFileVersion.getFileEntryId()));
        return portletURL.toString();
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String thumbnailSrc = "";
        if (Validator.isNotNull(queryString)) {
            thumbnailSrc = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        }
        return thumbnailSrc;
    }

    private static void _populateGenericNamesMap(String genericName) {
        String[] extensions;
        for (String extension : extensions = PropsUtil.getArray("dl.file.generic.extensions", new Filter(genericName))) {
            _genericNames.put(extension, genericName);
        }
    }

    static {
        String[] genericNames;
        _MICROSOFT_OFFICE_EXTENSIONS = new String[]{"accda", "accdb", "accdc", "accde", "accdp", "accdr", "accdt", "accdu", "acl", "ade", "adp", "asd", "cnv", "crtx", "doc", "docm", "docx", "dot", "dotm", "dotx", "grv", "iaf", "laccdb", "maf", "mam", "maq", "mar", "mat", "mda", "mdb", "mde", "mdt", "mdw", "mpd", "mpp", "mpt", "oab", "obi", "oft", "olm", "one", "onepkg", "ops", "ost", "pa", "pip", "pot", "potm", "potx", "ppa", "ppam", "pps", "ppsm", "ppsx", "ppt", "pptm", "pptx", "prf", "pst", "pub", "puz", "rpmsg", "sldm", "sldx", "slk", "snp", "svd", "thmx", "vdx", "vrge08message", "vsd", "vss", "vst", "vsx", "vtx", "wbk", "wll", "xar", "xl", "xla", "xlam", "xlb", "xlc", "xll", "xlm", "xls", "xlsb", "xlsm", "xlsx", "xlt", "xltm", "xltx", "xlw", "xsf", "xsn"};
        _log = LogFactoryUtil.getLog(DLImpl.class);
        _allMediaGalleryMimeTypes = new TreeSet<String>(){
            {
                this.addAll(SetUtil.fromArray(PropsUtil.getArray("dl.file.entry.preview.audio.mime.types")));
                this.addAll(SetUtil.fromArray(PropsUtil.getArray("dl.file.entry.preview.video.mime.types")));
                this.addAll(SetUtil.fromArray(PropsUtil.getArray("dl.file.entry.preview.image.mime.types")));
            }
        };
        _fileIcons = new HashSet<String>(){
            {
                String[] fileIcons = null;
                try {
                    fileIcons = PropsUtil.getArray("dl.file.icons");
                }
                catch (Exception e) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(e, e);
                    }
                    fileIcons = new String[]{""};
                }
                for (int i = 0; i < fileIcons.length; ++i) {
                    if ("*".equals(fileIcons[i])) continue;
                    String extension = fileIcons[i];
                    if (extension.length() > 0) {
                        extension = extension.substring(1);
                    }
                    this.add(extension);
                }
            }
        };
        _genericNames = new HashMap<String, String>();
        for (String genericName : genericNames = PropsUtil.getArray("dl.file.generic.names")) {
            DLImpl._populateGenericNamesMap(genericName);
        }
    }
}

