/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.FolderIndexer;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
public class DLFolderIndexer
extends BaseIndexer<DLFolder>
implements FolderIndexer {
    public static final String CLASS_NAME = DLFolder.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(DLFolderIndexer.class);
    private static volatile ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission = ServiceProxyFactory.newServiceTrackedInstance(ModelResourcePermission.class, DLFolderIndexer.class, "_dlFolderModelResourcePermission", "(model.class.name=" + DLFolder.class.getName() + ")", true);

    public DLFolderIndexer() {
        this.setDefaultSelectedFieldNames("companyId", "description", "entryClassName", "entryClassPK", "title", "uid");
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String[] getFolderClassNames() {
        return new String[]{CLASS_NAME};
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return _dlFolderModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    @Override
    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
        contextBooleanFilter.addRequiredTerm("hidden", false);
    }

    @Override
    protected void doDelete(DLFolder dlFolder) throws Exception {
        this.deleteDocument(dlFolder.getCompanyId(), dlFolder.getFolderId());
    }

    @Override
    protected Document doGetDocument(DLFolder dlFolder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Indexing folder " + dlFolder);
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, dlFolder);
        document.addText("description", dlFolder.getDescription());
        document.addKeyword("folderId", dlFolder.getParentFolderId());
        document.addKeyword("hidden", dlFolder.isHidden() || dlFolder.isInHiddenFolder());
        String title = dlFolder.getName();
        if (dlFolder.isInTrash()) {
            title = TrashUtil.getOriginalTitle(title);
        }
        document.addText("title", title);
        document.addKeyword("treePath", dlFolder.getTreePath());
        document.addKeyword("treePath", StringUtil.split(dlFolder.getTreePath(), '/'));
        if (_log.isDebugEnabled()) {
            _log.debug("Document " + dlFolder + " indexed successfully");
        }
        return document;
    }

    @Override
    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    @Override
    protected void doReindex(DLFolder dlFolder) throws Exception {
        if (!dlFolder.isApproved() && !dlFolder.isInTrash()) {
            return;
        }
        Document document = this.getDocument(dlFolder);
        IndexWriterHelperUtil.updateDocument(this.getSearchEngineId(), dlFolder.getCompanyId(), document, this.isCommitImmediately());
    }

    @Override
    protected void doReindex(String className, long classPK) throws Exception {
        DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder(classPK);
        this.doReindex(dlFolder);
    }

    @Override
    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong(ids[0]);
        this.reindexFolders(companyId);
    }

    protected void reindexFolders(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = DLFolderLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName("mountPoint");
            dynamicQuery.add(property.eq(false));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(dlFolder -> {
            block2: {
                try {
                    Document document = this.getDocument(dlFolder);
                    indexableActionableDynamicQuery.addDocuments(document);
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn("Unable to index document library folder " + dlFolder.getFolderId(), pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

