/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.portal.kernel.lock.BaseLockListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;

public class DLFileEntryLockListener
extends BaseLockListener {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryLockListener.class);

    @Override
    public String getClassName() {
        return DLFileEntryConstants.getClassName();
    }

    @Override
    public void onAfterExpire(String key) {
        long fileEntryId = GetterUtil.getLong(key);
        try {
            if (PropsValues.DL_FILE_ENTRY_LOCK_POLICY == 1) {
                DLFileEntryServiceUtil.checkInFileEntry(fileEntryId, DLVersionNumberIncrease.fromMajorVersion(true), "Automatic timeout checkin", new ServiceContext());
                if (_log.isDebugEnabled()) {
                    _log.debug("Lock expired and checked in " + fileEntryId);
                }
            } else {
                DLFileEntryServiceUtil.cancelCheckOut(fileEntryId);
                if (_log.isDebugEnabled()) {
                    _log.debug("Lock expired and canceled check out of " + fileEntryId);
                }
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

