/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;

public class DLAppUtil {
    public static String getExtension(String title, String sourceFileName) {
        String extension = FileUtil.getExtension(sourceFileName);
        if (Validator.isNull(extension)) {
            extension = FileUtil.getExtension(title);
        }
        return extension;
    }

    public static String getMimeType(String sourceFileName, String mimeType, String title, File file) {
        if (Validator.isNull(mimeType) || mimeType.equals("application/octet-stream")) {
            String extension = DLAppUtil.getExtension(title, sourceFileName);
            mimeType = MimeTypesUtil.getContentType(file, "A." + extension);
        }
        return mimeType;
    }

    public static String getSourceFileName(FileVersion fileVersion) {
        String extension = fileVersion.getExtension();
        if (Validator.isNull(extension)) {
            return fileVersion.getTitle();
        }
        String suffix = "." + extension;
        String title = fileVersion.getTitle();
        if (title.endsWith(suffix)) {
            return title;
        }
        return title + suffix;
    }

    public static boolean isMajorVersion(FileVersion previousFileVersion, FileVersion currentFileVersion) {
        long previousVersion;
        long currentVersion = GetterUtil.getLong(currentFileVersion.getVersion());
        return currentVersion - (previousVersion = GetterUtil.getLong(previousFileVersion.getVersion())) >= 1L;
    }
}

