/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Atom {
    public static final String CMOV = "cmov";
    public static final String CO64 = "co64";
    public static final String FREE = "free";
    public static final String FTYP = "ftyp";
    public static final String JUNK = "junk";
    public static final String MDAT = "mdat";
    public static final String MOOV = "moov";
    public static final String PICT = "PICT";
    public static final String PNOT = "pnot";
    public static final String SKIP = "skip";
    public static final String STCO = "stco";
    public static final String[] TOP_LEVEL_ATOMS = new String[]{"free", "ftyp", "junk", "mdat", "moov", "PICT", "pnot", "skip", "wide"};
    public static final String WIDE = "wide";
    private static final int _BITMASK = 255;
    private byte[] _buffer;
    private long _offset;
    private long _size;
    private String _type;

    public Atom(RandomAccessFile randomAccessFile) throws IOException {
        this._offset = randomAccessFile.getFilePointer();
        this._size = randomAccessFile.readInt();
        byte[] bytes = new byte[4];
        randomAccessFile.readFully(bytes);
        this._type = new String(bytes);
        if (this._size == 1L) {
            this._size = randomAccessFile.readLong();
        }
        randomAccessFile.seek(this._offset);
    }

    public void fillBuffer(RandomAccessFile randomAccessFile) throws IOException {
        this._buffer = new byte[(int)this._size];
        randomAccessFile.readFully(this._buffer);
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getSize() {
        return this._size;
    }

    public String getType() {
        return this._type;
    }

    public boolean isFTYP() {
        return StringUtil.equalsIgnoreCase(this._type, FTYP);
    }

    public boolean isMDAT() {
        return StringUtil.equalsIgnoreCase(this._type, MDAT);
    }

    public boolean isMOOV() {
        return StringUtil.equalsIgnoreCase(this._type, MOOV);
    }

    public boolean isTopLevelAtom() {
        for (String topLevelAtom : TOP_LEVEL_ATOMS) {
            if (!StringUtil.equalsIgnoreCase(this._type, topLevelAtom)) continue;
            return true;
        }
        return false;
    }

    public void patchAtom() {
        int index = 4;
        while ((long)index < this._size - 4L) {
            String type = new String(ArrayUtil.clone(this._buffer, index, index + 4));
            if (StringUtil.equalsIgnoreCase(type, STCO)) {
                index += this.patchStcoAtom(index) - 4;
            } else if (StringUtil.equalsIgnoreCase(type, CO64)) {
                index += this.patchCo64Atom(index) - 4;
            }
            ++index;
        }
    }

    public void setBuffer(byte[] buffer) {
        this._buffer = buffer;
    }

    public void setOffset(long offset) {
        this._offset = offset;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public void setType(String type) {
        this._type = type;
    }

    protected long bytesToLong(byte[] buffer) {
        long value = 0L;
        for (int i = 0; i < buffer.length; ++i) {
            value += (long)((buffer[i] & 0xFF) << 8 * (buffer.length - i - 1));
        }
        return value;
    }

    protected boolean hasCompressedMoovAtom() {
        String type = new String(ArrayUtil.clone(this._buffer, 12, 15));
        return StringUtil.equalsIgnoreCase(type, CMOV);
    }

    protected int patchCo64Atom(int index) {
        int size = (int)this.bytesToLong(ArrayUtil.clone(this._buffer, index - 4, index));
        int offsetCount = (int)this.bytesToLong(ArrayUtil.clone(this._buffer, index + 8, index + 12));
        for (int i = 0; i < offsetCount; ++i) {
            int offsetIndex = index + 12 + i * 8;
            long offset = this.bytesToLong(ArrayUtil.clone(this._buffer, offsetIndex, offsetIndex + 8));
            this._buffer[offsetIndex + 0] = (byte)((offset += this._size) >> 56 & 0xFFL);
            this._buffer[offsetIndex + 1] = (byte)(offset >> 48 & 0xFFL);
            this._buffer[offsetIndex + 2] = (byte)(offset >> 40 & 0xFFL);
            this._buffer[offsetIndex + 3] = (byte)(offset >> 32 & 0xFFL);
            this._buffer[offsetIndex + 4] = (byte)(offset >> 24 & 0xFFL);
            this._buffer[offsetIndex + 5] = (byte)(offset >> 16 & 0xFFL);
            this._buffer[offsetIndex + 6] = (byte)(offset >> 8 & 0xFFL);
            this._buffer[offsetIndex + 7] = (byte)(offset >> 0 & 0xFFL);
        }
        return size;
    }

    protected int patchStcoAtom(int index) {
        int size = (int)this.bytesToLong(ArrayUtil.clone(this._buffer, index - 4, index));
        int offsetCount = (int)this.bytesToLong(ArrayUtil.clone(this._buffer, index + 8, index + 12));
        for (int i = 0; i < offsetCount; ++i) {
            int offsetIndex = index + 12 + i * 4;
            int offset = (int)this.bytesToLong(ArrayUtil.clone(this._buffer, offsetIndex, offsetIndex + 4));
            offset = (int)((long)offset + this._size);
            this._buffer[offsetIndex + 0] = (byte)(offset >> 24 & 0xFF);
            this._buffer[offsetIndex + 1] = (byte)(offset >> 16 & 0xFF);
            this._buffer[offsetIndex + 2] = (byte)(offset >> 8 & 0xFF);
            this._buffer[offsetIndex + 3] = (byte)(offset >> 0 & 0xFF);
        }
        return size;
    }
}

