/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store.test;

import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.BaseStore;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.test.rule.ExpectedLog;
import com.liferay.portal.test.rule.ExpectedLogs;
import com.liferay.portal.test.rule.ExpectedType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseStoreTestCase {
    protected long companyId;
    protected long repositoryId;
    protected Store store;
    private static final int _DATA_SIZE = 66560;
    private static final byte[] _DATA_VERSION_1 = new byte[66560];
    private static final byte[] _DATA_VERSION_2 = new byte[66560];

    @Before
    public void setUp() throws Exception {
        this.store = this.getStore();
        this.companyId = RandomTestUtil.nextLong();
        this.repositoryId = RandomTestUtil.nextLong();
    }

    @After
    public void tearDown() throws Exception {
        this.store.deleteDirectory(this.companyId, this.repositoryId, "/");
    }

    @Test
    public void testAddFileWithBufferedInputStream() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, new BufferedInputStream(new ByteArrayInputStream(_DATA_VERSION_1)));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
    }

    @Test
    public void testAddFileWithByteArray() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
    }

    @Test
    public void testAddFileWithByteArrayInputStream() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, new ByteArrayInputStream(_DATA_VERSION_1));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
    }

    @Test
    public void testAddFileWithFile() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        File file = this.createFile(_DATA_VERSION_1);
        this.store.addFile(this.companyId, this.repositoryId, fileName, file);
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
    }

    @Test
    public void testAddFileWithFileInputStream() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        File file = this.createFile(_DATA_VERSION_1);
        this.store.addFile(this.companyId, this.repositoryId, fileName, new FileInputStream(file));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
    }

    @Test
    public void testAddFileWithUnsyncByteArrayInputStream() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
    }

    @Test
    public void testCopyFileVersion() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 1);
        this.store.copyFileVersion(this.companyId, this.repositoryId, fileName, "1.0", "1.2");
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.2"));
        Assert.assertArrayEquals(_DATA_VERSION_1, this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.2"));
    }

    @Test(expected=DuplicateFileException.class)
    public void testCopyFileVersionDuplicateFileException() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 1);
        this.store.copyFileVersion(this.companyId, this.repositoryId, fileName, "1.0", "1.1");
    }

    @Test(expected=NoSuchFileException.class)
    public void testCopyFileVersionNoSuchFileException() throws Exception {
        this.store.copyFileVersion(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]), "1.0", "1.1");
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        String dirName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName1, _DATA_VERSION_1);
        String fileName2 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName2, _DATA_VERSION_1);
        this.store.deleteDirectory(this.companyId, this.repositoryId, dirName);
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName1, "1.0"));
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName2, "1.0"));
    }

    @Test
    public void testDeleteDirectoryWithTwoLevelDeep() throws Exception {
        String dirName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String subdirName = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName1, _DATA_VERSION_1);
        String fileName2 = subdirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName2, _DATA_VERSION_1);
        this.store.deleteDirectory(this.companyId, this.repositoryId, dirName);
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName1, "1.0"));
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName2, "1.0"));
    }

    @Test
    public void testDeleteFile() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 1);
        this.store.deleteFile(this.companyId, this.repositoryId, fileName);
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.1"));
    }

    @Test
    public void testDeleteFileWithVersion() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 1);
        this.store.deleteFile(this.companyId, this.repositoryId, fileName, "1.0");
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.0"));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, "1.1"));
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetFileAsBytesNoSuchFileException() throws Exception {
        this.store.getFileAsBytes(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    @Test
    public void testGetFileAsStream() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 1);
        try (InputStream inputStream = this.store.getFileAsStream(this.companyId, this.repositoryId, fileName);){
            for (int i = 0; i < 66560; ++i) {
                Assert.assertEquals(_DATA_VERSION_1[i], (byte)inputStream.read());
            }
            Assert.assertEquals(-1L, inputStream.read());
        }
    }

    @Test
    public void testGetFileAsStreamWithVersion() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 5);
        try (InputStream inputStream = this.store.getFileAsStream(this.companyId, this.repositoryId, fileName, "1.5");){
            for (int i = 0; i < 66560; ++i) {
                Assert.assertEquals(_DATA_VERSION_1[i], (byte)inputStream.read());
            }
            Assert.assertEquals(-1L, inputStream.read());
        }
    }

    @Test
    public void testGetFileNames() throws Exception {
        String fileName1 = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName1, _DATA_VERSION_1);
        String fileName2 = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName2, _DATA_VERSION_1);
        Object[] fileNames = this.store.getFileNames(this.companyId, this.repositoryId);
        Assert.assertEquals(Arrays.toString(fileNames), 2L, fileNames.length);
        Set<Object> fileNamesSet = SetUtil.fromArray(fileNames);
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName1));
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName2));
    }

    @Test
    public void testGetFileNamesWithDirectoryOneLevelDeep() throws Exception {
        String dirName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName1, _DATA_VERSION_1);
        String fileName2 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName2, _DATA_VERSION_1);
        Object[] fileNames = this.store.getFileNames(this.companyId, this.repositoryId, dirName);
        Assert.assertEquals(Arrays.toString(fileNames), 2L, fileNames.length);
        Set<Object> fileNamesSet = SetUtil.fromArray(fileNames);
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName1));
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName2));
    }

    @Test
    public void testGetFileNamesWithDirectoryTwoLevelDeep() throws Exception {
        String dirName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String subdirName = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName1, _DATA_VERSION_1);
        String fileName2 = subdirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName2, _DATA_VERSION_1);
        String fileName3 = RandomTestUtil.randomString(new RandomizerBumper[0]) + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName3, _DATA_VERSION_1);
        Object[] fileNames = this.store.getFileNames(this.companyId, this.repositoryId, dirName);
        Assert.assertEquals(Arrays.toString(fileNames), 2L, fileNames.length);
        Set<Object> fileNamesSet = SetUtil.fromArray(fileNames);
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName1));
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName2));
        fileNames = this.store.getFileNames(this.companyId, this.repositoryId, subdirName);
        Assert.assertEquals(Arrays.toString(fileNames), 1L, fileNames.length);
        Assert.assertEquals(fileName2, fileNames[0]);
    }

    @Test
    public void testGetFileNamesWithInvalidDirectory() {
        String dirName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        Object[] fileNames = this.store.getFileNames(this.companyId, this.repositoryId, dirName);
        Assert.assertEquals(Arrays.toString(fileNames), 0L, fileNames.length);
    }

    @Test
    public void testGetFileNamesWithInvalidRepository() throws Exception {
        Object[] fileNames = this.store.getFileNames(this.companyId, this.repositoryId);
        Assert.assertEquals(Arrays.toString(fileNames), 0L, fileNames.length);
    }

    @Test
    public void testGetFileNamesWithTwoLevelsDeep() throws Exception {
        String dirName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        String subdirName = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName1, _DATA_VERSION_1);
        String fileName2 = subdirName + "/" + RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName2, _DATA_VERSION_1);
        Object[] fileNames = this.store.getFileNames(this.companyId, this.repositoryId);
        Assert.assertEquals(Arrays.toString(fileNames), 2L, fileNames.length);
        Set<Object> fileNamesSet = SetUtil.fromArray(fileNames);
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName1));
        Assert.assertTrue(fileNamesSet.toString(), fileNamesSet.contains(fileName2));
    }

    @Test
    public void testGetFileSize() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        long size = this.store.getFileSize(this.companyId, this.repositoryId, fileName);
        Assert.assertEquals(66560L, size);
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetFileSizeNoSuchFileException() throws Exception {
        this.store.getFileSize(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetFileVersionAsBytesNoSuchFileException() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.1");
    }

    @Test
    public void testHasFile() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName));
    }

    @Test
    public void testHasFileWithVersion() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 5);
        String versionLabel = "1.";
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, fileName, versionLabel + i));
        }
    }

    @ExpectedLogs(expectedLogs={@ExpectedLog(expectedLog="Unable to delete file {companyId=", expectedType=ExpectedType.PREFIX)}, level="WARN", loggerClass=BaseStore.class)
    @Test
    public void testLogFailedDeletion() {
        this.store.deleteFile(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    @ExpectedLogs(expectedLogs={@ExpectedLog(expectedLog="Unable to delete file {companyId=", expectedType=ExpectedType.PREFIX)}, level="WARN", loggerClass=BaseStore.class)
    @Test
    public void testLogFailedDeletionWithVersionLabel() {
        this.store.deleteFile(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]), "1.0");
    }

    @Test
    public void testUpdateFileVersion() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.updateFileVersion(this.companyId, this.repositoryId, fileName, "1.0", "1.1");
        Assert.assertArrayEquals(_DATA_VERSION_1, this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.1"));
    }

    @Test(expected=DuplicateFileException.class)
    public void testUpdateFileVersionDuplicateFileException() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.updateFileVersion(this.companyId, this.repositoryId, fileName, "1.0", "1.0");
    }

    @Test(expected=NoSuchFileException.class)
    public void testUpdateFileVersionNoSuchFileException() throws Exception {
        this.store.updateFileVersion(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]), "1.0", "1.0");
    }

    @Test
    public void testUpdateFileVersionWithNewFileName() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.addVersions(fileName, 2);
        String newFileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.updateFile(this.companyId, this.repositoryId, fileName, newFileName);
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, newFileName));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, newFileName, "1.0"));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, newFileName, "1.1"));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, newFileName, "1.2"));
    }

    @Test
    public void testUpdateFileWithByteArray() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.updateFile(this.companyId, this.repositoryId, fileName, "1.1", _DATA_VERSION_2);
        byte[] firstVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.0");
        Assert.assertArrayEquals(_DATA_VERSION_1, firstVersionBytes);
        byte[] secondVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.1");
        Assert.assertArrayEquals(_DATA_VERSION_2, secondVersionBytes);
        byte[] currentVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName);
        Assert.assertArrayEquals(_DATA_VERSION_2, currentVersionBytes);
    }

    @Test
    public void testUpdateFileWithFile() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        File file = this.createFile(_DATA_VERSION_2);
        this.store.updateFile(this.companyId, this.repositoryId, fileName, "1.1", file);
        byte[] firstVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.0");
        Assert.assertArrayEquals(_DATA_VERSION_1, firstVersionBytes);
        byte[] secondVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.1");
        Assert.assertArrayEquals(_DATA_VERSION_2, secondVersionBytes);
        byte[] currentVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName);
        Assert.assertArrayEquals(_DATA_VERSION_2, currentVersionBytes);
    }

    @Test
    public void testUpdateFileWithInputStream() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.updateFile(this.companyId, this.repositoryId, fileName, "1.1", new ByteArrayInputStream(_DATA_VERSION_2));
        byte[] firstVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.0");
        Assert.assertArrayEquals(_DATA_VERSION_1, firstVersionBytes);
        byte[] secondVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName, "1.1");
        Assert.assertArrayEquals(_DATA_VERSION_2, secondVersionBytes);
        byte[] currentVersionBytes = this.store.getFileAsBytes(this.companyId, this.repositoryId, fileName);
        Assert.assertArrayEquals(_DATA_VERSION_2, currentVersionBytes);
    }

    @Test
    public void testUpdateFileWithNewFileName() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        String newFileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.updateFile(this.companyId, this.repositoryId, fileName, newFileName);
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName));
        Assert.assertTrue(this.store.hasFile(this.companyId, this.repositoryId, newFileName));
    }

    @Test(expected=DuplicateFileException.class)
    public void testUpdateFileWithNewFileNameDuplicateFileException() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.updateFile(this.companyId, this.repositoryId, fileName, fileName);
    }

    @Test(expected=NoSuchFileException.class)
    public void testUpdateFileWithNewFileNameNoSuchFileException() throws Exception {
        this.store.updateFile(this.companyId, this.repositoryId, RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    @Test
    public void testUpdateFileWithNewRepositoryId() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        long newRepositoryId = RandomTestUtil.nextLong();
        this.store.updateFile(this.companyId, this.repositoryId, newRepositoryId, fileName);
        Assert.assertFalse(this.store.hasFile(this.companyId, this.repositoryId, fileName));
        Assert.assertTrue(this.store.hasFile(this.companyId, newRepositoryId, fileName));
        this.store.deleteDirectory(this.companyId, newRepositoryId, "/");
    }

    @Test(expected=DuplicateFileException.class)
    public void testUpdateFileWithNewRepositoryIdDuplicateFileException() throws Exception {
        String fileName = RandomTestUtil.randomString(new RandomizerBumper[0]);
        this.store.addFile(this.companyId, this.repositoryId, fileName, _DATA_VERSION_1);
        this.store.updateFile(this.companyId, this.repositoryId, this.repositoryId, fileName);
    }

    @Test(expected=NoSuchFileException.class)
    public void testUpdateFileWithNewRepositoryIdNoSuchFileException() throws Exception {
        this.store.updateFile(this.companyId, this.repositoryId, RandomTestUtil.nextLong(), RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    protected void addVersions(String fileName, int newVersionCount) throws Exception {
        String versionLabel = "1.";
        for (int i = 1; i <= newVersionCount; ++i) {
            this.store.updateFile(this.companyId, this.repositoryId, fileName, versionLabel + i, _DATA_VERSION_1);
        }
    }

    protected File createFile(byte[] fileData) throws IOException {
        File file = File.createTempFile("DBStoreTest-testFile", null);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ((OutputStream)outputStream).write(fileData);
        }
        return file;
    }

    protected abstract Store getStore();

    static {
        for (int i = 0; i < 66560; ++i) {
            BaseStoreTestCase._DATA_VERSION_1[i] = (byte)i;
            BaseStoreTestCase._DATA_VERSION_2[i] = (byte)(i + 1);
        }
    }
}

