/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Map;
import java.util.Set;

public class StoreFactory {
    private static final Log _log = LogFactoryUtil.getLog(StoreFactory.class);
    private static StoreFactory _storeFactory;
    private static boolean _warned;
    private volatile Store _store;
    private final ServiceTrackerMap<String, StoreServiceRegistrationHolder> _storeServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(Store.class, "store.type", new StoreServiceTrackerCustomizer());
    private String _storeType;

    public static StoreFactory getInstance() {
        if (_storeFactory == null) {
            _storeFactory = new StoreFactory();
        }
        return _storeFactory;
    }

    public void checkProperties() {
        if (_warned) {
            return;
        }
        String dlHookImpl = PropsUtil.get("dl.hook.impl");
        if (Validator.isNull(dlHookImpl)) {
            _warned = true;
            return;
        }
        boolean found = false;
        for (String key : this._storeServiceTrackerMap.keySet()) {
            Store store = this.getStore(key);
            Class<?> clazz = store.getClass();
            String className = clazz.getName();
            if (!dlHookImpl.equals(className)) continue;
            PropsValues.DL_STORE_IMPL = className;
            found = true;
            break;
        }
        if (!found) {
            PropsValues.DL_STORE_IMPL = dlHookImpl;
        }
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(11);
            sb.append("Liferay is configured with the legacy property ");
            sb.append("\"dl.hook.impl=");
            sb.append(dlHookImpl);
            sb.append("\" in portal-ext.properties. Please reconfigure to ");
            sb.append("use the new property \"");
            sb.append("dl.store.impl");
            sb.append("\". Liferay will attempt to temporarily set \"");
            sb.append("dl.store.impl");
            sb.append("=");
            sb.append(PropsValues.DL_STORE_IMPL);
            sb.append("\".");
            _log.warn(sb.toString());
        }
        _warned = true;
    }

    public void destroy() {
        this._storeServiceTrackerMap.close();
    }

    public Store getStore() {
        if (this._store == null) {
            if (Validator.isNull(this._storeType)) {
                this.setStore(PropsValues.DL_STORE_IMPL);
            } else {
                this.setStore(this._storeType);
            }
        }
        if (this._store == null) {
            throw new IllegalStateException("Store is not available");
        }
        return this._store;
    }

    public Store getStore(String key) {
        StoreServiceRegistrationHolder storeServiceRegistrationHolder = this._storeServiceTrackerMap.getService(key);
        if (storeServiceRegistrationHolder == null) {
            return null;
        }
        return storeServiceRegistrationHolder._store;
    }

    public String[] getStoreTypes() {
        Set<String> storeTypes = this._storeServiceTrackerMap.keySet();
        return storeTypes.toArray(new String[0]);
    }

    public void setStore(String key) {
        if (key == null) {
            this._store = null;
            this._storeType = null;
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Set " + key);
        }
        this._store = this.getStore(key);
        this._storeType = key;
    }

    private class StoreServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Store, StoreServiceRegistrationHolder> {
        private StoreServiceTrackerCustomizer() {
        }

        @Override
        public StoreServiceRegistrationHolder addingService(ServiceReference<Store> serviceReference) {
            if (GetterUtil.getBoolean(serviceReference.getProperty("current.store"))) {
                return null;
            }
            String storeType = (String)serviceReference.getProperty("store.type");
            Registry registry = RegistryUtil.getRegistry();
            Store store = registry.getService(serviceReference);
            ServiceRegistration<Store> serviceRegistration = null;
            if (PropsValues.DL_STORE_IMPL.equals(storeType)) {
                Map<String, Object> properties = serviceReference.getProperties();
                properties.put("current.store", "true");
                serviceRegistration = registry.registerService(Store.class, store, properties);
            }
            this.cleanUp(serviceReference);
            return new StoreServiceRegistrationHolder(store, serviceRegistration);
        }

        @Override
        public void modifiedService(ServiceReference<Store> serviceReference, StoreServiceRegistrationHolder storeServiceRegistrationHolder) {
        }

        @Override
        public void removedService(ServiceReference<Store> serviceReference, StoreServiceRegistrationHolder storeServiceRegistrationHolder) {
            ServiceRegistration serviceRegistration = storeServiceRegistrationHolder._serviceRegistration;
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            this.cleanUp(serviceReference);
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }

        protected void cleanUp(ServiceReference<Store> serviceReference) {
            String storeType = (String)serviceReference.getProperty("store.type");
            if (Validator.isNotNull(StoreFactory.this._storeType) && StoreFactory.this._storeType.equals(storeType)) {
                StoreFactory.this._store = null;
            }
        }
    }

    private static class StoreServiceRegistrationHolder {
        private final ServiceRegistration<Store> _serviceRegistration;
        private final Store _store;

        private StoreServiceRegistrationHolder(Store store, ServiceRegistration<Store> serviceRegistration) {
            this._store = store;
            this._serviceRegistration = serviceRegistration;
        }
    }
}

