/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.sharepoint;

import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.sharepoint.BaseSharepointStorageImpl;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.Tree;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DLSharepointStorageImpl
extends BaseSharepointStorageImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLSharepointStorageImpl.class);

    @Override
    public void addDocumentElements(SharepointRequest sharepointRequest, Element element) throws Exception {
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        if (parentFolderId == 0L) {
            return;
        }
        List<FileEntry> fileEntries = DLAppServiceUtil.getFileEntries(groupId, parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            String documentPath = parentFolderPath.concat("/").concat(fileEntry.getTitle());
            this.addDocumentElement(element, documentPath, fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getUserName());
        }
    }

    @Override
    public void createFolder(SharepointRequest sharepointRequest) throws Exception {
        String folderPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(folderPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String folderName = this.getResourceName(folderPath);
        String description = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        DLAppServiceUtil.addFolder(groupId, parentFolderId, folderName, description, serviceContext);
    }

    @Override
    public InputStream getDocumentInputStream(SharepointRequest sharepointRequest) throws Exception {
        FileEntry fileEntry = this.getFileEntry(sharepointRequest);
        return fileEntry.getContentStream();
    }

    @Override
    public Tree getDocumentsTree(SharepointRequest sharepointRequest) throws Exception {
        Tree documentsTree = new Tree();
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        List<FileEntry> fileEntries = DLAppServiceUtil.getFileEntries(groupId, parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            documentsTree.addChild(this.getFileEntryTree(fileEntry, parentFolderPath));
        }
        return documentsTree;
    }

    @Override
    public Tree getDocumentTree(SharepointRequest sharepointRequest) throws Exception {
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        FileEntry fileEntry = this.getFileEntry(sharepointRequest);
        return this.getFileEntryTree(fileEntry, parentFolderPath);
    }

    @Override
    public Tree getFoldersTree(SharepointRequest sharepointRequest) throws Exception {
        Tree foldersTree = new Tree();
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        List<Folder> folders = DLAppServiceUtil.getFolders(groupId, parentFolderId, false);
        for (Folder folder : folders) {
            foldersTree.addChild(this.getFolderTree(folder, parentFolderPath));
        }
        foldersTree.addChild(this.getFolderTree(parentFolderPath));
        return foldersTree;
    }

    @Override
    public Tree getFolderTree(SharepointRequest sharepointRequest) throws Exception {
        String folderPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(folderPath);
        long groupId = SharepointUtil.getGroupId(folderPath);
        long folderId = this.getLastFolderId(groupId, folderPath, 0L);
        Folder folder = DLAppServiceUtil.getFolder(folderId);
        return this.getFolderTree(folder, parentFolderPath);
    }

    @Override
    public void getParentFolderIds(long groupId, String path, List<Long> folderIds) throws Exception {
        String[] pathArray = SharepointUtil.getPathArray(path);
        if (pathArray.length == 0) {
            return;
        }
        long parentFolderId = folderIds.get(folderIds.size() - 1);
        Folder folder = DLAppServiceUtil.getFolder(groupId, parentFolderId, HttpUtil.decodePath(pathArray[0]));
        folderIds.add(folder.getFolderId());
        if (pathArray.length > 1) {
            path = this.removeFoldersFromPath(path, 1);
            this.getParentFolderIds(groupId, path, folderIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree[] moveDocument(SharepointRequest sharepointRequest) throws Exception {
        Tree movedDirsTree;
        Tree movedDocsTree;
        block12: {
            ServiceContext serviceContext;
            String newName;
            long newParentFolderId;
            String newParentFolderPath;
            Folder folder;
            block11: {
                FileEntry fileEntry;
                block10: {
                    String parentFolderPath = sharepointRequest.getRootPath();
                    long groupId = SharepointUtil.getGroupId(parentFolderPath);
                    folder = null;
                    fileEntry = null;
                    try {
                        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
                        folder = DLAppServiceUtil.getFolder(parentFolderId);
                    }
                    catch (Exception e1) {
                        if (!(e1 instanceof NoSuchFolderException)) break block10;
                        try {
                            fileEntry = this.getFileEntry(sharepointRequest);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                movedDocsTree = new Tree();
                movedDirsTree = new Tree();
                String newPath = sharepointRequest.getParameterValue("newUrl");
                newParentFolderPath = this.getParentFolderPath(newPath);
                long newGroupId = SharepointUtil.getGroupId(newParentFolderPath);
                newParentFolderId = this.getLastFolderId(newGroupId, newParentFolderPath, 0L);
                newName = this.getResourceName(newPath);
                serviceContext = new ServiceContext();
                if (fileEntry == null) break block11;
                File file = null;
                try {
                    long fileEntryId = fileEntry.getFileEntryId();
                    long folderId = fileEntry.getFolderId();
                    String mimeType = fileEntry.getMimeType();
                    String description = fileEntry.getDescription();
                    String changeLog = "";
                    InputStream is = fileEntry.getContentStream();
                    file = FileUtil.createTempFile(is);
                    String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
                    serviceContext.setAssetTagNames(assetTagNames);
                    fileEntry = DLAppServiceUtil.updateFileEntry(fileEntryId, newName, mimeType, newName, description, changeLog, false, file, serviceContext);
                    if (folderId != newParentFolderId) {
                        fileEntry = DLAppServiceUtil.moveFileEntry(fileEntryId, newParentFolderId, serviceContext);
                    }
                    Tree documentTree = this.getFileEntryTree(fileEntry, newParentFolderPath);
                    movedDocsTree.addChild(documentTree);
                }
                catch (Throwable throwable) {
                    FileUtil.delete(file);
                    throw throwable;
                }
                FileUtil.delete(file);
                break block12;
            }
            if (folder != null) {
                long folderId = folder.getFolderId();
                String description = folder.getDescription();
                if (newParentFolderId != folder.getParentFolderId()) {
                    folder = DLAppServiceUtil.moveFolder(folderId, newParentFolderId, serviceContext);
                }
                if (!newName.equals(folder.getName())) {
                    DLAppServiceUtil.updateFolder(folderId, newName, description, serviceContext);
                }
                Tree folderTree = this.getFolderTree(folder, newParentFolderPath);
                movedDirsTree.addChild(folderTree);
            }
        }
        return new Tree[]{movedDocsTree, movedDirsTree};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putDocument(SharepointRequest sharepointRequest) throws Exception {
        HttpServletRequest httpServletRequest = sharepointRequest.getHttpServletRequest();
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String title = this.getResourceName(documentPath);
        String description = "";
        String changeLog = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        String contentType = GetterUtil.get(httpServletRequest.getHeader("Content-Type"), "application/octet-stream");
        String extension = FileUtil.getExtension(title);
        File file = null;
        try {
            file = FileUtil.createTempFile(extension);
            FileUtil.write(file, sharepointRequest.getBytes());
            if (contentType.equals("application/octet-stream")) {
                contentType = MimeTypesUtil.getContentType(file, title);
            }
            try {
                FileEntry fileEntry = this.getFileEntry(sharepointRequest);
                long fileEntryId = fileEntry.getFileEntryId();
                description = fileEntry.getDescription();
                String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId());
                serviceContext.setAssetTagNames(assetTagNames);
                DLAppServiceUtil.updateFileEntry(fileEntryId, title, contentType, title, description, changeLog, false, file, serviceContext);
            }
            catch (NoSuchFileEntryException nsfee) {
                if (_log.isDebugEnabled()) {
                    _log.debug(nsfee, nsfee);
                }
                DLAppServiceUtil.addFileEntry(groupId, parentFolderId, title, contentType, title, description, changeLog, file, serviceContext);
            }
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public Tree[] removeDocument(SharepointRequest sharepointRequest) {
        FileEntry fileEntry;
        Folder folder;
        String parentFolderPath;
        block15: {
            parentFolderPath = sharepointRequest.getRootPath();
            long groupId = SharepointUtil.getGroupId(parentFolderPath);
            folder = null;
            fileEntry = null;
            try {
                long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
                folder = DLAppServiceUtil.getFolder(parentFolderId);
            }
            catch (Exception e1) {
                if (!(e1 instanceof NoSuchFolderException)) break block15;
                try {
                    fileEntry = this.getFileEntry(sharepointRequest);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Tree documentTree = new Tree();
        Tree removedDocsTree = new Tree();
        Tree failedDocsTree = new Tree();
        Tree folderTree = new Tree();
        Tree removedDirsTree = new Tree();
        Tree failedDirsTree = new Tree();
        if (fileEntry != null) {
            try {
                documentTree = this.getFileEntryTree(fileEntry, parentFolderPath);
                DLAppServiceUtil.deleteFileEntry(fileEntry.getFileEntryId());
                removedDocsTree.addChild(documentTree);
            }
            catch (Exception e1) {
                try {
                    failedDocsTree.addChild(documentTree);
                }
                catch (Exception exception) {}
            }
        } else if (folder != null) {
            try {
                folderTree = this.getFolderTree(folder, parentFolderPath);
                DLAppServiceUtil.deleteFolder(folder.getFolderId());
                removedDirsTree.addChild(folderTree);
            }
            catch (Exception e1) {
                try {
                    failedDirsTree.addChild(folderTree);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new Tree[]{removedDocsTree, removedDirsTree, failedDocsTree, failedDirsTree};
    }

    protected FileEntry getFileEntry(SharepointRequest sharepointRequest) throws Exception {
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String title = this.getResourceName(documentPath);
        return DLAppServiceUtil.getFileEntry(groupId, parentFolderId, title);
    }

    protected Tree getFileEntryTree(FileEntry fileEntry, String parentFolderPath) {
        String documentPath = parentFolderPath.concat("/").concat(fileEntry.getTitle());
        return this.getDocumentTree(documentPath, fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize(), fileEntry.getUserName(), fileEntry.getVersion());
    }

    protected Tree getFolderTree(Folder folder, String parentFolderPath) {
        String folderPath = parentFolderPath.concat("/").concat(folder.getName());
        return this.getFolderTree(folderPath, folder.getCreateDate(), folder.getModifiedDate(), folder.getLastPostDate());
    }
}

