/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.test;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.RoleTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.test.rule.PermissionCheckerMethodTestRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;

public abstract class BaseDLAppTestCase {
    public static final String CONTENT = "Content: Enterprise. Open Source. For Life.";
    @ClassRule
    @Rule
    public static final PermissionCheckerMethodTestRule permissionCheckerTestRule = PermissionCheckerMethodTestRule.INSTANCE;
    @DeleteAfterTestRun
    protected Group group;
    protected Folder parentFolder;
    @DeleteAfterTestRun
    protected Group targetGroup;
    private static final Log _log = LogFactoryUtil.getLog(BaseDLAppTestCase.class);
    private String _name;

    @Before
    public void setUp() throws Exception {
        block2: {
            this._name = PrincipalThreadLocal.getName();
            this.group = GroupTestUtil.addGroup();
            this.targetGroup = GroupTestUtil.addGroup();
            try {
                DLAppServiceUtil.deleteFolder(this.group.getGroupId(), 0L, "Test Folder");
            }
            catch (NoSuchFolderException nsfe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(nsfe, nsfe);
            }
        }
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(this.group.getGroupId(), TestPropsValues.getUserId());
        this.parentFolder = DLAppServiceUtil.addFolder(this.group.getGroupId(), 0L, "Test Folder", RandomTestUtil.randomString(new RandomizerBumper[0]), serviceContext);
        RoleTestUtil.addResourcePermission("Guest", "com.liferay.document.library", 2, String.valueOf(this.group.getGroupId()), "VIEW");
    }

    @After
    public void tearDown() throws Exception {
        PrincipalThreadLocal.setName(this._name);
        RoleTestUtil.removeResourcePermission("Guest", "com.liferay.document.library", 2, String.valueOf(this.group.getGroupId()), "VIEW");
    }
}

