/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.persistence.DLFileVersionPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLFileVersionPersistenceImpl
extends BasePersistenceImpl<DLFileVersion>
implements DLFileVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DLFileVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "dlFileVersion.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "dlFileVersion.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "dlFileVersion.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "dlFileVersion.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "dlFileVersion.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "dlFileVersion.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByFileEntryId;
    private FinderPath _finderPathWithoutPaginationFindByFileEntryId;
    private FinderPath _finderPathCountByFileEntryId;
    private static final String _FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2 = "dlFileVersion.fileEntryId = ?";
    private FinderPath _finderPathWithPaginationFindByMimeType;
    private FinderPath _finderPathWithoutPaginationFindByMimeType;
    private FinderPath _finderPathCountByMimeType;
    private static final String _FINDER_COLUMN_MIMETYPE_MIMETYPE_2 = "dlFileVersion.mimeType = ?";
    private static final String _FINDER_COLUMN_MIMETYPE_MIMETYPE_3 = "(dlFileVersion.mimeType IS NULL OR dlFileVersion.mimeType = '')";
    private FinderPath _finderPathWithPaginationFindByC_NotS;
    private FinderPath _finderPathWithPaginationCountByC_NotS;
    private static final String _FINDER_COLUMN_C_NOTS_COMPANYID_2 = "dlFileVersion.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_NOTS_STATUS_2 = "dlFileVersion.status != ?";
    private FinderPath _finderPathFetchByF_V;
    private FinderPath _finderPathCountByF_V;
    private static final String _FINDER_COLUMN_F_V_FILEENTRYID_2 = "dlFileVersion.fileEntryId = ? AND ";
    private static final String _FINDER_COLUMN_F_V_VERSION_2 = "dlFileVersion.version = ?";
    private static final String _FINDER_COLUMN_F_V_VERSION_3 = "(dlFileVersion.version IS NULL OR dlFileVersion.version = '')";
    private FinderPath _finderPathWithPaginationFindByF_S;
    private FinderPath _finderPathWithoutPaginationFindByF_S;
    private FinderPath _finderPathCountByF_S;
    private static final String _FINDER_COLUMN_F_S_FILEENTRYID_2 = "dlFileVersion.fileEntryId = ? AND ";
    private static final String _FINDER_COLUMN_F_S_STATUS_2 = "dlFileVersion.status = ?";
    private FinderPath _finderPathWithPaginationFindByG_F_S;
    private FinderPath _finderPathWithoutPaginationFindByG_F_S;
    private FinderPath _finderPathCountByG_F_S;
    private static final String _FINDER_COLUMN_G_F_S_GROUPID_2 = "dlFileVersion.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_S_FOLDERID_2 = "dlFileVersion.folderId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_S_STATUS_2 = "dlFileVersion.status = ?";
    private FinderPath _finderPathWithPaginationFindByG_F_T_V;
    private FinderPath _finderPathWithoutPaginationFindByG_F_T_V;
    private FinderPath _finderPathCountByG_F_T_V;
    private static final String _FINDER_COLUMN_G_F_T_V_GROUPID_2 = "dlFileVersion.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_T_V_FOLDERID_2 = "dlFileVersion.folderId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_T_V_TITLE_2 = "dlFileVersion.title = ? AND ";
    private static final String _FINDER_COLUMN_G_F_T_V_TITLE_3 = "(dlFileVersion.title IS NULL OR dlFileVersion.title = '') AND ";
    private static final String _FINDER_COLUMN_G_F_T_V_VERSION_2 = "dlFileVersion.version = ?";
    private static final String _FINDER_COLUMN_G_F_T_V_VERSION_3 = "(dlFileVersion.version IS NULL OR dlFileVersion.version = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_DLFILEVERSION = "SELECT dlFileVersion FROM DLFileVersion dlFileVersion";
    private static final String _SQL_SELECT_DLFILEVERSION_WHERE = "SELECT dlFileVersion FROM DLFileVersion dlFileVersion WHERE ";
    private static final String _SQL_COUNT_DLFILEVERSION = "SELECT COUNT(dlFileVersion) FROM DLFileVersion dlFileVersion";
    private static final String _SQL_COUNT_DLFILEVERSION_WHERE = "SELECT COUNT(dlFileVersion) FROM DLFileVersion dlFileVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "dlFileVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DLFileVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DLFileVersion exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"uuid", "size"});

    @Override
    public List<DLFileVersion> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByUuid(String uuid, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByUuid(String uuid, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (uuid.equals(dlFileVersion.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByUuid_First(String uuid, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByUuid_First(uuid, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByUuid_First(String uuid, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByUuid_Last(String uuid, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByUuid_Last(uuid, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByUuid_Last(String uuid, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByUuid_PrevAndNext(long fileVersionId, String uuid, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        uuid = Objects.toString(uuid, "");
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByUuid_PrevAndNext(session, dlFileVersion, uuid, orderByComparator, true), dlFileVersion, this.getByUuid_PrevAndNext(session, dlFileVersion, uuid, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByUuid_PrevAndNext(Session session, DLFileVersion dlFileVersion, String uuid, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid(String uuid) {
        for (DLFileVersion dlFileVersion : this.findByUuid(uuid, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public DLFileVersion findByUUID_G(String uuid, long groupId) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByUUID_G(uuid, groupId);
        if (dlFileVersion == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchFileVersionException(msg.toString());
        }
        return dlFileVersion;
    }

    @Override
    public DLFileVersion fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    @Override
    public DLFileVersion fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        DLFileVersion dlFileVersion;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByUUID_G, finderArgs, this);
        }
        if (result instanceof DLFileVersion && (!Objects.equals(uuid, (dlFileVersion = (DLFileVersion)result).getUuid()) || groupId != dlFileVersion.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("dlFileVersion.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, finderArgs, list);
                } else {
                    DLFileVersion dlFileVersion2 = (DLFileVersion)list.get(0);
                    result = dlFileVersion2;
                    this.cacheResult(dlFileVersion2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLFileVersion)result;
    }

    @Override
    public DLFileVersion removeByUUID_G(String uuid, long groupId) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByUUID_G(uuid, groupId);
        return this.remove(dlFileVersion);
    }

    @Override
    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("dlFileVersion.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (uuid.equals(dlFileVersion.getUuid()) && companyId == dlFileVersion.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("dlFileVersion.uuid = ? AND ");
            }
            query.append("dlFileVersion.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByUuid_C_First(String uuid, long companyId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByUuid_C_Last(String uuid, long companyId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByUuid_C_PrevAndNext(long fileVersionId, String uuid, long companyId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        uuid = Objects.toString(uuid, "");
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByUuid_C_PrevAndNext(session, dlFileVersion, uuid, companyId, orderByComparator, true), dlFileVersion, this.getByUuid_C_PrevAndNext(session, dlFileVersion, uuid, companyId, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByUuid_C_PrevAndNext(Session session, DLFileVersion dlFileVersion, String uuid, long companyId, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append("(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("dlFileVersion.uuid = ? AND ");
        }
        query.append("dlFileVersion.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid_C(String uuid, long companyId) {
        for (DLFileVersion dlFileVersion : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(dlFileVersion.uuid IS NULL OR dlFileVersion.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("dlFileVersion.uuid = ? AND ");
            }
            query.append("dlFileVersion.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByCompanyId(long companyId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByCompanyId(long companyId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (companyId == dlFileVersion.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByCompanyId_First(long companyId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByCompanyId_First(long companyId, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByCompanyId_Last(long companyId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByCompanyId_Last(long companyId, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByCompanyId_PrevAndNext(long fileVersionId, long companyId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByCompanyId_PrevAndNext(session, dlFileVersion, companyId, orderByComparator, true), dlFileVersion, this.getByCompanyId_PrevAndNext(session, dlFileVersion, companyId, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByCompanyId_PrevAndNext(Session session, DLFileVersion dlFileVersion, long companyId, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append("dlFileVersion.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByCompanyId(long companyId) {
        for (DLFileVersion dlFileVersion : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByFileEntryId(long fileEntryId) {
        return this.findByFileEntryId(fileEntryId, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByFileEntryId(long fileEntryId, int start, int end) {
        return this.findByFileEntryId(fileEntryId, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByFileEntryId(long fileEntryId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByFileEntryId(fileEntryId, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByFileEntryId(long fileEntryId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByFileEntryId;
            finderArgs = new Object[]{fileEntryId};
        } else {
            finderPath = this._finderPathWithPaginationFindByFileEntryId;
            finderArgs = new Object[]{fileEntryId, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (fileEntryId == dlFileVersion.getFileEntryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append(_FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(fileEntryId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByFileEntryId_First(long fileEntryId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByFileEntryId_First(fileEntryId, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("fileEntryId=");
        msg.append(fileEntryId);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByFileEntryId_First(long fileEntryId, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByFileEntryId(fileEntryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByFileEntryId_Last(long fileEntryId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByFileEntryId_Last(fileEntryId, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("fileEntryId=");
        msg.append(fileEntryId);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByFileEntryId_Last(long fileEntryId, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByFileEntryId(fileEntryId);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByFileEntryId(fileEntryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByFileEntryId_PrevAndNext(long fileVersionId, long fileEntryId, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByFileEntryId_PrevAndNext(session, dlFileVersion, fileEntryId, orderByComparator, true), dlFileVersion, this.getByFileEntryId_PrevAndNext(session, dlFileVersion, fileEntryId, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByFileEntryId_PrevAndNext(Session session, DLFileVersion dlFileVersion, long fileEntryId, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append(_FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(fileEntryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByFileEntryId(long fileEntryId) {
        for (DLFileVersion dlFileVersion : this.findByFileEntryId(fileEntryId, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByFileEntryId(long fileEntryId) {
        FinderPath finderPath = this._finderPathCountByFileEntryId;
        Object[] finderArgs = new Object[]{fileEntryId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append(_FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(fileEntryId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByMimeType(String mimeType) {
        return this.findByMimeType(mimeType, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByMimeType(String mimeType, int start, int end) {
        return this.findByMimeType(mimeType, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByMimeType(String mimeType, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByMimeType(mimeType, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByMimeType(String mimeType, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        mimeType = Objects.toString(mimeType, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByMimeType;
            finderArgs = new Object[]{mimeType};
        } else {
            finderPath = this._finderPathWithPaginationFindByMimeType;
            finderArgs = new Object[]{mimeType, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (mimeType.equals(dlFileVersion.getMimeType())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            boolean bindMimeType = false;
            if (mimeType.isEmpty()) {
                query.append(_FINDER_COLUMN_MIMETYPE_MIMETYPE_3);
            } else {
                bindMimeType = true;
                query.append(_FINDER_COLUMN_MIMETYPE_MIMETYPE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindMimeType) {
                    qPos.add(mimeType);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByMimeType_First(String mimeType, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByMimeType_First(mimeType, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("mimeType=");
        msg.append(mimeType);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByMimeType_First(String mimeType, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByMimeType(mimeType, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByMimeType_Last(String mimeType, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByMimeType_Last(mimeType, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("mimeType=");
        msg.append(mimeType);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByMimeType_Last(String mimeType, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByMimeType(mimeType);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByMimeType(mimeType, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByMimeType_PrevAndNext(long fileVersionId, String mimeType, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        mimeType = Objects.toString(mimeType, "");
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByMimeType_PrevAndNext(session, dlFileVersion, mimeType, orderByComparator, true), dlFileVersion, this.getByMimeType_PrevAndNext(session, dlFileVersion, mimeType, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByMimeType_PrevAndNext(Session session, DLFileVersion dlFileVersion, String mimeType, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        boolean bindMimeType = false;
        if (mimeType.isEmpty()) {
            query.append(_FINDER_COLUMN_MIMETYPE_MIMETYPE_3);
        } else {
            bindMimeType = true;
            query.append(_FINDER_COLUMN_MIMETYPE_MIMETYPE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindMimeType) {
            qPos.add(mimeType);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByMimeType(String mimeType) {
        for (DLFileVersion dlFileVersion : this.findByMimeType(mimeType, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByMimeType(String mimeType) {
        mimeType = Objects.toString(mimeType, "");
        FinderPath finderPath = this._finderPathCountByMimeType;
        Object[] finderArgs = new Object[]{mimeType};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            boolean bindMimeType = false;
            if (mimeType.isEmpty()) {
                query.append(_FINDER_COLUMN_MIMETYPE_MIMETYPE_3);
            } else {
                bindMimeType = true;
                query.append(_FINDER_COLUMN_MIMETYPE_MIMETYPE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindMimeType) {
                    qPos.add(mimeType);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByC_NotS(long companyId, int status) {
        return this.findByC_NotS(companyId, status, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByC_NotS(long companyId, int status, int start, int end) {
        return this.findByC_NotS(companyId, status, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByC_NotS(long companyId, int status, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByC_NotS(companyId, status, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByC_NotS(long companyId, int status, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_NotS;
        finderArgs = new Object[]{companyId, status, start, end, orderByComparator};
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (companyId == dlFileVersion.getCompanyId() && status != dlFileVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append(_FINDER_COLUMN_C_NOTS_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_NOTS_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByC_NotS_First(long companyId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByC_NotS_First(companyId, status, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByC_NotS_First(long companyId, int status, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByC_NotS(companyId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByC_NotS_Last(long companyId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByC_NotS_Last(companyId, status, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByC_NotS_Last(long companyId, int status, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByC_NotS(companyId, status);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByC_NotS(companyId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByC_NotS_PrevAndNext(long fileVersionId, long companyId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByC_NotS_PrevAndNext(session, dlFileVersion, companyId, status, orderByComparator, true), dlFileVersion, this.getByC_NotS_PrevAndNext(session, dlFileVersion, companyId, status, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByC_NotS_PrevAndNext(Session session, DLFileVersion dlFileVersion, long companyId, int status, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append(_FINDER_COLUMN_C_NOTS_COMPANYID_2);
        query.append(_FINDER_COLUMN_C_NOTS_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_NotS(long companyId, int status) {
        for (DLFileVersion dlFileVersion : this.findByC_NotS(companyId, status, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByC_NotS(long companyId, int status) {
        FinderPath finderPath = this._finderPathWithPaginationCountByC_NotS;
        Object[] finderArgs = new Object[]{companyId, status};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append(_FINDER_COLUMN_C_NOTS_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_NOTS_STATUS_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public DLFileVersion findByF_V(long fileEntryId, String version) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByF_V(fileEntryId, version);
        if (dlFileVersion == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("fileEntryId=");
            msg.append(fileEntryId);
            msg.append(", version=");
            msg.append(version);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchFileVersionException(msg.toString());
        }
        return dlFileVersion;
    }

    @Override
    public DLFileVersion fetchByF_V(long fileEntryId, String version) {
        return this.fetchByF_V(fileEntryId, version, true);
    }

    @Override
    public DLFileVersion fetchByF_V(long fileEntryId, String version, boolean retrieveFromCache) {
        DLFileVersion dlFileVersion;
        version = Objects.toString(version, "");
        Object[] finderArgs = new Object[]{fileEntryId, version};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByF_V, finderArgs, this);
        }
        if (result instanceof DLFileVersion && (fileEntryId != (dlFileVersion = (DLFileVersion)result).getFileEntryId() || !Objects.equals(version, dlFileVersion.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.fileEntryId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append("(dlFileVersion.version IS NULL OR dlFileVersion.version = '')");
            } else {
                bindVersion = true;
                query.append("dlFileVersion.version = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(fileEntryId);
                if (bindVersion) {
                    qPos.add(version);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByF_V, finderArgs, list);
                } else {
                    DLFileVersion dlFileVersion2 = (DLFileVersion)list.get(0);
                    result = dlFileVersion2;
                    this.cacheResult(dlFileVersion2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByF_V, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLFileVersion)result;
    }

    @Override
    public DLFileVersion removeByF_V(long fileEntryId, String version) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByF_V(fileEntryId, version);
        return this.remove(dlFileVersion);
    }

    @Override
    public int countByF_V(long fileEntryId, String version) {
        version = Objects.toString(version, "");
        FinderPath finderPath = this._finderPathCountByF_V;
        Object[] finderArgs = new Object[]{fileEntryId, version};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.fileEntryId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append("(dlFileVersion.version IS NULL OR dlFileVersion.version = '')");
            } else {
                bindVersion = true;
                query.append("dlFileVersion.version = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(fileEntryId);
                if (bindVersion) {
                    qPos.add(version);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByF_S(long fileEntryId, int status) {
        return this.findByF_S(fileEntryId, status, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByF_S(long fileEntryId, int status, int start, int end) {
        return this.findByF_S(fileEntryId, status, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByF_S(long fileEntryId, int status, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByF_S(fileEntryId, status, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByF_S(long fileEntryId, int status, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByF_S;
            finderArgs = new Object[]{fileEntryId, status};
        } else {
            finderPath = this._finderPathWithPaginationFindByF_S;
            finderArgs = new Object[]{fileEntryId, status, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (fileEntryId == dlFileVersion.getFileEntryId() && status == dlFileVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.fileEntryId = ? AND ");
            query.append("dlFileVersion.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(fileEntryId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByF_S_First(long fileEntryId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByF_S_First(fileEntryId, status, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("fileEntryId=");
        msg.append(fileEntryId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByF_S_First(long fileEntryId, int status, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByF_S(fileEntryId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByF_S_Last(long fileEntryId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByF_S_Last(fileEntryId, status, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("fileEntryId=");
        msg.append(fileEntryId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByF_S_Last(long fileEntryId, int status, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByF_S(fileEntryId, status);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByF_S(fileEntryId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByF_S_PrevAndNext(long fileVersionId, long fileEntryId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByF_S_PrevAndNext(session, dlFileVersion, fileEntryId, status, orderByComparator, true), dlFileVersion, this.getByF_S_PrevAndNext(session, dlFileVersion, fileEntryId, status, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByF_S_PrevAndNext(Session session, DLFileVersion dlFileVersion, long fileEntryId, int status, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append("dlFileVersion.fileEntryId = ? AND ");
        query.append("dlFileVersion.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(fileEntryId);
        qPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByF_S(long fileEntryId, int status) {
        for (DLFileVersion dlFileVersion : this.findByF_S(fileEntryId, status, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByF_S(long fileEntryId, int status) {
        FinderPath finderPath = this._finderPathCountByF_S;
        Object[] finderArgs = new Object[]{fileEntryId, status};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.fileEntryId = ? AND ");
            query.append("dlFileVersion.status = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(fileEntryId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByG_F_S(long groupId, long folderId, int status) {
        return this.findByG_F_S(groupId, folderId, status, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByG_F_S(long groupId, long folderId, int status, int start, int end) {
        return this.findByG_F_S(groupId, folderId, status, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByG_F_S(long groupId, long folderId, int status, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByG_F_S(groupId, folderId, status, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByG_F_S(long groupId, long folderId, int status, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByG_F_S;
            finderArgs = new Object[]{groupId, folderId, status};
        } else {
            finderPath = this._finderPathWithPaginationFindByG_F_S;
            finderArgs = new Object[]{groupId, folderId, status, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (groupId == dlFileVersion.getGroupId() && folderId == dlFileVersion.getFolderId() && status == dlFileVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            query.append("dlFileVersion.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(folderId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByG_F_S_First(long groupId, long folderId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByG_F_S_First(groupId, folderId, status, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", folderId=");
        msg.append(folderId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByG_F_S_First(long groupId, long folderId, int status, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByG_F_S(groupId, folderId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByG_F_S_Last(long groupId, long folderId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByG_F_S_Last(groupId, folderId, status, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", folderId=");
        msg.append(folderId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByG_F_S_Last(long groupId, long folderId, int status, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByG_F_S(groupId, folderId, status);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByG_F_S(groupId, folderId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByG_F_S_PrevAndNext(long fileVersionId, long groupId, long folderId, int status, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByG_F_S_PrevAndNext(session, dlFileVersion, groupId, folderId, status, orderByComparator, true), dlFileVersion, this.getByG_F_S_PrevAndNext(session, dlFileVersion, groupId, folderId, status, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByG_F_S_PrevAndNext(Session session, DLFileVersion dlFileVersion, long groupId, long folderId, int status, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append("dlFileVersion.groupId = ? AND ");
        query.append("dlFileVersion.folderId = ? AND ");
        query.append("dlFileVersion.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        qPos.add(folderId);
        qPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByG_F_S(long groupId, long folderId, int status) {
        for (DLFileVersion dlFileVersion : this.findByG_F_S(groupId, folderId, status, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByG_F_S(long groupId, long folderId, int status) {
        FinderPath finderPath = this._finderPathCountByG_F_S;
        Object[] finderArgs = new Object[]{groupId, folderId, status};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            query.append("dlFileVersion.status = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(folderId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<DLFileVersion> findByG_F_T_V(long groupId, long folderId, String title, String version) {
        return this.findByG_F_T_V(groupId, folderId, title, version, -1, -1, null);
    }

    @Override
    public List<DLFileVersion> findByG_F_T_V(long groupId, long folderId, String title, String version, int start, int end) {
        return this.findByG_F_T_V(groupId, folderId, title, version, start, end, null);
    }

    @Override
    public List<DLFileVersion> findByG_F_T_V(long groupId, long folderId, String title, String version, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findByG_F_T_V(groupId, folderId, title, version, start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findByG_F_T_V(long groupId, long folderId, String title, String version, int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        title = Objects.toString(title, "");
        version = Objects.toString(version, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByG_F_T_V;
            finderArgs = new Object[]{groupId, folderId, title, version};
        } else {
            finderPath = this._finderPathWithPaginationFindByG_F_T_V;
            finderArgs = new Object[]{groupId, folderId, title, version, start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache && (list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (DLFileVersion dlFileVersion : list) {
                if (groupId == dlFileVersion.getGroupId() && folderId == dlFileVersion.getFolderId() && title.equals(dlFileVersion.getTitle()) && version.equals(dlFileVersion.getVersion())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            boolean bindTitle = false;
            if (title.isEmpty()) {
                query.append(_FINDER_COLUMN_G_F_T_V_TITLE_3);
            } else {
                bindTitle = true;
                query.append(_FINDER_COLUMN_G_F_T_V_TITLE_2);
            }
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append("(dlFileVersion.version IS NULL OR dlFileVersion.version = '')");
            } else {
                bindVersion = true;
                query.append("dlFileVersion.version = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(folderId);
                if (bindTitle) {
                    qPos.add(title);
                }
                if (bindVersion) {
                    qPos.add(version);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public DLFileVersion findByG_F_T_V_First(long groupId, long folderId, String title, String version, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByG_F_T_V_First(groupId, folderId, title, version, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", folderId=");
        msg.append(folderId);
        msg.append(", title=");
        msg.append(title);
        msg.append(", version=");
        msg.append(version);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByG_F_T_V_First(long groupId, long folderId, String title, String version, OrderByComparator<DLFileVersion> orderByComparator) {
        List<DLFileVersion> list = this.findByG_F_T_V(groupId, folderId, title, version, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion findByG_F_T_V_Last(long groupId, long folderId, String title, String version, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = this.fetchByG_F_T_V_Last(groupId, folderId, title, version, orderByComparator);
        if (dlFileVersion != null) {
            return dlFileVersion;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", folderId=");
        msg.append(folderId);
        msg.append(", title=");
        msg.append(title);
        msg.append(", version=");
        msg.append(version);
        msg.append("}");
        throw new NoSuchFileVersionException(msg.toString());
    }

    @Override
    public DLFileVersion fetchByG_F_T_V_Last(long groupId, long folderId, String title, String version, OrderByComparator<DLFileVersion> orderByComparator) {
        int count = this.countByG_F_T_V(groupId, folderId, title, version);
        if (count == 0) {
            return null;
        }
        List<DLFileVersion> list = this.findByG_F_T_V(groupId, folderId, title, version, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public DLFileVersion[] findByG_F_T_V_PrevAndNext(long fileVersionId, long groupId, long folderId, String title, String version, OrderByComparator<DLFileVersion> orderByComparator) throws NoSuchFileVersionException {
        title = Objects.toString(title, "");
        version = Objects.toString(version, "");
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByG_F_T_V_PrevAndNext(session, dlFileVersion, groupId, folderId, title, version, orderByComparator, true), dlFileVersion, this.getByG_F_T_V_PrevAndNext(session, dlFileVersion, groupId, folderId, title, version, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByG_F_T_V_PrevAndNext(Session session, DLFileVersion dlFileVersion, long groupId, long folderId, String title, String version, OrderByComparator<DLFileVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append("dlFileVersion.groupId = ? AND ");
        query.append("dlFileVersion.folderId = ? AND ");
        boolean bindTitle = false;
        if (title.isEmpty()) {
            query.append(_FINDER_COLUMN_G_F_T_V_TITLE_3);
        } else {
            bindTitle = true;
            query.append(_FINDER_COLUMN_G_F_T_V_TITLE_2);
        }
        boolean bindVersion = false;
        if (version.isEmpty()) {
            query.append("(dlFileVersion.version IS NULL OR dlFileVersion.version = '')");
        } else {
            bindVersion = true;
            query.append("dlFileVersion.version = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        qPos.add(folderId);
        if (bindTitle) {
            qPos.add(title);
        }
        if (bindVersion) {
            qPos.add(version);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(dlFileVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByG_F_T_V(long groupId, long folderId, String title, String version) {
        for (DLFileVersion dlFileVersion : this.findByG_F_T_V(groupId, folderId, title, version, -1, -1, null)) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countByG_F_T_V(long groupId, long folderId, String title, String version) {
        title = Objects.toString(title, "");
        version = Objects.toString(version, "");
        FinderPath finderPath = this._finderPathCountByG_F_T_V;
        Object[] finderArgs = new Object[]{groupId, folderId, title, version};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            boolean bindTitle = false;
            if (title.isEmpty()) {
                query.append(_FINDER_COLUMN_G_F_T_V_TITLE_3);
            } else {
                bindTitle = true;
                query.append(_FINDER_COLUMN_G_F_T_V_TITLE_2);
            }
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append("(dlFileVersion.version IS NULL OR dlFileVersion.version = '')");
            } else {
                bindVersion = true;
                query.append("dlFileVersion.version = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(folderId);
                if (bindTitle) {
                    qPos.add(title);
                }
                if (bindVersion) {
                    qPos.add(version);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLFileVersionPersistenceImpl() {
        this.setModelClass(DLFileVersion.class);
        this.setModelImplClass(DLFileVersionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(DLFileVersion dlFileVersion) {
        EntityCacheUtil.putResult(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, Long.valueOf(dlFileVersion.getPrimaryKey()), dlFileVersion);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, new Object[]{dlFileVersion.getUuid(), dlFileVersion.getGroupId()}, dlFileVersion);
        FinderCacheUtil.putResult(this._finderPathFetchByF_V, new Object[]{dlFileVersion.getFileEntryId(), dlFileVersion.getVersion()}, dlFileVersion);
        dlFileVersion.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<DLFileVersion> dlFileVersions) {
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            if (EntityCacheUtil.getResult(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, Long.valueOf(dlFileVersion.getPrimaryKey())) == null) {
                this.cacheResult(dlFileVersion);
                continue;
            }
            dlFileVersion.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(DLFileVersionImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(DLFileVersion dlFileVersion) {
        EntityCacheUtil.removeResult(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, Long.valueOf(dlFileVersion.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DLFileVersionModelImpl)((Object)dlFileVersion), true);
    }

    @Override
    public void clearCache(List<DLFileVersion> dlFileVersions) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            EntityCacheUtil.removeResult(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, Long.valueOf(dlFileVersion.getPrimaryKey()));
            this.clearUniqueFindersCache((DLFileVersionModelImpl)((Object)dlFileVersion), true);
        }
    }

    protected void cacheUniqueFindersCache(DLFileVersionModelImpl dlFileVersionModelImpl) {
        Object[] args = new Object[]{dlFileVersionModelImpl.getUuid(), dlFileVersionModelImpl.getGroupId()};
        FinderCacheUtil.putResult(this._finderPathCountByUUID_G, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, args, dlFileVersionModelImpl, false);
        args = new Object[]{dlFileVersionModelImpl.getFileEntryId(), dlFileVersionModelImpl.getVersion()};
        FinderCacheUtil.putResult(this._finderPathCountByF_V, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByF_V, args, dlFileVersionModelImpl, false);
    }

    protected void clearUniqueFindersCache(DLFileVersionModelImpl dlFileVersionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{dlFileVersionModelImpl.getUuid(), dlFileVersionModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{dlFileVersionModelImpl.getOriginalUuid(), dlFileVersionModelImpl.getOriginalGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{dlFileVersionModelImpl.getFileEntryId(), dlFileVersionModelImpl.getVersion()};
            FinderCacheUtil.removeResult(this._finderPathCountByF_V, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByF_V, args);
        }
        if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathFetchByF_V.getColumnBitmask()) != 0L) {
            args = new Object[]{dlFileVersionModelImpl.getOriginalFileEntryId(), dlFileVersionModelImpl.getOriginalVersion()};
            FinderCacheUtil.removeResult(this._finderPathCountByF_V, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByF_V, args);
        }
    }

    @Override
    public DLFileVersion create(long fileVersionId) {
        DLFileVersionImpl dlFileVersion = new DLFileVersionImpl();
        dlFileVersion.setNew(true);
        dlFileVersion.setPrimaryKey(fileVersionId);
        String uuid = PortalUUIDUtil.generate();
        dlFileVersion.setUuid(uuid);
        dlFileVersion.setCompanyId(this.companyProvider.getCompanyId());
        return dlFileVersion;
    }

    @Override
    public DLFileVersion remove(long fileVersionId) throws NoSuchFileVersionException {
        return this.remove(Long.valueOf(fileVersionId));
    }

    @Override
    public DLFileVersion remove(Serializable primaryKey) throws NoSuchFileVersionException {
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion dlFileVersion = (DLFileVersion)session.get(DLFileVersionImpl.class, primaryKey);
            if (dlFileVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchFileVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DLFileVersion dLFileVersion = this.remove(dlFileVersion);
            return dLFileVersion;
        }
        catch (NoSuchFileVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected DLFileVersion removeImpl(DLFileVersion dlFileVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(dlFileVersion)) {
                dlFileVersion = (DLFileVersion)session.get(DLFileVersionImpl.class, dlFileVersion.getPrimaryKeyObj());
            }
            if (dlFileVersion != null) {
                session.delete(dlFileVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (dlFileVersion != null) {
            this.clearCache(dlFileVersion);
        }
        return dlFileVersion;
    }

    @Override
    public DLFileVersion updateImpl(DLFileVersion dlFileVersion) {
        boolean isNew = dlFileVersion.isNew();
        if (!(dlFileVersion instanceof DLFileVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(dlFileVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(dlFileVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in dlFileVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DLFileVersion implementation " + dlFileVersion.getClass());
        }
        DLFileVersionModelImpl dlFileVersionModelImpl = (DLFileVersionModelImpl)((Object)dlFileVersion);
        if (Validator.isNull(dlFileVersion.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            dlFileVersion.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && dlFileVersion.getCreateDate() == null) {
            if (serviceContext == null) {
                dlFileVersion.setCreateDate(now);
            } else {
                dlFileVersion.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!dlFileVersionModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                dlFileVersion.setModifiedDate(now);
            } else {
                dlFileVersion.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (dlFileVersion.isNew()) {
                session.save(dlFileVersion);
                dlFileVersion.setNew(false);
            } else {
                dlFileVersion = (DLFileVersion)session.merge(dlFileVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!DLFileVersionModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{dlFileVersionModelImpl.getUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{dlFileVersionModelImpl.getUuid(), dlFileVersionModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{dlFileVersionModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{dlFileVersionModelImpl.getFileEntryId()};
            FinderCacheUtil.removeResult(this._finderPathCountByFileEntryId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByFileEntryId, args);
            args = new Object[]{dlFileVersionModelImpl.getMimeType()};
            FinderCacheUtil.removeResult(this._finderPathCountByMimeType, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByMimeType, args);
            args = new Object[]{dlFileVersionModelImpl.getFileEntryId(), dlFileVersionModelImpl.getStatus()};
            FinderCacheUtil.removeResult(this._finderPathCountByF_S, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByF_S, args);
            args = new Object[]{dlFileVersionModelImpl.getGroupId(), dlFileVersionModelImpl.getFolderId(), dlFileVersionModelImpl.getStatus()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_F_S, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_F_S, args);
            args = new Object[]{dlFileVersionModelImpl.getGroupId(), dlFileVersionModelImpl.getFolderId(), dlFileVersionModelImpl.getTitle(), dlFileVersionModelImpl.getVersion()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_F_T_V, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_F_T_V, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{dlFileVersionModelImpl.getUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalUuid(), dlFileVersionModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{dlFileVersionModelImpl.getUuid(), dlFileVersionModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{dlFileVersionModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByFileEntryId.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalFileEntryId()};
                FinderCacheUtil.removeResult(this._finderPathCountByFileEntryId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByFileEntryId, args);
                args = new Object[]{dlFileVersionModelImpl.getFileEntryId()};
                FinderCacheUtil.removeResult(this._finderPathCountByFileEntryId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByFileEntryId, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByMimeType.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalMimeType()};
                FinderCacheUtil.removeResult(this._finderPathCountByMimeType, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByMimeType, args);
                args = new Object[]{dlFileVersionModelImpl.getMimeType()};
                FinderCacheUtil.removeResult(this._finderPathCountByMimeType, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByMimeType, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByF_S.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalFileEntryId(), dlFileVersionModelImpl.getOriginalStatus()};
                FinderCacheUtil.removeResult(this._finderPathCountByF_S, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByF_S, args);
                args = new Object[]{dlFileVersionModelImpl.getFileEntryId(), dlFileVersionModelImpl.getStatus()};
                FinderCacheUtil.removeResult(this._finderPathCountByF_S, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByF_S, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_F_S.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalGroupId(), dlFileVersionModelImpl.getOriginalFolderId(), dlFileVersionModelImpl.getOriginalStatus()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_F_S, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_F_S, args);
                args = new Object[]{dlFileVersionModelImpl.getGroupId(), dlFileVersionModelImpl.getFolderId(), dlFileVersionModelImpl.getStatus()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_F_S, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_F_S, args);
            }
            if ((dlFileVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_F_T_V.getColumnBitmask()) != 0L) {
                args = new Object[]{dlFileVersionModelImpl.getOriginalGroupId(), dlFileVersionModelImpl.getOriginalFolderId(), dlFileVersionModelImpl.getOriginalTitle(), dlFileVersionModelImpl.getOriginalVersion()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_F_T_V, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_F_T_V, args);
                args = new Object[]{dlFileVersionModelImpl.getGroupId(), dlFileVersionModelImpl.getFolderId(), dlFileVersionModelImpl.getTitle(), dlFileVersionModelImpl.getVersion()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_F_T_V, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_F_T_V, args);
            }
        }
        EntityCacheUtil.putResult(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, Long.valueOf(dlFileVersion.getPrimaryKey()), dlFileVersion, false);
        this.clearUniqueFindersCache(dlFileVersionModelImpl, false);
        this.cacheUniqueFindersCache(dlFileVersionModelImpl);
        dlFileVersion.resetOriginalValues();
        return dlFileVersion;
    }

    @Override
    public DLFileVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchFileVersionException {
        DLFileVersion dlFileVersion = (DLFileVersion)this.fetchByPrimaryKey(primaryKey);
        if (dlFileVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchFileVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return dlFileVersion;
    }

    @Override
    public DLFileVersion findByPrimaryKey(long fileVersionId) throws NoSuchFileVersionException {
        return this.findByPrimaryKey(Long.valueOf(fileVersionId));
    }

    @Override
    public DLFileVersion fetchByPrimaryKey(long fileVersionId) {
        return (DLFileVersion)this.fetchByPrimaryKey(Long.valueOf(fileVersionId));
    }

    @Override
    public List<DLFileVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<DLFileVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<DLFileVersion> findAll(int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<DLFileVersion> findAll(int start, int end, OrderByComparator<DLFileVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<DLFileVersion> list = null;
        if (retrieveFromCache) {
            list = (List<DLFileVersion>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_DLFILEVERSION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DLFILEVERSION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY dlFileVersion.fileEntryId DESC, dlFileVersion.createDate DESC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (DLFileVersion dlFileVersion : this.findAll()) {
            this.remove(dlFileVersion);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_DLFILEVERSION);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "fileVersionId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_DLFILEVERSION;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return DLFileVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 642L);
        this._finderPathCountByUuid = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 136L);
        this._finderPathCountByUUID_G = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 643L);
        this._finderPathCountByUuid_C = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 515L);
        this._finderPathCountByCompanyId = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByFileEntryId = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFileEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByFileEntryId = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFileEntryId", new String[]{Long.class.getName()}, 514L);
        this._finderPathCountByFileEntryId = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFileEntryId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByMimeType = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByMimeType", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByMimeType = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByMimeType", new String[]{String.class.getName()}, 530L);
        this._finderPathCountByMimeType = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMimeType", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByC_NotS = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_NotS", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_NotS = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_NotS", new String[]{Long.class.getName(), Integer.class.getName()});
        this._finderPathFetchByF_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByF_V", new String[]{Long.class.getName(), String.class.getName()}, 258L);
        this._finderPathCountByF_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByF_V", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByF_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByF_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByF_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByF_S", new String[]{Long.class.getName(), Integer.class.getName()}, 546L);
        this._finderPathCountByF_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByF_S", new String[]{Long.class.getName(), Integer.class.getName()});
        this._finderPathWithPaginationFindByG_F_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_F_S", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_F_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_F_S", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, 558L);
        this._finderPathCountByG_F_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_F_S", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()});
        this._finderPathWithPaginationFindByG_F_T_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_F_T_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_F_T_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, DLFileVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_F_T_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()}, 846L);
        this._finderPathCountByG_F_T_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_F_T_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(DLFileVersionImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

