/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionServiceBaseImpl;
import java.util.List;

public class DLFileVersionServiceImpl
extends DLFileVersionServiceBaseImpl {
    private static volatile ModelResourcePermission<FileEntry> _fileEntryModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLFileVersionServiceImpl.class, "_fileEntryModelResourcePermission", FileEntry.class);

    @Override
    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException {
        DLFileVersion fileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
        _fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileVersion.getFileEntryId(), "VIEW");
        return fileVersion;
    }

    @Override
    public List<DLFileVersion> getFileVersions(long fileEntryId, int status) throws PortalException {
        _fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionLocalService.getFileVersions(fileEntryId, status);
    }

    @Override
    public int getFileVersionsCount(long fileEntryId, int status) throws PortalException {
        _fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionPersistence.countByF_S(fileEntryId, status);
    }

    @Override
    public DLFileVersion getLatestFileVersion(long fileEntryId) throws PortalException {
        _fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionLocalService.getLatestFileVersion(this.getGuestOrUserId(), fileEntryId);
    }

    @Override
    public DLFileVersion getLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) throws PortalException {
        _fileEntryModelResourcePermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, excludeWorkingCopy);
    }
}

