/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

public class DLFileVersionLocalServiceImpl
extends DLFileVersionLocalServiceBaseImpl {
    @Override
    public DLFileVersion fetchLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) {
        List<DLFileVersion> dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        if (dlFileVersions.isEmpty()) {
            return null;
        }
        dlFileVersions = ListUtil.copy(dlFileVersions);
        Collections.sort(dlFileVersions, new DLFileVersionVersionComparator());
        DLFileVersion dlFileVersion = dlFileVersions.get(0);
        String version = dlFileVersion.getVersion();
        if (excludeWorkingCopy && version.equals("PWC")) {
            return dlFileVersions.get(1);
        }
        return dlFileVersion;
    }

    @Override
    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
    }

    @Override
    public DLFileVersion getFileVersion(long fileEntryId, String version) throws PortalException {
        return this.dlFileVersionPersistence.findByF_V(fileEntryId, version);
    }

    @Override
    public DLFileVersion getFileVersionByUuidAndGroupId(String uuid, long groupId) {
        return this.dlFileVersionPersistence.fetchByUUID_G(uuid, groupId);
    }

    @Override
    public List<DLFileVersion> getFileVersions(long fileEntryId, int status) {
        List<DLFileVersion> dlFileVersions = null;
        dlFileVersions = status == -1 ? this.dlFileVersionPersistence.findByFileEntryId(fileEntryId) : this.dlFileVersionPersistence.findByF_S(fileEntryId, status);
        dlFileVersions = ListUtil.copy(dlFileVersions);
        Collections.sort(dlFileVersions, new DLFileVersionVersionComparator());
        return dlFileVersions;
    }

    @Override
    public int getFileVersionsCount(long fileEntryId, int status) {
        if (status == -1) {
            return this.dlFileVersionPersistence.countByFileEntryId(fileEntryId);
        }
        return this.dlFileVersionPersistence.countByF_S(fileEntryId, status);
    }

    @Override
    public DLFileVersion getLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) throws PortalException {
        DLFileVersion dlFileVersion = this.fetchLatestFileVersion(fileEntryId, excludeWorkingCopy);
        if (dlFileVersion == null) {
            throw new NoSuchFileVersionException("No file versions found for fileEntryId " + fileEntryId);
        }
        return dlFileVersion;
    }

    @Override
    public DLFileVersion getLatestFileVersion(long userId, long fileEntryId) throws PortalException {
        boolean excludeWorkingCopy = true;
        if (this.dlFileEntryLocalService.isFileEntryCheckedOut(fileEntryId)) {
            excludeWorkingCopy = !this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntryId);
        }
        return this.getLatestFileVersion(fileEntryId, excludeWorkingCopy);
    }

    @Override
    public void rebuildTree(long companyId) throws PortalException {
        this.dlFolderLocalService.rebuildTree(companyId);
    }

    @Override
    public void setTreePaths(long folderId, String treePath) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName("folderId");
            dynamicQuery.add(folderIdProperty.eq(folderId));
            Property treePathProperty = PropertyFactoryUtil.forName("treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or(treePathProperty.isNull(), treePathProperty.ne(treePath)));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileVersion -> {
            dlFileVersion.setTreePath(treePath);
            this.updateDLFileVersion((DLFileVersion)dlFileVersion);
        });
        actionableDynamicQuery.performActions();
    }
}

