/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.FileShortcutPermissionException;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutServiceBaseImpl;

public class DLFileShortcutServiceImpl
extends DLFileShortcutServiceBaseImpl {
    private static volatile ModelResourcePermission<FileEntry> _fileEntryModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLFileShortcutServiceImpl.class, "_fileEntryModelResourcePermission", FileEntry.class);
    private static volatile ModelResourcePermission<FileShortcut> _fileShortcutModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLFileShortcutServiceImpl.class, "_fileShortcutModelResourcePermission", FileShortcut.class);
    private static volatile ModelResourcePermission<Folder> _folderModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLFileShortcutServiceImpl.class, "_folderModelResourcePermission", Folder.class);

    @Override
    public DLFileShortcut addFileShortcut(long groupId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(_folderModelResourcePermission, this.getPermissionChecker(), groupId, folderId, "ADD_SHORTCUT");
        try {
            _fileEntryModelResourcePermission.check(this.getPermissionChecker(), toFileEntryId, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException(pe);
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), groupId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    @Override
    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        _fileShortcutModelResourcePermission.check(this.getPermissionChecker(), fileShortcutId, "DELETE");
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    @Override
    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        _fileShortcutModelResourcePermission.check(this.getPermissionChecker(), fileShortcutId, "VIEW");
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    @Override
    public DLFileShortcut updateFileShortcut(long fileShortcutId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        _fileShortcutModelResourcePermission.check(this.getPermissionChecker(), fileShortcutId, "UPDATE");
        try {
            _fileEntryModelResourcePermission.check(this.getPermissionChecker(), toFileEntryId, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException(pe);
        }
        return this.dlFileShortcutLocalService.updateFileShortcut(this.getUserId(), fileShortcutId, repositoryId, folderId, toFileEntryId, serviceContext);
    }

    @Override
    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        try {
            _fileEntryModelResourcePermission.check(this.getPermissionChecker(), oldToFileEntryId, "VIEW");
            _fileEntryModelResourcePermission.check(this.getPermissionChecker(), newToFileEntryId, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException(pe);
        }
        this.dlFileShortcutLocalService.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }
}

