/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class DLFileShortcutLocalServiceImpl
extends DLFileShortcutLocalServiceBaseImpl {
    @BeanReference(type=RepositoryLocalService.class)
    private RepositoryLocalService _repositoryLocalService;

    @Override
    public DLFileShortcut addFileShortcut(long userId, long groupId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        this.validate(user, toFileEntryId);
        long fileShortcutId = this.counterLocalService.increment();
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.create(fileShortcutId);
        fileShortcut.setUuid(serviceContext.getUuid());
        fileShortcut.setGroupId(groupId);
        fileShortcut.setCompanyId(user.getCompanyId());
        fileShortcut.setUserId(user.getUserId());
        fileShortcut.setUserName(user.getFullName());
        fileShortcut.setRepositoryId(repositoryId);
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFileEntryId(toFileEntryId);
        fileShortcut.setTreePath(fileShortcut.buildTreePath());
        fileShortcut.setActive(true);
        fileShortcut.setStatus(0);
        fileShortcut.setStatusByUserId(userId);
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(new Date());
        this.dlFileShortcutPersistence.update(fileShortcut);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileShortcutResources(fileShortcut, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileShortcutResources(fileShortcut, serviceContext.getModelPermissions());
        }
        if (folderId != 0L) {
            this.dlFolderLocalService.updateLastPostDate(folderId, fileShortcut.getModifiedDate());
        }
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(toFileEntryId);
        this.copyAssetTags(fileEntry, serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    @Override
    public void addFileShortcutResources(DLFileShortcut fileShortcut, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), false, addGroupPermissions, addGuestPermissions);
    }

    @Override
    public void addFileShortcutResources(DLFileShortcut fileShortcut, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), modelPermissions);
    }

    @Override
    public void addFileShortcutResources(long fileShortcutId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, addGroupPermissions, addGuestPermissions);
    }

    @Override
    public void addFileShortcutResources(long fileShortcutId, ModelPermissions modelPermissions) throws PortalException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, modelPermissions);
    }

    @Override
    @SystemEvent(type=1)
    public void deleteFileShortcut(DLFileShortcut fileShortcut) throws PortalException {
        this.dlFileShortcutPersistence.remove(fileShortcut);
        this.resourceLocalService.deleteResource(fileShortcut.getCompanyId(), DLFileShortcutConstants.getClassName(), 4, fileShortcut.getFileShortcutId());
        this.assetEntryLocalService.deleteEntry(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        if (fileShortcut.isInTrashExplicitly()) {
            this.trashEntryLocalService.deleteEntry(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        } else {
            this.trashVersionLocalService.deleteTrashVersion(DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId());
        }
    }

    @Override
    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        DLFileShortcut fileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut);
    }

    @Override
    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        List<DLFileShortcut> fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut);
        }
    }

    @Override
    public void deleteFileShortcuts(long groupId, long folderId) throws PortalException {
        this.deleteFileShortcuts(groupId, folderId, true);
    }

    @Override
    public void deleteFileShortcuts(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        List<DLFileShortcut> fileShortcuts = this.dlFileShortcutPersistence.findByG_F(groupId, folderId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            if (!includeTrashedEntries && fileShortcut.isInTrashExplicitly()) continue;
            this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcut);
        }
    }

    @Override
    public void deleteRepositoryFileShortcuts(long repositoryId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.dlFileShortcutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq("repositoryId", repositoryId)));
        long groupId = repositoryId;
        Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            groupId = repository.getGroupId();
        }
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(fileShortcut -> this.dlFileShortcutLocalService.deleteDLFileShortcut((DLFileShortcut)fileShortcut));
        actionableDynamicQuery.performActions();
    }

    @Override
    public void disableFileShortcuts(long toFileEntryId) {
        this.updateFileShortcutsActive(toFileEntryId, false);
    }

    @Override
    public void enableFileShortcuts(long toFileEntryId) {
        this.updateFileShortcutsActive(toFileEntryId, true);
    }

    @Override
    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
    }

    @Override
    public List<DLFileShortcut> getFileShortcuts(long toFileEntryId) {
        return this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
    }

    @Override
    public List<DLFileShortcut> getFileShortcuts(long groupId, long folderId, boolean active, int status, int start, int end) {
        return this.dlFileShortcutPersistence.findByG_F_A_S(groupId, folderId, active, status, start, end);
    }

    @Override
    public int getFileShortcutsCount(long groupId, long folderId, boolean active, int status) {
        return this.dlFileShortcutPersistence.countByG_F_A_S(groupId, folderId, active, status);
    }

    @Override
    public void rebuildTree(long companyId) throws PortalException {
        this.dlFolderLocalService.rebuildTree(companyId);
    }

    @Override
    public void setTreePaths(long folderId, String treePath) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName("folderId");
            dynamicQuery.add(folderIdProperty.eq(folderId));
            Property treePathProperty = PropertyFactoryUtil.forName("treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or(treePathProperty.isNull(), treePathProperty.ne(treePath)));
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileShortcut -> {
            dlFileShortcut.setTreePath(treePath);
            this.updateDLFileShortcut((DLFileShortcut)dlFileShortcut);
        });
        actionableDynamicQuery.performActions();
    }

    @Override
    public void updateAsset(long userId, DLFileShortcut fileShortcut, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileShortcut.getToFileEntryId());
        this.assetEntryLocalService.updateEntry(userId, fileShortcut.getGroupId(), fileShortcut.getCreateDate(), fileShortcut.getModifiedDate(), DLFileShortcutConstants.getClassName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, fileShortcut.getCreateDate(), null, fileEntry.getMimeType(), fileEntry.getTitle(), fileEntry.getDescription(), null, null, null, 0, 0, null);
    }

    @Override
    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.validate(user, toFileEntryId);
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFileEntryId(toFileEntryId);
        fileShortcut.setTreePath(fileShortcut.buildTreePath());
        this.dlFileShortcutPersistence.update(fileShortcut);
        if (folderId != 0L) {
            this.dlFolderLocalService.updateLastPostDate(folderId, fileShortcut.getModifiedDate());
        }
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(toFileEntryId);
        this.copyAssetTags(fileEntry, serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    @Override
    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) {
        List<DLFileShortcut> fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(oldToFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setToFileEntryId(newToFileEntryId);
            this.dlFileShortcutPersistence.update(fileShortcut);
        }
    }

    @Override
    public void updateFileShortcutsActive(long toFileEntryId, boolean active) {
        List<DLFileShortcut> fileShortcuts = this.dlFileShortcutPersistence.findByToFileEntryId(toFileEntryId);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setActive(active);
            this.dlFileShortcutPersistence.update(fileShortcut);
        }
    }

    @Override
    public DLFileShortcut updateStatus(long userId, long fileShortcutId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        fileShortcut.setStatus(status);
        fileShortcut.setStatusByUserId(user.getUserId());
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(serviceContext.getModifiedDate(null));
        return this.dlFileShortcutPersistence.update(fileShortcut);
    }

    protected void copyAssetTags(FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        String[] assetTagNames = this.assetTagLocalService.getTagNames(FileEntry.class.getName(), fileEntry.getFileEntryId());
        this.assetTagLocalService.checkTags(serviceContext.getUserId(), serviceContext.getScopeGroupId(), assetTagNames);
        serviceContext.setAssetTagNames(assetTagNames);
    }

    protected long getFolderId(long companyId, long folderId) {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected void validate(User user, long toFileEntryId) throws PortalException {
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(toFileEntryId);
        if (user.getCompanyId() != fileEntry.getCompanyId()) {
            throw new NoSuchFileEntryException("{fileEntryId=" + toFileEntryId + "}");
        }
    }
}

