/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeServiceBaseImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DLFileEntryTypeServiceImpl
extends DLFileEntryTypeServiceBaseImpl {
    private static volatile ModelResourcePermission<DLFileEntryType> _dlFileEntryTypeModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLFileEntryTypeServiceImpl.class, "_dlFileEntryTypeModelResourcePermission", DLFileEntryType.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(DLFileEntryTypeServiceImpl.class, "_portletResourcePermission", "com.liferay.document.library");

    @Override
    public DLFileEntryType addFileEntryType(long groupId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_DOCUMENT_TYPE");
        return this.dlFileEntryTypeLocalService.addFileEntryType(this.getUserId(), groupId, fileEntryTypeKey, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    @Override
    public DLFileEntryType addFileEntryType(long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        return this.addFileEntryType(groupId, null, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    @Override
    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException {
        _dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), fileEntryTypeId, "DELETE");
        this.dlFileEntryTypeLocalService.deleteFileEntryType(fileEntryTypeId);
    }

    @Override
    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException {
        _dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), fileEntryTypeId, "VIEW");
        return this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
    }

    @Override
    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) {
        return this.dlFileEntryTypePersistence.filterFindByGroupId(groupIds);
    }

    @Override
    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds, int start, int end) {
        return this.dlFileEntryTypePersistence.filterFindByGroupId(groupIds, start, end);
    }

    @Override
    public int getFileEntryTypesCount(long[] groupIds) {
        return this.dlFileEntryTypePersistence.filterCountByGroupId(groupIds);
    }

    @Override
    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException {
        return this.filterFileEntryTypes(this.dlFileEntryTypeLocalService.getFolderFileEntryTypes(groupIds, folderId, inherited));
    }

    @Override
    public List<DLFileEntryType> search(long companyId, long folderId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, boolean inherited, int start, int end) throws PortalException {
        return this.dlFileEntryTypeFinder.filterFindByKeywords(companyId, folderId, groupIds, keywords, includeBasicFileEntryType, inherited, start, end);
    }

    @Override
    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator<DLFileEntryType> orderByComparator) {
        return this.dlFileEntryTypeFinder.filterFindByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    @Override
    public int searchCount(long companyId, long folderId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, boolean inherited) {
        return this.dlFileEntryTypeFinder.filterCountByKeywords(companyId, folderId, groupIds, keywords, includeBasicFileEntryType, inherited);
    }

    @Override
    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) {
        return this.dlFileEntryTypeFinder.filterCountByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    @Override
    public void updateFileEntryType(long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        _dlFileEntryTypeModelResourcePermission.check(this.getPermissionChecker(), fileEntryTypeId, "UPDATE");
        this.dlFileEntryTypeLocalService.updateFileEntryType(this.getUserId(), fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    @Override
    public void updateFileEntryType(long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        this.updateFileEntryType(fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    protected List<DLFileEntryType> filterFileEntryTypes(List<DLFileEntryType> fileEntryTypes) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        fileEntryTypes = ListUtil.copy(fileEntryTypes);
        Iterator<DLFileEntryType> itr = fileEntryTypes.iterator();
        while (itr.hasNext()) {
            DLFileEntryType fileEntryType = itr.next();
            if (fileEntryType.getFileEntryTypeId() <= 0L || _dlFileEntryTypeModelResourcePermission.contains(permissionChecker, fileEntryType, "VIEW")) continue;
            itr.remove();
        }
        return fileEntryTypes;
    }
}

