/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryTypeException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryTypeException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.NoSuchMetadataSetException;
import com.liferay.document.library.kernel.exception.RequiredFileEntryTypeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLink;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLinkManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StructureDefinitionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DLFileEntryTypeLocalServiceImpl
extends DLFileEntryTypeLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryTypeLocalServiceImpl.class);

    @Override
    public void addDDMStructureLinks(long fileEntryTypeId, Set<Long> ddmStructureIds) {
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        for (long ddmStructureId : ddmStructureIds) {
            DDMStructureLinkManagerUtil.addStructureLink(classNameId, fileEntryTypeId, ddmStructureId);
        }
    }

    @Override
    public DLFileEntryType addFileEntryType(long userId, long groupId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        fileEntryTypeKey = Validator.isNull(fileEntryTypeKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase(fileEntryTypeKey.trim());
        String fileEntryTypeUuid = serviceContext.getUuid();
        if (Validator.isNull(fileEntryTypeUuid)) {
            fileEntryTypeUuid = PortalUUIDUtil.generate();
        }
        long fileEntryTypeId = this.counterLocalService.increment();
        ddmStructureIds = this._updateDDMStructure(userId, fileEntryTypeUuid, fileEntryTypeId, groupId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
        this.validate(fileEntryTypeId, groupId, fileEntryTypeKey, ddmStructureIds);
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(fileEntryTypeId);
        dlFileEntryType.setUuid(fileEntryTypeUuid);
        dlFileEntryType.setGroupId(groupId);
        dlFileEntryType.setCompanyId(user.getCompanyId());
        dlFileEntryType.setUserId(user.getUserId());
        dlFileEntryType.setUserName(user.getFullName());
        dlFileEntryType.setFileEntryTypeKey(fileEntryTypeKey);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        this.dlFileEntryTypePersistence.update(dlFileEntryType);
        this.addDDMStructureLinks(fileEntryTypeId, SetUtil.fromArray(ddmStructureIds));
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.getModelPermissions());
        }
        return dlFileEntryType;
    }

    @Override
    public DLFileEntryType addFileEntryType(long userId, long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        return this.addFileEntryType(userId, groupId, null, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    @Override
    public void cascadeFileEntryTypes(long userId, DLFolder dlFolder) throws PortalException {
        long[] groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds(dlFolder.getGroupId());
        List<DLFileEntryType> dlFileEntryTypes = this.getFolderFileEntryTypes(groupIds, dlFolder.getFolderId(), true);
        List<Long> fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes);
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(dlFolder.getFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(dlFolder.getCompanyId());
        serviceContext.setScopeGroupId(dlFolder.getGroupId());
        serviceContext.setUserId(userId);
        this.cascadeFileEntryTypes(userId, dlFolder.getGroupId(), dlFolder.getFolderId(), defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
    }

    @Override
    public DLFileEntryType createBasicDocumentDLFileEntryType() throws NoSuchFileEntryTypeException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(0L);
        dlFileEntryType.setCompanyId(0L);
        dlFileEntryType.setFileEntryTypeKey(StringUtil.toUpperCase("basic-document"));
        dlFileEntryType.setName("basic-document", LocaleUtil.getDefault());
        return this.dlFileEntryTypePersistence.update(dlFileEntryType);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public void deleteFileEntryType(DLFileEntryType dlFileEntryType) throws PortalException {
        if (this.dlFileEntryPersistence.countByFileEntryTypeId(dlFileEntryType.getFileEntryTypeId()) > 0) {
            throw new RequiredFileEntryTypeException("There are file entries of file entry type " + dlFileEntryType.getFileEntryTypeId());
        }
        DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure(dlFileEntryType.getGroupId(), this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), DLUtil.getDDMStructureKey(dlFileEntryType));
        if (ddmStructure == null) {
            ddmStructure = DDMStructureManagerUtil.fetchStructure(dlFileEntryType.getGroupId(), this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), DLUtil.getDeprecatedDDMStructureKey(dlFileEntryType));
        }
        if (ddmStructure != null) {
            long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
            DDMStructureLinkManagerUtil.deleteStructureLink(classNameId, dlFileEntryType.getFileEntryTypeId(), ddmStructure.getStructureId());
            DDMStructureManagerUtil.deleteStructure(ddmStructure.getStructureId());
        }
        this.dlFileEntryTypePersistence.remove(dlFileEntryType);
    }

    @Override
    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        this.dlFileEntryTypeLocalService.deleteFileEntryType(dlFileEntryType);
    }

    @Override
    public void deleteFileEntryTypes(long groupId) throws PortalException {
        List<DLFileEntryType> dlFileEntryTypes = this.dlFileEntryTypePersistence.findByGroupId(groupId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.dlFileEntryTypeLocalService.deleteFileEntryType(dlFileEntryType);
        }
    }

    @Override
    public DLFileEntryType fetchFileEntryType(long fileEntryTypeId) {
        return this.dlFileEntryTypePersistence.fetchByPrimaryKey(fileEntryTypeId);
    }

    @Override
    public DLFileEntryType fetchFileEntryType(long groupId, String fileEntryTypeKey) {
        fileEntryTypeKey = StringUtil.toUpperCase(StringUtil.trim(fileEntryTypeKey));
        return this.dlFileEntryTypePersistence.fetchByG_F(groupId, fileEntryTypeKey);
    }

    @Override
    public DLFileEntryType getBasicDocumentDLFileEntryType() throws NoSuchFileEntryTypeException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByPrimaryKey(0L);
        if (dlFileEntryType != null) {
            return dlFileEntryType;
        }
        return this.dlFileEntryTypeLocalService.createBasicDocumentDLFileEntryType();
    }

    @Override
    public long getDefaultFileEntryTypeId(long folderId) throws PortalException {
        if ((folderId = this.getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            return dlFolder.getDefaultFileEntryTypeId();
        }
        return 0L;
    }

    @Override
    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException {
        return this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
    }

    @Override
    public DLFileEntryType getFileEntryType(long groupId, String fileEntryTypeKey) throws PortalException {
        fileEntryTypeKey = StringUtil.toUpperCase(StringUtil.trim(fileEntryTypeKey));
        return this.dlFileEntryTypePersistence.findByG_F(groupId, fileEntryTypeKey);
    }

    @Override
    public List<DLFileEntryType> getFileEntryTypes(long ddmStructureId) throws PortalException {
        ArrayList<DLFileEntryType> fileEntryTypes = new ArrayList<DLFileEntryType>();
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        List<DDMStructureLink> ddmStructureLinks = DDMStructureLinkManagerUtil.getClassNameStructureLinks(classNameId);
        for (DDMStructureLink ddmStructureLink : ddmStructureLinks) {
            if (ddmStructureId != ddmStructureLink.getStructureId()) continue;
            DLFileEntryType fileEntryType = this.getFileEntryType(ddmStructureLink.getClassPK());
            fileEntryTypes.add(fileEntryType);
        }
        return fileEntryTypes;
    }

    @Override
    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) {
        return this.dlFileEntryTypePersistence.findByGroupId(groupIds);
    }

    @Override
    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException {
        if (!inherited) {
            return this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        List<DLFileEntryType> dlFileEntryTypes = null;
        if ((folderId = this.getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        } else {
            dlFileEntryTypes = new ArrayList<DLFileEntryType>(this.getFileEntryTypes(groupIds));
            DLFileEntryType dlFileEntryType = this.dlFileEntryTypeLocalService.getBasicDocumentDLFileEntryType();
            dlFileEntryTypes.add(0, dlFileEntryType);
        }
        return dlFileEntryTypes;
    }

    @Override
    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator<DLFileEntryType> orderByComparator) {
        return this.dlFileEntryTypeFinder.findByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    @Override
    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) {
        return this.dlFileEntryTypeFinder.countByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    @Override
    public void unsetFolderFileEntryTypes(long folderId) {
        List<DLFileEntryType> dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.dlFolderPersistence.removeDLFileEntryType(folderId, dlFileEntryType);
        }
    }

    @Override
    public void updateDDMStructureLinks(long fileEntryTypeId, Set<Long> ddmStructureIds) throws PortalException {
        Set<Long> existingDDMStructureLinkStructureIds = this.getExistingDDMStructureLinkStructureIds(fileEntryTypeId);
        this.deleteDDMStructureLinks(fileEntryTypeId, this.getStaleDDMStructureLinkStructureIds(ddmStructureIds, existingDDMStructureLinkStructureIds));
        this.addDDMStructureLinks(fileEntryTypeId, this.getMissingDDMStructureLinkStructureIds(ddmStructureIds, existingDDMStructureLinkStructureIds));
    }

    @Override
    public DLFileEntry updateFileEntryFileEntryType(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException {
        List<DLFileEntryType> dlFileEntryTypes;
        List<Long> fileEntryTypeIds;
        long groupId = serviceContext.getScopeGroupId();
        long folderId = 0L;
        DLFolder dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(dlFileEntry.getFolderId());
        if (dlFolder != null) {
            groupId = dlFolder.getGroupId();
            folderId = dlFolder.getFolderId();
        }
        if ((fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes = this.getFolderFileEntryTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds(groupId), folderId, true))).contains(dlFileEntry.getFileEntryTypeId())) {
            return dlFileEntry;
        }
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(folderId);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
        if (dlFileVersion.isPending()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
        }
        return this.dlFileEntryLocalService.updateFileEntry(serviceContext.getUserId(), dlFileEntry.getFileEntryId(), null, null, null, null, null, false, defaultFileEntryTypeId, null, null, null, 0L, serviceContext);
    }

    @Override
    public void updateFileEntryType(long userId, long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        ddmStructureIds = this._updateDDMStructure(userId, dlFileEntryType.getUuid(), fileEntryTypeId, dlFileEntryType.getGroupId(), nameMap, descriptionMap, ddmStructureIds, serviceContext);
        this.validate(fileEntryTypeId, dlFileEntryType.getGroupId(), dlFileEntryType.getFileEntryTypeKey(), ddmStructureIds);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        this.dlFileEntryTypePersistence.update(dlFileEntryType);
        this.updateDDMStructureLinks(fileEntryTypeId, SetUtil.fromArray(ddmStructureIds));
    }

    @Override
    public void updateFileEntryType(long userId, long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        this.updateFileEntryType(userId, fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    @Override
    public void updateFolderFileEntryTypes(DLFolder dlFolder, List<Long> fileEntryTypeIds, long defaultFileEntryTypeId, ServiceContext serviceContext) {
        List<Long> originalFileEntryTypeIds = this.getFileEntryTypeIds(this.dlFolderPersistence.getDLFileEntryTypes(dlFolder.getFolderId()));
        if (fileEntryTypeIds.equals(originalFileEntryTypeIds)) {
            return;
        }
        for (Long fileEntryTypeId : fileEntryTypeIds) {
            if (originalFileEntryTypeIds.contains(fileEntryTypeId)) continue;
            this.dlFolderPersistence.addDLFileEntryType(dlFolder.getFolderId(), fileEntryTypeId);
        }
        for (Long originalFileEntryTypeId : originalFileEntryTypeIds) {
            if (fileEntryTypeIds.contains(originalFileEntryTypeId)) continue;
            this.dlFolderPersistence.removeDLFileEntryType(dlFolder.getFolderId(), originalFileEntryTypeId);
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), originalFileEntryTypeId);
        }
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), modelPermissions);
    }

    protected void cascadeFileEntryTypes(long userId, long groupId, long folderId, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, ServiceContext serviceContext) throws PortalException {
        List<DLFileEntry> dlFileEntries = this.dlFileEntryPersistence.findByG_F(groupId, folderId);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
            if (fileEntryTypeIds.contains(fileEntryTypeId)) continue;
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
            if (dlFileVersion.isPending()) {
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), groupId, DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this.dlFileEntryLocalService.updateFileEntryType(userId, dlFileEntry.getFileEntryId(), defaultFileEntryTypeId, serviceContext);
            this.dlAppHelperLocalService.updateAsset(userId, new LiferayFileEntry(dlFileEntry), new LiferayFileVersion(dlFileVersion), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        }
        List<DLFolder> subfolders = this.dlFolderPersistence.findByG_M_P_H(groupId, false, folderId, false);
        for (DLFolder subfolder : subfolders) {
            if (subfolder.getRestrictionType() == 0) continue;
            this.cascadeFileEntryTypes(userId, groupId, subfolder.getFolderId(), defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
        }
    }

    protected void deleteDDMStructureLinks(long fileEntryTypeId, Set<Long> ddmStructureIds) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        for (long ddmStructureId : ddmStructureIds) {
            DDMStructureLinkManagerUtil.deleteStructureLink(classNameId, fileEntryTypeId, ddmStructureId);
        }
    }

    protected void fixDDMStructureKey(String fileEntryTypeUuid, long fileEntryTypeId, long groupId) throws PortalException {
        DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure(groupId, this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), DLUtil.getDeprecatedDDMStructureKey(fileEntryTypeId));
        if (ddmStructure != null) {
            DDMStructureManagerUtil.updateStructureKey(ddmStructure.getStructureId(), DLUtil.getDDMStructureKey(fileEntryTypeUuid));
        }
    }

    protected Set<Long> getExistingDDMStructureLinkStructureIds(long fileEntryTypeId) {
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryType.class);
        HashSet<Long> existingDDMStructureLinkStructureIds = new HashSet<Long>();
        List<DDMStructureLink> structureLinks = DDMStructureLinkManagerUtil.getStructureLinks(classNameId, fileEntryTypeId);
        for (DDMStructureLink structureLink : structureLinks) {
            existingDDMStructureLinkStructureIds.add(structureLink.getStructureId());
        }
        return existingDDMStructureLinkStructureIds;
    }

    protected List<Long> getFileEntryTypeIds(List<DLFileEntryType> dlFileEntryTypes) {
        SortedArrayList<Long> fileEntryTypeIds = new SortedArrayList<Long>();
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        return fileEntryTypeIds;
    }

    protected long getFileEntryTypesPrimaryFolderId(long folderId) throws NoSuchFolderException {
        DLFolder dlFolder;
        while (folderId != 0L && (dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() != 1) {
            folderId = dlFolder.getParentFolderId();
        }
        return folderId;
    }

    protected Set<Long> getMissingDDMStructureLinkStructureIds(Set<Long> ddmStructureIds, Set<Long> existingDDMStructureIds) {
        HashSet<Long> missingDDMStructureLinkStructureIds = new HashSet<Long>(ddmStructureIds);
        missingDDMStructureLinkStructureIds.removeAll(existingDDMStructureIds);
        return missingDDMStructureLinkStructureIds;
    }

    protected Set<Long> getStaleDDMStructureLinkStructureIds(Set<Long> ddmStructureIds, Set<Long> existingDDMStructureIds) {
        HashSet<Long> staleDDMStructureLinkStructureIds = new HashSet<Long>(existingDDMStructureIds);
        staleDDMStructureLinkStructureIds.removeAll(ddmStructureIds);
        return staleDDMStructureLinkStructureIds;
    }

    @Deprecated
    protected long updateDDMStructure(long userId, String fileEntryTypeUuid, long fileEntryTypeId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        this.fixDDMStructureKey(fileEntryTypeUuid, fileEntryTypeId, groupId);
        String ddmStructureKey = DLUtil.getDDMStructureKey(fileEntryTypeUuid);
        DDMForm ddmForm = (DDMForm)serviceContext.getAttribute("ddmForm");
        DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure(groupId, this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey);
        if (ddmStructure != null && ddmForm == null) {
            ddmForm = ddmStructure.getDDMForm();
        }
        if (ddmForm == null) {
            return 0L;
        }
        List<DDMFormField> ddmFormFields = ddmForm.getDDMFormFields();
        if (ddmFormFields.isEmpty()) {
            return 0L;
        }
        try {
            ddmStructure = ddmStructure == null ? DDMStructureManagerUtil.addStructure(userId, groupId, null, this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey, nameMap, descriptionMap, ddmForm, "json", 1, serviceContext) : DDMStructureManagerUtil.updateStructure(userId, ddmStructure.getStructureId(), ddmStructure.getParentStructureId(), nameMap, descriptionMap, ddmForm, serviceContext);
            return ddmStructure.getStructureId();
        }
        catch (StructureDefinitionException sde) {
            if (_log.isWarnEnabled()) {
                _log.warn(sde, sde);
            }
            if (ddmStructure != null) {
                DDMStructureManagerUtil.deleteStructure(ddmStructure.getStructureId());
            }
            return 0L;
        }
    }

    protected void validate(long fileEntryTypeId, long groupId, String fileEntryTypeKey, long[] ddmStructureIds) throws PortalException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByG_F(groupId, fileEntryTypeKey);
        if (dlFileEntryType != null && dlFileEntryType.getFileEntryTypeId() != fileEntryTypeId) {
            throw new DuplicateFileEntryTypeException("A file entry type already exists for key " + fileEntryTypeKey);
        }
        if (ddmStructureIds.length == 0) {
            throw new NoSuchMetadataSetException("DDM structure IDs is empty for file entry type " + fileEntryTypeKey);
        }
        for (long ddmStructureId : ddmStructureIds) {
            DDMStructure ddmStructure = DDMStructureManagerUtil.fetchStructure(ddmStructureId);
            if (ddmStructure != null) continue;
            throw new NoSuchMetadataSetException("{ddmStructureId=" + ddmStructureId);
        }
    }

    private void _deleteDDMStructure(long fileEntryTypeId, long ddmStructureId) throws PortalException {
        this.deleteDDMStructureLinks(fileEntryTypeId, Collections.singleton(ddmStructureId));
        DDMStructureManagerUtil.deleteStructure(ddmStructureId);
    }

    private DDMForm _getDDMForm(DDMStructure ddmStructure, ServiceContext serviceContext) {
        DDMForm ddmForm = (DDMForm)serviceContext.getAttribute("ddmForm");
        if (ddmForm != null) {
            return ddmForm;
        }
        if (ddmStructure != null) {
            return ddmStructure.getDDMForm();
        }
        return null;
    }

    private boolean _isEmptyDDMForm(DDMForm ddmForm) {
        if (ddmForm == null) {
            return true;
        }
        List<DDMFormField> ddmFormFields = ddmForm.getDDMFormFields();
        return ddmFormFields.isEmpty();
    }

    private long[] _updateDDMStructure(long userId, String fileEntryTypeUuid, long fileEntryTypeId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = null;
        try {
            this.fixDDMStructureKey(fileEntryTypeUuid, fileEntryTypeId, groupId);
            String ddmStructureKey = DLUtil.getDDMStructureKey(fileEntryTypeUuid);
            ddmStructure = DDMStructureManagerUtil.fetchStructure(groupId, this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey);
            DDMForm ddmForm = this._getDDMForm(ddmStructure, serviceContext);
            if (this._isEmptyDDMForm(ddmForm)) {
                if (ddmStructure != null) {
                    this._deleteDDMStructure(fileEntryTypeId, ddmStructure.getStructureId());
                    return ArrayUtil.remove(ddmStructureIds, ddmStructure.getStructureId());
                }
                return ddmStructureIds;
            }
            ddmStructure = ddmStructure == null ? DDMStructureManagerUtil.addStructure(userId, groupId, null, this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey, nameMap, descriptionMap, ddmForm, "json", 1, serviceContext) : DDMStructureManagerUtil.updateStructure(userId, ddmStructure.getStructureId(), ddmStructure.getParentStructureId(), nameMap, descriptionMap, ddmForm, serviceContext);
            return ArrayUtil.append(ddmStructureIds, ddmStructure.getStructureId());
        }
        catch (StructureDefinitionException sde) {
            if (_log.isWarnEnabled()) {
                _log.warn(sde, sde);
            }
            if (ddmStructure != null) {
                long ddmStructureId = ddmStructure.getStructureId();
                this._deleteDDMStructure(fileEntryTypeId, ddmStructureId);
                return ArrayUtil.remove(ddmStructureIds, ddmStructureId);
            }
            return ddmStructureIds;
        }
    }
}

