/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLinkManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryMetadataLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;

public class DLFileEntryMetadataLocalServiceImpl
extends DLFileEntryMetadataLocalServiceBaseImpl {
    @Override
    public void deleteFileEntryMetadata(DLFileEntryMetadata fileEntryMetadata) throws PortalException {
        this.dlFileEntryMetadataPersistence.remove(fileEntryMetadata);
        StorageEngineManagerUtil.deleteByClass(fileEntryMetadata.getDDMStorageId());
        long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class);
        DDMStructureLinkManagerUtil.deleteStructureLinks(classNameId, fileEntryMetadata.getFileEntryMetadataId());
    }

    @Override
    public void deleteFileEntryMetadata(long fileEntryId) throws PortalException {
        List<DLFileEntryMetadata> fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileEntryId(fileEntryId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    @Override
    public void deleteFileVersionFileEntryMetadata(long fileVersionId) throws PortalException {
        List<DLFileEntryMetadata> fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileVersionId(fileVersionId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    @Override
    public DLFileEntryMetadata fetchFileEntryMetadata(long fileEntryMetadataId) {
        return this.dlFileEntryMetadataPersistence.fetchByPrimaryKey(fileEntryMetadataId);
    }

    @Override
    public DLFileEntryMetadata fetchFileEntryMetadata(long ddmStructureId, long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructureId, fileVersionId);
    }

    @Override
    public DLFileEntryMetadata getFileEntryMetadata(long fileEntryMetadataId) throws PortalException {
        return this.dlFileEntryMetadataPersistence.findByPrimaryKey(fileEntryMetadataId);
    }

    @Override
    public DLFileEntryMetadata getFileEntryMetadata(long ddmStructureId, long fileVersionId) throws PortalException {
        return this.dlFileEntryMetadataPersistence.findByD_F(ddmStructureId, fileVersionId);
    }

    @Override
    public List<DLFileEntryMetadata> getFileVersionFileEntryMetadatas(long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.findByFileVersionId(fileVersionId);
    }

    @Override
    public long getFileVersionFileEntryMetadatasCount(long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.countByFileVersionId(fileVersionId);
    }

    @Override
    public List<DLFileEntryMetadata> getMismatchedCompanyIdFileEntryMetadatas() {
        return this.dlFileEntryMetadataFinder.findByMismatchedCompanyId();
    }

    @Override
    public List<DLFileEntryMetadata> getNoStructuresFileEntryMetadatas() {
        return this.dlFileEntryMetadataFinder.findByNoStructures();
    }

    @Override
    public void updateFileEntryMetadata(long companyId, List<DDMStructure> ddmStructures, long fileEntryId, long fileVersionId, Map<String, DDMFormValues> ddmFormValuesMap, ServiceContext serviceContext) throws PortalException {
        for (DDMStructure ddmStructure : ddmStructures) {
            DDMFormValues ddmFormValues = ddmFormValuesMap.get(ddmStructure.getStructureKey());
            if (ddmFormValues == null) continue;
            this.updateFileEntryMetadata(companyId, ddmStructure, fileEntryId, fileVersionId, ddmFormValues, serviceContext);
        }
    }

    @Override
    public void updateFileEntryMetadata(long fileEntryTypeId, long fileEntryId, long fileVersionId, Map<String, DDMFormValues> ddmFormValuesMap, ServiceContext serviceContext) throws PortalException {
        DLFileEntryType fileEntryType = this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
        List<DDMStructure> ddmStructures = fileEntryType.getDDMStructures();
        this.updateFileEntryMetadata(fileEntryType.getCompanyId(), ddmStructures, fileEntryId, fileVersionId, ddmFormValuesMap, serviceContext);
    }

    protected void updateFileEntryMetadata(long companyId, DDMStructure ddmStructure, long fileEntryId, long fileVersionId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DLFileEntryMetadata fileEntryMetadata = this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructure.getStructureId(), fileVersionId);
        if (fileEntryMetadata != null) {
            StorageEngineManagerUtil.update(fileEntryMetadata.getDDMStorageId(), ddmFormValues, serviceContext);
        } else {
            long fileEntryMetadataId = this.counterLocalService.increment();
            fileEntryMetadata = this.dlFileEntryMetadataPersistence.create(fileEntryMetadataId);
            long ddmStorageId = StorageEngineManagerUtil.create(companyId, ddmStructure.getStructureId(), ddmFormValues, serviceContext);
            fileEntryMetadata.setDDMStorageId(ddmStorageId);
            fileEntryMetadata.setDDMStructureId(ddmStructure.getStructureId());
            fileEntryMetadata.setFileEntryId(fileEntryId);
            fileEntryMetadata.setFileVersionId(fileVersionId);
            this.dlFileEntryMetadataPersistence.update(fileEntryMetadata);
            long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class);
            DDMStructureLinkManagerUtil.addStructureLink(classNameId, fileEntryMetadata.getFileEntryMetadataId(), ddmStructure.getStructureId());
        }
    }
}

