/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.ImageSizeException;
import com.liferay.document.library.kernel.exception.InvalidFileEntryTypeException;
import com.liferay.document.library.kernel.exception.InvalidFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderModel;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLFileVersionPolicy;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.versioning.VersioningStrategy;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.util.ExpandoBridgeUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.InvalidLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DLFileEntryLocalServiceImpl
extends DLFileEntryLocalServiceBaseImpl {
    @BeanReference(type=DLFileVersionPolicy.class)
    protected DLFileVersionPolicy dlFileVersionPolicy;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryLocalServiceImpl.class);
    private static final Pattern _fileVersionPattern = Pattern.compile("\\d+\\.\\d+");
    private static volatile VersioningStrategy _versioningStrategy = ServiceProxyFactory.newServiceTrackedInstance(VersioningStrategy.class, DLFileEntryLocalServiceImpl.class, "_versioningStrategy", false, true);

    @Override
    public DLFileEntry addFileEntry(long userId, long groupId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull(title)) {
            throw new FileNameException(StringBundler.concat("Unable to add file entry with file name ", sourceFileName, " because title is null"));
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.dlFolderLocalService.getFolderId(user.getCompanyId(), folderId);
        String name = String.valueOf(this.counterLocalService.increment(DLFileEntry.class.getName()));
        String extension = DLAppUtil.getExtension(title, sourceFileName);
        String fileName = DLUtil.getSanitizedFileName(title, extension);
        if (fileEntryTypeId == -1L) {
            fileEntryTypeId = this.dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(folderId);
        }
        this.validateFileEntryTypeId(PortalUtil.getCurrentAndAncestorSiteGroupIds(groupId), folderId, fileEntryTypeId);
        this.validateFile(groupId, folderId, 0L, sourceFileName, fileName, extension, title);
        long fileEntryId = this.counterLocalService.increment();
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.create(fileEntryId);
        dlFileEntry.setUuid(serviceContext.getUuid());
        dlFileEntry.setGroupId(groupId);
        dlFileEntry.setCompanyId(user.getCompanyId());
        dlFileEntry.setUserId(user.getUserId());
        dlFileEntry.setUserName(user.getFullName());
        DLFolderModel repositoryDLFolder = null;
        if (repositoryId != groupId) {
            Repository repository = this.repositoryLocalService.getRepository(repositoryId);
            repositoryDLFolder = this.dlFolderPersistence.findByPrimaryKey(repository.getDlFolderId());
        }
        long classNameId = 0L;
        long classPK = 0L;
        if (repositoryDLFolder != null && repositoryDLFolder.isHidden()) {
            classNameId = this.classNameLocalService.getClassNameId((String)((Object)serviceContext.getAttribute("className")));
            classPK = ParamUtil.getLong(serviceContext, "classPK");
        }
        dlFileEntry.setClassNameId(classNameId);
        dlFileEntry.setClassPK(classPK);
        dlFileEntry.setRepositoryId(repositoryId);
        dlFileEntry.setFolderId(folderId);
        dlFileEntry.setTreePath(dlFileEntry.buildTreePath());
        dlFileEntry.setName(name);
        dlFileEntry.setFileName(fileName);
        dlFileEntry.setExtension(extension);
        dlFileEntry.setMimeType(mimeType);
        dlFileEntry.setTitle(title);
        dlFileEntry.setDescription(description);
        dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
        dlFileEntry.setVersion("1.0");
        dlFileEntry.setSize(size);
        dlFileEntry.setReadCount(0);
        this.dlFileEntryPersistence.update(dlFileEntry);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        this.addFileVersion(user, dlFileEntry, fileName, extension, mimeType, title, description, changeLog, "", fileEntryTypeId, ddmFormValuesMap, "1.0", size, 2, serviceContext);
        if (folderId != 0L) {
            this.dlFolderLocalService.updateLastPostDate(dlFileEntry.getFolderId(), dlFileEntry.getModifiedDate());
        }
        if (file != null) {
            DLStoreUtil.addFile(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), name, false, file);
        } else {
            DLStoreUtil.addFile(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), name, false, is);
        }
        return dlFileEntry;
    }

    @Override
    public DLFileVersion cancelCheckOut(long userId, long fileEntryId) throws PortalException {
        if (!this.isFileEntryCheckedOut(fileEntryId)) {
            return null;
        }
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        this.removeFileVersion(dlFileEntry, dlFileVersion);
        return dlFileVersion;
    }

    @Override
    @Deprecated
    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.dlFileEntryLocalService.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.fromMajorVersion(majorVersion), changeLog, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        DLFileVersion latestDLFileVersion;
        DLFileVersion lastDLFileVersion;
        DLVersionNumberIncrease computedDLVersionNumberIncrease;
        if (!this.isFileEntryCheckedOut(fileEntryId)) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean webDAVCheckInMode = GetterUtil.getBoolean(serviceContext.getAttribute("webDAVCheckInMode"));
        boolean manualCheckInRequired = dlFileEntry.isManualCheckInRequired();
        if (!webDAVCheckInMode && manualCheckInRequired) {
            dlFileEntry.setManualCheckInRequired(false);
            this.dlFileEntryPersistence.update(dlFileEntry);
        }
        if ((computedDLVersionNumberIncrease = this._computeDLVersionNumberIncrease(dlVersionNumberIncrease, lastDLFileVersion = this.dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), dlFileEntry.getVersion()), latestDLFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false), serviceContext.getWorkflowAction())) == DLVersionNumberIncrease.NONE) {
            this._overwritePreviousFileVersion(user, dlFileEntry, latestDLFileVersion, lastDLFileVersion, serviceContext);
            this.unlockFileEntry(fileEntryId);
            return;
        }
        String version = this.getNextVersion(dlFileEntry, computedDLVersionNumberIncrease);
        latestDLFileVersion.setVersion(version);
        latestDLFileVersion.setChangeLog(changeLog);
        this.dlFileVersionPersistence.update(latestDLFileVersion);
        if (dlFileEntry.getFolderId() != 0L) {
            this.dlFolderLocalService.updateLastPostDate(dlFileEntry.getFolderId(), latestDLFileVersion.getModifiedDate());
        }
        DLStoreUtil.copyFileVersion(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), "PWC", version);
        this.unlockFileEntry(fileEntryId);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        Lock lock;
        if (Validator.isNotNull(lockUuid) && (lock = LockManagerUtil.fetchLock(DLFileEntry.class.getName(), fileEntryId)) != null && !Objects.equals(lock.getUuid(), lockUuid)) {
            throw new InvalidLockException("UUIDs do not match");
        }
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.MINOR, "", serviceContext);
    }

    @Override
    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, long fileEntryTypeId, ServiceContext serviceContext) throws PortalException {
        return this.checkOutFileEntry(userId, fileEntryId, fileEntryTypeId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    @Override
    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, long fileEntryTypeId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        String oldVersion = dlFileVersion.getVersion();
        DLFileEntry dlFileEntry = this._checkOutDLFileEntryModel(userId, fileEntryId, fileEntryTypeId, owner, expirationTime, serviceContext);
        if (!oldVersion.equals("PWC")) {
            if (DLStoreUtil.hasFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), "PWC")) {
                DLStoreUtil.deleteFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), "PWC");
            }
            DLStoreUtil.copyFileVersion(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), oldVersion, "PWC");
        }
        return dlFileEntry;
    }

    @Override
    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this.checkOutFileEntry(userId, fileEntryId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    @Override
    public DLFileEntry checkOutFileEntry(long userId, long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        return this.checkOutFileEntry(userId, fileEntryId, dlFileEntry.getFileEntryTypeId(), owner, expirationTime, serviceContext);
    }

    @Override
    public void convertExtraSettings(String[] keys) throws PortalException {
        int total = this.dlFileEntryFinder.countByExtraSettings();
        IntervalActionProcessor<Void> intervalActionProcessor = new IntervalActionProcessor<Void>(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List<DLFileEntry> dlFileEntries = this.dlFileEntryFinder.findByExtraSettings(start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                this.convertExtraSettings(dlFileEntry, keys);
            }
            intervalActionProcessor.incrementStart(dlFileEntries.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    @Override
    public DLFileEntry copyFileEntry(long userId, long groupId, long repositoryId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        String sourceFileName = "A";
        String extension = dlFileEntry.getExtension();
        if (Validator.isNotNull(extension)) {
            sourceFileName = StringBundler.concat(sourceFileName, ".", extension);
        }
        InputStream inputStream = DLStoreUtil.getFileAsStream(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName());
        DLFileEntry newDLFileEntry = this.addFileEntry(userId, groupId, repositoryId, destFolderId, sourceFileName, dlFileEntry.getMimeType(), dlFileEntry.getTitle(), dlFileEntry.getDescription(), null, dlFileEntry.getFileEntryTypeId(), null, null, inputStream, dlFileEntry.getSize(), serviceContext);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        DLFileVersion newDLFileVersion = newDLFileEntry.getFileVersion();
        ExpandoBridgeUtil.copyExpandoBridgeAttributes(dlFileVersion.getExpandoBridge(), newDLFileVersion.getExpandoBridge());
        this.copyFileEntryMetadata(dlFileVersion.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, dlFileVersion.getFileVersionId(), newDLFileVersion.getFileVersionId(), serviceContext);
        return newDLFileEntry;
    }

    @Override
    public void copyFileEntryMetadata(long companyId, long fileEntryTypeId, long fileEntryId, long fromFileVersionId, long toFileVersionId, ServiceContext serviceContext) throws PortalException {
        List<DDMStructure> ddmStructures;
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        if (fileEntryTypeId > 0L) {
            DLFileEntryType dlFileEntryType = this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
            ddmStructures = dlFileEntryType.getDDMStructures();
        } else {
            long classNameId = this.classNameLocalService.getClassNameId(DLFileEntryMetadata.class);
            ddmStructures = DDMStructureManagerUtil.getClassStructures(companyId, classNameId);
        }
        this.copyFileEntryMetadata(companyId, fileEntryId, fromFileVersionId, toFileVersionId, serviceContext, ddmFormValuesMap, ddmStructures);
    }

    @Override
    public void deleteFileEntries(long groupId, long folderId) throws PortalException {
        this.deleteFileEntries(groupId, folderId, true);
    }

    @Override
    public void deleteFileEntries(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = this.getFolderRepositoryEventTrigger(groupId, folderId);
        ActionableDynamicQuery actionableDynamicQuery = this.dlFileEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdproperty = PropertyFactoryUtil.forName("folderId");
            dynamicQuery.add(folderIdproperty.eq(folderId));
        });
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            if (includeTrashedEntries || !dlFileEntry.isInTrashExplicitly()) {
                repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, new LiferayFileEntry((DLFileEntry)dlFileEntry));
                this.dlFileEntryLocalService.deleteFileEntry((DLFileEntry)dlFileEntry);
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DLFileEntry deleteFileEntry(DLFileEntry dlFileEntry) throws PortalException {
        block3: {
            this.dlFileEntryPersistence.remove(dlFileEntry);
            this.resourceLocalService.deleteResource(dlFileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, dlFileEntry.getFileEntryId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            this.dlFileEntryMetadataLocalService.deleteFileEntryMetadata(dlFileEntry.getFileEntryId());
            List<DLFileVersion> dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(dlFileEntry.getFileEntryId());
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                this.dlFileVersionPersistence.remove(dlFileVersion);
                this.expandoRowLocalService.deleteRows(dlFileVersion.getFileVersionId());
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this.expandoRowLocalService.deleteRows(dlFileEntry.getFileEntryId());
            this.ratingsStatsLocalService.deleteStats(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            this.unlockFileEntry(dlFileEntry.getFileEntryId());
            try {
                DLStoreUtil.deleteFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return dlFileEntry;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        return this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Indexable(type=IndexableType.DELETE)
    public DLFileEntry deleteFileEntry(long userId, long fileEntryId) throws PortalException {
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        try {
            DLFileEntry dLFileEntry = this.dlFileEntryLocalService.deleteFileEntry(fileEntryId);
            return dLFileEntry;
        }
        finally {
            this.unlockFileEntry(fileEntryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Indexable(type=IndexableType.REINDEX)
    public DLFileEntry deleteFileVersion(long userId, long fileEntryId, String version) throws PortalException {
        if (!this._isValidFileVersionNumber(version)) {
            throw new InvalidFileVersionException(StringBundler.concat("Unable to delete version for file entry ", fileEntryId, " because version number ", version, " is invalid"));
        }
        if (version.equals("PWC")) {
            throw new InvalidFileVersionException(StringBundler.concat("Unable to delete a private working copy file version ", version, " for file entry ", fileEntryId));
        }
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        boolean latestVersion = false;
        DLFileEntry dlFileEntry = null;
        try {
            DLFileVersion dlLatestFileVersion;
            DLFileVersion dlFileVersion = this.dlFileVersionPersistence.findByF_V(fileEntryId, version);
            if (!dlFileVersion.isApproved()) {
                throw new InvalidFileVersionException(StringBundler.concat("Unable to delete the unapproved file version ", version, " for file entry ", fileEntryId));
            }
            int count = this.dlFileVersionPersistence.countByF_S(fileEntryId, 0);
            if (count <= 1) {
                throw new InvalidFileVersionException(StringBundler.concat("Unable to delete the only approved file version ", version, " for file entry ", fileEntryId));
            }
            this.dlFileVersionPersistence.remove(dlFileVersion);
            this.expandoRowLocalService.deleteRows(dlFileVersion.getFileVersionId());
            this.dlFileEntryMetadataLocalService.deleteFileVersionFileEntryMetadata(dlFileVersion.getFileVersionId());
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(dlFileVersion.getCompanyId(), dlFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), dlFileVersion.getFileVersionId());
            dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
            latestVersion = version.equals(dlFileEntry.getVersion());
            if (latestVersion && (dlLatestFileVersion = this.dlFileVersionLocalService.fetchLatestFileVersion(dlFileEntry.getFileEntryId(), true)) != null) {
                long fileEntryTypeId = this.getValidFileEntryTypeId(dlLatestFileVersion.getFileEntryTypeId(), dlFileEntry);
                dlLatestFileVersion.setModifiedDate(new Date());
                dlLatestFileVersion.setFileEntryTypeId(fileEntryTypeId);
                dlLatestFileVersion.setStatusDate(new Date());
                this.dlFileVersionPersistence.update(dlLatestFileVersion);
                dlFileEntry.setModifiedDate(new Date());
                dlFileEntry.setFileName(dlLatestFileVersion.getFileName());
                dlFileEntry.setExtension(dlLatestFileVersion.getExtension());
                dlFileEntry.setMimeType(dlLatestFileVersion.getMimeType());
                dlFileEntry.setTitle(dlLatestFileVersion.getTitle());
                dlFileEntry.setDescription(dlLatestFileVersion.getDescription());
                dlFileEntry.setExtraSettings(dlLatestFileVersion.getExtraSettings());
                dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
                dlFileEntry.setVersion(dlLatestFileVersion.getVersion());
                dlFileEntry.setSize(dlLatestFileVersion.getSize());
                dlFileEntry = this.dlFileEntryPersistence.update(dlFileEntry);
            }
            DLStoreUtil.deleteFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), version);
        }
        finally {
            this.unlockFileEntry(fileEntryId);
        }
        if (latestVersion) {
            return dlFileEntry;
        }
        return null;
    }

    @Override
    public void deleteRepositoryFileEntries(long repositoryId) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = RepositoryUtil.getRepositoryEventTrigger(repositoryId);
        int total = this.dlFileEntryPersistence.countByRepositoryId(repositoryId);
        IntervalActionProcessor<Void> intervalActionProcessor = new IntervalActionProcessor<Void>(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List<DLFileEntry> dlFileEntries = this.dlFileEntryPersistence.findByRepositoryId(repositoryId, start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, new LiferayFileEntry(dlFileEntry));
                this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
            }
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    @Override
    public void deleteRepositoryFileEntries(long repositoryId, long folderId) throws PortalException {
        this.deleteRepositoryFileEntries(repositoryId, folderId, true);
    }

    @Override
    public void deleteRepositoryFileEntries(long repositoryId, long folderId, boolean includeTrashedEntries) throws PortalException {
        RepositoryEventTrigger repositoryEventTrigger = RepositoryUtil.getRepositoryEventTrigger(repositoryId);
        int total = this.dlFileEntryPersistence.countByR_F(repositoryId, folderId);
        IntervalActionProcessor<Void> intervalActionProcessor = new IntervalActionProcessor<Void>(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List<DLFileEntry> dlFileEntries = this.dlFileEntryPersistence.findByR_F(repositoryId, folderId, start, end);
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                if (includeTrashedEntries || !dlFileEntry.isInTrashExplicitly()) {
                    repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, new LiferayFileEntry(dlFileEntry));
                    this.dlFileEntryLocalService.deleteFileEntry(dlFileEntry);
                    continue;
                }
                intervalActionProcessor.incrementStart();
            }
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    @Override
    public DLFileEntry fetchFileEntry(long groupId, long folderId, String title) {
        return this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
    }

    @Override
    public DLFileEntry fetchFileEntry(String uuid, long groupId) {
        return this.dlFileEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    @Override
    public DLFileEntry fetchFileEntryByAnyImageId(long imageId) {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.fetchBySmallImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        fileEntry = this.dlFileEntryPersistence.fetchByLargeImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        fileEntry = this.dlFileEntryPersistence.fetchByCustom1ImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        fileEntry = this.dlFileEntryPersistence.fetchByCustom2ImageId_First(imageId, null);
        if (fileEntry != null) {
            return fileEntry;
        }
        return null;
    }

    @Override
    public DLFileEntry fetchFileEntryByFileName(long groupId, long folderId, String fileName) {
        return this.dlFileEntryPersistence.fetchByG_F_FN(groupId, folderId, fileName);
    }

    @Override
    public DLFileEntry fetchFileEntryByName(long groupId, long folderId, String name) {
        return this.dlFileEntryPersistence.fetchByG_F_N(groupId, folderId, name);
    }

    @Override
    public List<DLFileEntry> getDDMStructureFileEntries(long groupId, long[] ddmStructureIds) {
        return this.dlFileEntryFinder.findByDDMStructureIds(groupId, ddmStructureIds, -1, -1);
    }

    @Override
    public List<DLFileEntry> getDDMStructureFileEntries(long[] ddmStructureIds) {
        return this.dlFileEntryFinder.findByDDMStructureIds(ddmStructureIds, -1, -1);
    }

    @Override
    public List<DLFileEntry> getExtraSettingsFileEntries(int start, int end) {
        return this.dlFileEntryFinder.findByExtraSettings(start, end);
    }

    @Override
    public int getExtraSettingsFileEntriesCount() {
        return this.dlFileEntryFinder.countByExtraSettings();
    }

    @Override
    @Deprecated
    public File getFile(long userId, long fileEntryId, String version, boolean incrementCounter) throws PortalException {
        return this.getFile(fileEntryId, version, incrementCounter, 1);
    }

    @Override
    @Deprecated
    public File getFile(long userId, long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException {
        return this.getFile(fileEntryId, version, incrementCounter, increment);
    }

    @Override
    public File getFile(long fileEntryId, String version, boolean incrementCounter) throws PortalException {
        return this.getFile(fileEntryId, version, incrementCounter, 1);
    }

    @Override
    public File getFile(long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        if (incrementCounter) {
            this.dlFileEntryLocalService.incrementViewCounter(dlFileEntry, increment);
        }
        return DLStoreUtil.getFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), version);
    }

    @Override
    @Deprecated
    public InputStream getFileAsStream(long userId, long fileEntryId, String version) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, true, 1);
    }

    @Override
    @Deprecated
    public InputStream getFileAsStream(long userId, long fileEntryId, String version, boolean incrementCounter) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, incrementCounter, 1);
    }

    @Override
    @Deprecated
    public InputStream getFileAsStream(long userId, long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, incrementCounter, increment);
    }

    @Override
    public InputStream getFileAsStream(long fileEntryId, String version) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, true, 1);
    }

    @Override
    public InputStream getFileAsStream(long fileEntryId, String version, boolean incrementCounter) throws PortalException {
        return this.getFileAsStream(fileEntryId, version, incrementCounter, 1);
    }

    @Override
    public InputStream getFileAsStream(long fileEntryId, String version, boolean incrementCounter, int increment) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        if (incrementCounter) {
            this.dlFileEntryLocalService.incrementViewCounter(dlFileEntry, increment);
        }
        return DLStoreUtil.getFileAsStream(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), version);
    }

    @Override
    public List<DLFileEntry> getFileEntries(int start, int end) {
        return this.dlFileEntryPersistence.findAll(start, end);
    }

    @Override
    public List<DLFileEntry> getFileEntries(long groupId, long folderId) {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId);
    }

    @Override
    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<DLFileEntry> obc) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        QueryDefinition<DLFileEntry> queryDefinition = new QueryDefinition<DLFileEntry>(status, false, start, end, obc);
        return this.dlFileEntryFinder.findByG_F(groupId, folderIds, queryDefinition);
    }

    @Override
    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator<DLFileEntry> obc) {
        return this.dlFileEntryPersistence.findByG_F(groupId, folderId, start, end, obc);
    }

    @Override
    public List<DLFileEntry> getFileEntries(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.findByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition);
    }

    @Override
    public List<DLFileEntry> getFileEntries(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.findByG_U_F_M(groupId, userId, folderIds, mimeTypes, queryDefinition);
    }

    @Override
    public List<DLFileEntry> getFileEntries(long folderId, String name) {
        return this.dlFileEntryPersistence.findByF_N(folderId, name);
    }

    @Override
    public int getFileEntriesCount() {
        return this.dlFileEntryPersistence.countAll();
    }

    @Override
    @Deprecated
    public int getFileEntriesCount(long groupId, DateRange dateRange, long repositoryId, QueryDefinition<DLFileEntry> queryDefinition) {
        return 0;
    }

    @Override
    public int getFileEntriesCount(long groupId, long folderId) {
        return this.dlFileEntryPersistence.countByG_F(groupId, folderId);
    }

    @Override
    public int getFileEntriesCount(long groupId, long folderId, int status) {
        return this.dlFileEntryFinder.countByG_F(groupId, ListUtil.toList(folderId), new QueryDefinition<DLFileEntry>(status));
    }

    @Override
    public int getFileEntriesCount(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.countByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition);
    }

    @Override
    public int getFileEntriesCount(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.dlFileEntryFinder.countByG_U_F_M(groupId, userId, folderIds, mimeTypes, queryDefinition);
    }

    @Override
    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    @Override
    public DLFileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
        if (dlFileEntry != null) {
            return dlFileEntry;
        }
        List<DLFileVersion> dlFileVersions = this.dlFileVersionPersistence.findByG_F_T_V(groupId, folderId, title, "PWC");
        long userId = PrincipalThreadLocal.getUserId();
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            if (!this.hasFileEntryLock(userId, dlFileVersion.getFileEntryId(), dlFileVersion.getFolderId())) continue;
            return dlFileVersion.getFileEntry();
        }
        throw new NoSuchFileEntryException(StringBundler.concat("No DLFileEntry exists with the key {groupId=", groupId, ", folderId=", folderId, ", title=", title, "}"));
    }

    @Override
    public DLFileEntry getFileEntryByName(long groupId, long folderId, String name) throws PortalException {
        return this.dlFileEntryPersistence.findByG_F_N(groupId, folderId, name);
    }

    @Override
    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
    }

    @Override
    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end) {
        return this.getGroupFileEntries(groupId, start, end, new RepositoryModelModifiedDateComparator<DLFileEntry>());
    }

    @Override
    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end, OrderByComparator<DLFileEntry> obc) {
        return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    @Override
    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) {
        return this.getGroupFileEntries(groupId, userId, start, end, new RepositoryModelModifiedDateComparator<DLFileEntry>());
    }

    @Override
    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator<DLFileEntry> obc) {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.dlFileEntryPersistence.findByG_U(groupId, userId, start, end, obc);
    }

    @Override
    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<DLFileEntry> obc) {
        return this.getGroupFileEntries(groupId, userId, 0L, rootFolderId, start, end, obc);
    }

    @Override
    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long repositoryId, long rootFolderId, int start, int end, OrderByComparator<DLFileEntry> obc) {
        List<Long> folderIds = repositoryId != 0L ? this.dlFolderLocalService.getRepositoryFolderIds(repositoryId, rootFolderId) : this.dlFolderLocalService.getGroupFolderIds(groupId, rootFolderId);
        if (folderIds.isEmpty()) {
            return Collections.emptyList();
        }
        QueryDefinition<DLFileEntry> queryDefinition = new QueryDefinition<DLFileEntry>(-1, start, end, obc);
        if (repositoryId == 0L) {
            if (userId <= 0L) {
                return this.dlFileEntryFinder.findByG_F(groupId, folderIds, queryDefinition);
            }
            return this.dlFileEntryFinder.findByG_U_F(groupId, userId, folderIds, queryDefinition);
        }
        ArrayList<Long> repositoryIds = new ArrayList<Long>();
        repositoryIds.add(repositoryId);
        if (userId <= 0L) {
            return this.dlFileEntryFinder.findByG_R_F(groupId, repositoryIds, folderIds, queryDefinition);
        }
        return this.dlFileEntryFinder.findByG_U_R_F(groupId, userId, repositoryIds, folderIds, queryDefinition);
    }

    @Override
    public int getGroupFileEntriesCount(long groupId) {
        return this.dlFileEntryPersistence.countByGroupId(groupId);
    }

    @Override
    public int getGroupFileEntriesCount(long groupId, long userId) {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.countByGroupId(groupId);
        }
        return this.dlFileEntryPersistence.countByG_U(groupId, userId);
    }

    @Override
    @Deprecated
    public List<DLFileEntry> getMisversionedFileEntries() {
        return this.dlFileEntryFinder.findByMisversioned();
    }

    @Override
    public List<DLFileEntry> getNoAssetFileEntries() {
        return this.dlFileEntryFinder.findByNoAssets();
    }

    @Override
    @Deprecated
    public List<DLFileEntry> getOrphanedFileEntries() {
        return this.dlFileEntryFinder.findByOrphanedFileEntries();
    }

    @Override
    public List<DLFileEntry> getRepositoryFileEntries(long repositoryId, int start, int end) {
        return this.dlFileEntryPersistence.findByRepositoryId(repositoryId, start, end);
    }

    @Override
    public int getRepositoryFileEntriesCount(long repositoryId) {
        return this.dlFileEntryPersistence.countByRepositoryId(repositoryId);
    }

    @Override
    public String getUniqueTitle(long groupId, long folderId, long fileEntryId, String title, String extension) throws PortalException {
        String uniqueTitle = title;
        int i = 1;
        while (true) {
            String uniqueFileName = DLUtil.getSanitizedFileName(uniqueTitle, extension);
            try {
                this.validateFile(groupId, folderId, fileEntryId, uniqueFileName, uniqueTitle);
                return uniqueTitle;
            }
            catch (DuplicateFileEntryException | DuplicateFolderNameException e) {
                if (_log.isDebugEnabled()) {
                    _log.debug(e, e);
                }
                uniqueTitle = FileUtil.appendParentheticalSuffix(title, String.valueOf(i));
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public boolean hasExtraSettings() {
        return this.dlFileEntryFinder.countByExtraSettings() > 0;
    }

    @Override
    public boolean hasFileEntryLock(long userId, long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        return this.hasFileEntryLock(userId, fileEntryId, dlFileEntry.getFolderId());
    }

    @Override
    public boolean hasFileEntryLock(long userId, long fileEntryId, long folderId) {
        boolean hasLock = LockManagerUtil.hasLock(userId, DLFileEntry.class.getName(), fileEntryId);
        if (hasLock || folderId == 0L) {
            return hasLock;
        }
        return this.dlFolderLocalService.hasInheritableLock(folderId);
    }

    @Override
    @BufferedIncrement(configuration="DLFileEntry", incrementClass=NumberIncrement.class)
    public void incrementViewCounter(DLFileEntry dlFileEntry, int increment) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        if ((dlFileEntry = this.dlFileEntryPersistence.fetchByPrimaryKey(dlFileEntry.getFileEntryId())) == null) {
            return;
        }
        dlFileEntry.setModifiedDate(dlFileEntry.getModifiedDate());
        dlFileEntry.setReadCount(dlFileEntry.getReadCount() + increment);
        this.dlFileEntryPersistence.update(dlFileEntry);
    }

    @Override
    public boolean isFileEntryCheckedOut(long fileEntryId) {
        return this.dlFileVersionPersistence.countByF_V(fileEntryId, "PWC") > 0;
    }

    @Override
    @Deprecated
    public boolean isKeepFileVersionLabel(long fileEntryId, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        DLFileVersion lastDLFileVersion = this.dlFileVersionLocalService.getFileVersion(dlFileEntry.getFileEntryId(), dlFileEntry.getVersion());
        DLFileVersion latestDLFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        return this.dlFileVersionPolicy.isKeepFileVersionLabel(lastDLFileVersion, latestDLFileVersion, majorVersion, serviceContext);
    }

    @Override
    @Deprecated
    public boolean isKeepFileVersionLabel(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this.isKeepFileVersionLabel(fileEntryId, false, serviceContext);
    }

    @Override
    public Lock lockFileEntry(long userId, long fileEntryId) throws PortalException {
        return LockManagerUtil.lock(userId, DLFileEntry.class.getName(), fileEntryId, null, false, DLFileEntryImpl.LOCK_EXPIRATION_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Indexable(type=IndexableType.REINDEX)
    public DLFileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (!this.hasFileEntryLock(userId, fileEntryId)) {
            this.lockFileEntry(userId, fileEntryId);
        }
        try {
            DLFileEntry dlFileEntry = this.moveFileEntryImpl(userId, fileEntryId, newFolderId, serviceContext);
            DLFileEntry dLFileEntry = this.dlFileEntryTypeLocalService.updateFileEntryFileEntryType(dlFileEntry, serviceContext);
            return dLFileEntry;
        }
        finally {
            if (!this.isFileEntryCheckedOut(fileEntryId)) {
                this.unlockFileEntry(fileEntryId);
            }
        }
    }

    @Override
    public void rebuildTree(long companyId) throws PortalException {
        this.dlFolderLocalService.rebuildTree(companyId);
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        if (!this._isValidFileVersionNumber(version)) {
            throw new InvalidFileVersionException(StringBundler.concat("Unable to revert file entry ", fileEntryId, " to version ", version, " because it is invalid"));
        }
        if (version.equals("PWC")) {
            throw new InvalidFileVersionException("Unable to revert a private working copy file version");
        }
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileEntryId, version);
        if (!dlFileVersion.isApproved()) {
            throw new InvalidFileVersionException("Unable to revert from an unapproved file version");
        }
        DLFileVersion latestDLFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        if (version.equals(latestDLFileVersion.getVersion())) {
            throw new InvalidFileVersionException("Unable to revert from the latest file version");
        }
        String sourceFileName = dlFileVersion.getTitle();
        String extension = dlFileVersion.getExtension();
        String mimeType = dlFileVersion.getMimeType();
        String title = dlFileVersion.getTitle();
        String description = dlFileVersion.getDescription();
        String changeLog = LanguageUtil.format(serviceContext.getLocale(), "reverted-to-x", (Object)version, false);
        DLVersionNumberIncrease dlVersionNumberIncrease = DLVersionNumberIncrease.MAJOR;
        String extraSettings = dlFileVersion.getExtraSettings();
        Map<String, DDMFormValues> ddmFormValuesMap = null;
        InputStream is = this.getFileAsStream(fileEntryId, version, false);
        long size = dlFileVersion.getSize();
        serviceContext.setCommand("revert");
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        long fileEntryTypeId = this.getValidFileEntryTypeId(dlFileVersion.getFileEntryTypeId(), dlFileEntry);
        this.updateFileEntry(userId, fileEntryId, sourceFileName, extension, mimeType, title, description, changeLog, dlVersionNumberIncrease, extraSettings, fileEntryTypeId, ddmFormValuesMap, null, is, size, serviceContext);
        DLFileVersion newDLFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        this.copyFileEntryMetadata(dlFileVersion.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, dlFileVersion.getFileVersionId(), newDLFileVersion.getFileVersionId(), serviceContext);
    }

    @Override
    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.search(groupId, userId, creatorUserId, 0L, null, status, start, end);
    }

    @Override
    public Hits search(long groupId, long userId, long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer(DLFileEntryConstants.getClassName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", Integer.valueOf(status));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        if (ArrayUtil.isNotEmpty(mimeTypes)) {
            searchContext.setAttribute("mimeTypes", (Serializable)mimeTypes);
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setFolderIds(new long[]{folderId});
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort("modified", true));
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    @Override
    public void setTreePaths(long folderId, String treePath, boolean reindex) throws PortalException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property folderIdProperty = PropertyFactoryUtil.forName("folderId");
            dynamicQuery.add(folderIdProperty.eq(folderId));
            Property treePathProperty = PropertyFactoryUtil.forName("treePath");
            dynamicQuery.add(RestrictionsFactoryUtil.or(treePathProperty.isNull(), treePathProperty.ne(treePath)));
        });
        Indexer indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class.getName());
        indexableActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
            dlFileEntry.setTreePath(treePath);
            this.updateDLFileEntry((DLFileEntry)dlFileEntry);
            if (!reindex) {
                return;
            }
            Document document = indexer.getDocument(dlFileEntry);
            indexableActionableDynamicQuery.addDocuments(document);
        });
        indexableActionableDynamicQuery.performActions();
    }

    @Override
    public void unlockFileEntry(long fileEntryId) {
        LockManagerUtil.unlock(DLFileEntry.class.getName(), fileEntryId);
    }

    @Override
    @Deprecated
    public DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion(majorVersion), fileEntryTypeId, ddmFormValuesMap, file, is, size, serviceContext);
    }

    @Override
    public DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        String extension = DLAppUtil.getExtension(title, sourceFileName);
        if (file == null && is == null) {
            extension = dlFileEntry.getExtension();
            mimeType = dlFileEntry.getMimeType();
        }
        String extraSettings = "";
        if (fileEntryTypeId == -1L) {
            fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        }
        this.validateFileEntryTypeId(PortalUtil.getCurrentAndAncestorSiteGroupIds(dlFileEntry.getGroupId()), dlFileEntry.getFolderId(), fileEntryTypeId);
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, extension, mimeType, title, description, changeLog, dlVersionNumberIncrease, extraSettings, fileEntryTypeId, ddmFormValuesMap, file, is, size, serviceContext);
    }

    @Override
    public DLFileEntry updateFileEntryType(long userId, long fileEntryId, long fileEntryTypeId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
        this.dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, !dlFileEntry.isCheckedOut());
        dlFileVersion.setUserId(user.getUserId());
        dlFileVersion.setUserName(user.getFullName());
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        this.dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
        return dlFileEntry;
    }

    @Override
    public void updateSmallImage(long smallImageId, long largeImageId) throws PortalException {
        try {
            Image largeImage = this.imageLocalService.getImage(largeImageId);
            byte[] bytes = largeImage.getTextObj();
            if (bytes == null) {
                return;
            }
            ImageBag imageBag = ImageToolUtil.read(bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            if (renderedImage == null) {
                return;
            }
            int height = PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.height");
            int width = PrefsPropsUtil.getInteger("dl.file.entry.thumbnail.max.width");
            RenderedImage thumbnailRenderedImage = ImageToolUtil.scale(renderedImage, height, width);
            this.imageLocalService.updateImage(smallImageId, ImageToolUtil.getBytes(thumbnailRenderedImage, largeImage.getType()));
        }
        catch (IOException ioe) {
            throw new ImageSizeException(StringBundler.concat("Unable to update small image with smallImageId ", smallImageId, ", largeImageId ", largeImageId), ioe);
        }
    }

    @Override
    public DLFileEntry updateStatus(long userId, long fileVersionId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileVersion dlFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
        int oldStatus = dlFileVersion.getStatus();
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(new Date());
        this.dlFileVersionPersistence.update(dlFileVersion);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(dlFileVersion.getFileEntryId());
        if (status == 0) {
            if (DLUtil.compareVersions(dlFileEntry.getVersion(), dlFileVersion.getVersion()) <= 0) {
                dlFileEntry.setModifiedDate(dlFileVersion.getModifiedDate());
                dlFileEntry.setFileName(dlFileVersion.getFileName());
                dlFileEntry.setExtension(dlFileVersion.getExtension());
                dlFileEntry.setMimeType(dlFileVersion.getMimeType());
                dlFileEntry.setTitle(dlFileVersion.getTitle());
                dlFileEntry.setDescription(dlFileVersion.getDescription());
                dlFileEntry.setExtraSettings(dlFileVersion.getExtraSettings());
                dlFileEntry.setFileEntryTypeId(dlFileVersion.getFileEntryTypeId());
                dlFileEntry.setVersion(dlFileVersion.getVersion());
                dlFileEntry.setSize(dlFileVersion.getSize());
                this.dlFileEntryPersistence.update(dlFileEntry);
            }
        } else {
            if (status != 8 && Objects.equals(dlFileEntry.getVersion(), dlFileVersion.getVersion())) {
                String newVersion = "1.0";
                List<DLFileVersion> approvedFileVersions = this.dlFileVersionPersistence.findByF_S(dlFileEntry.getFileEntryId(), 0);
                if (!approvedFileVersions.isEmpty()) {
                    DLFileVersion firstApprovedFileVersion = approvedFileVersions.get(0);
                    newVersion = firstApprovedFileVersion.getVersion();
                }
                dlFileEntry.setVersion(newVersion);
                this.dlFileEntryPersistence.update(dlFileEntry);
            }
            if (Objects.equals(dlFileVersion.getVersion(), "1.0")) {
                Indexer<DLFileEntry> indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                indexer.delete(dlFileEntry);
            }
        }
        this.dlAppHelperLocalService.updateStatus(userId, new LiferayFileEntry(dlFileEntry), new LiferayFileVersion(dlFileVersion), oldStatus, status, serviceContext, workflowContext);
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            if (status == 8) {
                CommentManagerUtil.moveDiscussionToTrash(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            } else if (oldStatus == 8) {
                CommentManagerUtil.restoreDiscussionFromTrash(DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
            }
        }
        if (!(status != 0 && status != 8 && oldStatus != 8 || serviceContext != null && !serviceContext.isIndexingEnabled())) {
            this.reindex(dlFileEntry);
        }
        return dlFileEntry;
    }

    @Override
    public void validateFile(long groupId, long folderId, long fileEntryId, String fileName, String title) throws PortalException {
        DLFolder parentDLFolder;
        if (folderId != 0L && groupId != (parentDLFolder = this.dlFolderPersistence.findByPrimaryKey(folderId)).getGroupId()) {
            throw new NoSuchFolderException();
        }
        DLFolder dlFolder = this.dlFolderPersistence.fetchByG_P_N(groupId, folderId, title);
        if (dlFolder != null) {
            throw new DuplicateFolderNameException("A folder already exists with name " + title);
        }
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_T(groupId, folderId, title);
        if (dlFileEntry != null && dlFileEntry.getFileEntryId() != fileEntryId) {
            throw new DuplicateFileEntryException("A file entry already exists with title " + title);
        }
        dlFileEntry = this.dlFileEntryPersistence.fetchByG_F_FN(groupId, folderId, fileName);
        if (dlFileEntry != null && dlFileEntry.getFileEntryId() != fileEntryId) {
            throw new DuplicateFileEntryException("A file entry already exists with file name " + title);
        }
    }

    @Override
    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this.verifyFileEntryLock(fileEntryId, lockUuid) && this.isFileEntryCheckedOut(fileEntryId);
    }

    @Override
    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        Lock lock = LockManagerUtil.fetchLock(DLFileEntry.class.getName(), fileEntryId);
        if (lock != null) {
            return Objects.equals(lock.getUuid(), lockUuid);
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        return this.dlFolderLocalService.verifyInheritableLock(dlFileEntry.getFolderId(), lockUuid);
    }

    protected void addFileEntryResources(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException {
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.resourceLocalService.addResources(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(dlFileEntry.getRepositoryId(), DLFileEntryConstants.getClassName());
            }
            this.resourceLocalService.addModelResources(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), serviceContext.getModelPermissions());
        }
    }

    protected DLFileVersion addFileVersion(User user, DLFileEntry dlFileEntry, String fileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, String version, long size, int status, ServiceContext serviceContext) throws PortalException {
        long fileVersionId = this.counterLocalService.increment();
        DLFileVersion dlFileVersion = this.dlFileVersionPersistence.create(fileVersionId);
        String uuid = ParamUtil.getString(serviceContext, "fileVersionUuid", serviceContext.getUuid());
        dlFileVersion.setUuid(uuid);
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        dlFileVersion.setUserId(user.getUserId());
        dlFileVersion.setUserName(user.getFullName());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setTreePath(dlFileVersion.buildTreePath());
        dlFileVersion.setFileName(fileName);
        dlFileVersion.setExtension(extension);
        dlFileVersion.setMimeType(mimeType);
        dlFileVersion.setTitle(title);
        dlFileVersion.setDescription(description);
        dlFileVersion.setChangeLog(changeLog);
        dlFileVersion.setExtraSettings(extraSettings);
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        dlFileVersion.setVersion(version);
        dlFileVersion.setSize(size);
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(dlFileEntry.getModifiedDate());
        ExpandoBridge oldExpandoBridge = dlFileVersion.getExpandoBridge();
        DLFileVersion latestFileVersion = this.dlFileVersionLocalService.fetchLatestFileVersion(dlFileEntry.getFileEntryId(), false);
        if (latestFileVersion != null) {
            oldExpandoBridge = latestFileVersion.getExpandoBridge();
        }
        ExpandoBridgeUtil.setExpandoBridgeAttributes(oldExpandoBridge, dlFileVersion.getExpandoBridge(), serviceContext);
        this.dlFileVersionPersistence.update(dlFileVersion);
        if (fileEntryTypeId > 0L && ddmFormValuesMap != null) {
            this.dlFileEntryMetadataLocalService.updateFileEntryMetadata(fileEntryTypeId, dlFileEntry.getFileEntryId(), fileVersionId, ddmFormValuesMap, serviceContext);
        }
        return dlFileVersion;
    }

    protected void convertExtraSettings(DLFileEntry dlFileEntry, DLFileVersion dlFileVersion, String[] keys) throws PortalException {
        UnicodeProperties extraSettingsProperties = dlFileVersion.getExtraSettingsProperties();
        ExpandoBridge expandoBridge = dlFileVersion.getExpandoBridge();
        this.convertExtraSettings(extraSettingsProperties, expandoBridge, keys);
        dlFileVersion.setExtraSettingsProperties(extraSettingsProperties);
        this.dlFileVersionPersistence.update(dlFileVersion);
        int status = dlFileVersion.getStatus();
        if (status == 0 && DLUtil.compareVersions(dlFileEntry.getVersion(), dlFileVersion.getVersion()) <= 0) {
            this.reindex(dlFileEntry);
        }
    }

    protected void convertExtraSettings(DLFileEntry dlFileEntry, String[] keys) throws PortalException {
        UnicodeProperties extraSettingsProperties = dlFileEntry.getExtraSettingsProperties();
        ExpandoBridge expandoBridge = dlFileEntry.getExpandoBridge();
        this.convertExtraSettings(extraSettingsProperties, expandoBridge, keys);
        dlFileEntry.setExtraSettingsProperties(extraSettingsProperties);
        this.dlFileEntryPersistence.update(dlFileEntry);
        List<DLFileVersion> dlFileVersions = this.dlFileVersionLocalService.getFileVersions(dlFileEntry.getFileEntryId(), -1);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            this.convertExtraSettings(dlFileEntry, dlFileVersion, keys);
        }
    }

    protected void convertExtraSettings(UnicodeProperties extraSettingsProperties, ExpandoBridge expandoBridge, String[] keys) {
        for (String key : keys) {
            String value = extraSettingsProperties.remove(key);
            if (Validator.isNull(value)) continue;
            int type = expandoBridge.getAttributeType(key);
            Serializable serializable = ExpandoColumnConstants.getSerializable(type, value);
            expandoBridge.setAttribute(key, serializable);
        }
    }

    protected void copyExpandoRowModifiedDate(long companyId, long sourceFileVersionId, long destinationFileVersionId) {
        ExpandoTable expandoTable = this.expandoTableLocalService.fetchDefaultTable(companyId, DLFileEntry.class.getName());
        if (expandoTable == null) {
            return;
        }
        ExpandoRow sourceExpandoRow = this.expandoRowLocalService.fetchRow(expandoTable.getTableId(), sourceFileVersionId);
        if (sourceExpandoRow == null) {
            return;
        }
        ExpandoRow destinationExpandoRow = this.expandoRowLocalService.fetchRow(expandoTable.getTableId(), destinationFileVersionId);
        if (destinationExpandoRow == null) {
            return;
        }
        destinationExpandoRow.setModifiedDate(sourceExpandoRow.getModifiedDate());
        this.expandoRowLocalService.updateExpandoRow(destinationExpandoRow);
    }

    protected void copyFileEntryMetadata(long companyId, long fileEntryId, long fromFileVersionId, long toFileVersionId, ServiceContext serviceContext, Map<String, DDMFormValues> ddmFormValuesMap, List<DDMStructure> ddmStructures) throws PortalException {
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = this.dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), fromFileVersionId);
            if (dlFileEntryMetadata == null) continue;
            DDMFormValues ddmFormValues = StorageEngineManagerUtil.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
            ddmFormValuesMap.put(ddmStructure.getStructureKey(), ddmFormValues);
        }
        if (!ddmFormValuesMap.isEmpty()) {
            this.dlFileEntryMetadataLocalService.updateFileEntryMetadata(companyId, ddmStructures, fileEntryId, toFileVersionId, ddmFormValuesMap, serviceContext);
        }
    }

    protected RepositoryEventTrigger getFolderRepositoryEventTrigger(long groupId, long folderId) throws PortalException {
        if (folderId != 0L) {
            return RepositoryUtil.getFolderRepositoryEventTrigger(folderId);
        }
        return RepositoryUtil.getRepositoryEventTrigger(groupId);
    }

    protected String getNextVersion(DLFileEntry dlFileEntry, DLVersionNumberIncrease dlVersionNumberIncrease) throws InvalidFileVersionException {
        String version = dlFileEntry.getVersion();
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.fetchLatestFileVersion(dlFileEntry.getFileEntryId(), true);
        if (dlFileVersion != null) {
            version = dlFileVersion.getVersion();
        }
        if (!this._isValidFileVersionNumber(version)) {
            throw new InvalidFileVersionException(StringBundler.concat("Unable to increase version number for file entry ", dlFileEntry.getFileEntryId(), " because original version number ", version, " is invalid"));
        }
        int[] versionParts = StringUtil.split(version, ".", 0);
        if (dlVersionNumberIncrease == DLVersionNumberIncrease.MAJOR) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected long getValidFileEntryTypeId(long fileEntryTypeId, DLFileEntry dlFileEntry) throws PortalException {
        try {
            this.validateFileEntryTypeId(PortalUtil.getCurrentAndAncestorSiteGroupIds(dlFileEntry.getGroupId()), dlFileEntry.getFolderId(), fileEntryTypeId);
            return fileEntryTypeId;
        }
        catch (InvalidFileEntryTypeException ifete) {
            if (_log.isDebugEnabled()) {
                _log.debug(ifete, ifete);
            }
            return this.dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(dlFileEntry.getFolderId());
        }
    }

    protected DLFileEntry moveFileEntryImpl(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        long oldDataRepositoryId = dlFileEntry.getDataRepositoryId();
        this.validateFile(dlFileEntry.getGroupId(), newFolderId, dlFileEntry.getFileEntryId(), dlFileEntry.getFileName(), dlFileEntry.getTitle());
        dlFileEntry.setFolderId(newFolderId);
        dlFileEntry.setTreePath(dlFileEntry.buildTreePath());
        this.dlFileEntryPersistence.update(dlFileEntry);
        List<DLFileVersion> dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            dlFileVersion.setFolderId(newFolderId);
            dlFileVersion.setTreePath(dlFileVersion.buildTreePath());
            dlFileVersion.setStatusByUserId(userId);
            dlFileVersion.setStatusByUserName(user.getFullName());
            this.dlFileVersionPersistence.update(dlFileVersion);
        }
        this.dlFolderLocalService.updateLastPostDate(newFolderId, serviceContext.getModifiedDate(null));
        DLStoreUtil.updateFile(user.getCompanyId(), oldDataRepositoryId, dlFileEntry.getDataRepositoryId(), dlFileEntry.getName());
        return dlFileEntry;
    }

    protected void reindex(DLFileEntry dlFileEntry) throws SearchException {
        Indexer<DLFileEntry> indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        indexer.reindex(dlFileEntry);
    }

    protected void removeFileVersion(DLFileEntry dlFileEntry, DLFileVersion dlFileVersion) throws PortalException {
        this.dlFileVersionPersistence.remove(dlFileVersion);
        this.expandoRowLocalService.deleteRows(dlFileVersion.getFileVersionId());
        this.dlFileEntryMetadataLocalService.deleteFileVersionFileEntryMetadata(dlFileVersion.getFileVersionId());
        this.assetEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), dlFileVersion.getPrimaryKey());
        DLStoreUtil.deleteFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), "PWC");
        this.unlockFileEntry(dlFileEntry.getFileEntryId());
    }

    protected DLFileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String extension, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, String extraSettings, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean checkedOut = dlFileEntry.isCheckedOut();
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, !checkedOut);
        boolean autoCheckIn = false;
        if (!checkedOut && dlFileVersion.isApproved() && !Objects.equals(dlFileVersion.getUuid(), serviceContext.getUuidWithoutReset())) {
            autoCheckIn = true;
        }
        if (autoCheckIn) {
            dlFileEntry = file != null || is != null ? this._checkOutDLFileEntryModel(userId, fileEntryId, fileEntryTypeId, serviceContext) : this.checkOutFileEntry(userId, fileEntryId, fileEntryTypeId, serviceContext);
        }
        if (!this.hasFileEntryLock(userId, fileEntryId, dlFileEntry.getFolderId())) {
            this.lockFileEntry(userId, fileEntryId);
        }
        if (checkedOut || autoCheckIn) {
            dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        }
        try {
            if (Validator.isNull(extension)) {
                extension = dlFileEntry.getExtension();
            }
            if (Validator.isNull(mimeType)) {
                mimeType = dlFileEntry.getMimeType();
            }
            if (Validator.isNull(title) && Validator.isNull(title = sourceFileName)) {
                title = dlFileEntry.getTitle();
            }
            String fileName = DLUtil.getSanitizedFileName(title, extension);
            Date now = new Date();
            this.validateFile(dlFileEntry.getGroupId(), dlFileEntry.getFolderId(), dlFileEntry.getFileEntryId(), sourceFileName, fileName, extension, title);
            String version = dlFileVersion.getVersion();
            if (size == 0L) {
                size = dlFileVersion.getSize();
            }
            this.updateFileVersion(user, dlFileVersion, sourceFileName, fileName, extension, mimeType, title, description, changeLog, extraSettings, fileEntryTypeId, ddmFormValuesMap, version, size, dlFileVersion.getStatus(), serviceContext.getModifiedDate(now), serviceContext);
            if (!checkedOut && dlFileEntry.getFolderId() != 0L) {
                this.dlFolderLocalService.updateLastPostDate(dlFileEntry.getFolderId(), serviceContext.getModifiedDate(now));
            }
            if (file != null || is != null) {
                DLStoreUtil.deleteFile(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), version);
                if (file != null) {
                    DLStoreUtil.updateFile(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), dlFileEntry.getExtension(), false, version, sourceFileName, file);
                } else {
                    DLStoreUtil.updateFile(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), dlFileEntry.getExtension(), false, version, sourceFileName, is);
                }
            }
            if (autoCheckIn) {
                this.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
            }
        }
        catch (PortalException | SystemException e) {
            if (autoCheckIn) {
                try {
                    this.cancelCheckOut(userId, fileEntryId);
                }
                catch (Exception e2) {
                    _log.error(e2, e2);
                }
            }
            throw e;
        }
        finally {
            if (!autoCheckIn && !checkedOut) {
                this.unlockFileEntry(fileEntryId);
            }
        }
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    protected DLFileVersion updateFileVersion(User user, DLFileVersion dlFileVersion, String sourceFileName, String fileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, Map<String, DDMFormValues> ddmFormValuesMap, String version, long size, int status, Date statusDate, ServiceContext serviceContext) throws PortalException {
        dlFileVersion.setUserId(user.getUserId());
        dlFileVersion.setUserName(user.getFullName());
        dlFileVersion.setModifiedDate(statusDate);
        dlFileVersion.setFileName(fileName);
        if (Validator.isNotNull(sourceFileName)) {
            dlFileVersion.setExtension(extension);
            dlFileVersion.setMimeType(mimeType);
        }
        dlFileVersion.setTitle(title);
        dlFileVersion.setDescription(description);
        dlFileVersion.setChangeLog(changeLog);
        dlFileVersion.setExtraSettings(extraSettings);
        dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
        dlFileVersion.setVersion(version);
        dlFileVersion.setSize(size);
        dlFileVersion.setStatus(status);
        dlFileVersion.setStatusByUserId(user.getUserId());
        dlFileVersion.setStatusByUserName(user.getFullName());
        dlFileVersion.setStatusDate(statusDate);
        ExpandoBridgeUtil.setExpandoBridgeAttributes(dlFileVersion.getExpandoBridge(), dlFileVersion.getExpandoBridge(), serviceContext);
        dlFileVersion = this.dlFileVersionPersistence.update(dlFileVersion);
        if (fileEntryTypeId > 0L && ddmFormValuesMap != null) {
            this.dlFileEntryMetadataLocalService.updateFileEntryMetadata(fileEntryTypeId, dlFileVersion.getFileEntryId(), dlFileVersion.getFileVersionId(), ddmFormValuesMap, serviceContext);
        }
        return dlFileVersion;
    }

    protected void validateFile(long groupId, long folderId, long fileEntryId, String sourceFileName, String fileName, String extension, String title) throws PortalException {
        DLValidatorUtil.validateFileName(title);
        this.validateFileExtension(fileName, extension);
        this.validateFile(groupId, folderId, fileEntryId, fileName, title);
    }

    protected void validateFileEntryTypeId(long[] groupIds, long folderId, long fileEntryTypeId) throws PortalException {
        List<DLFileEntryType> dlFileEntryTypes = this.dlFileEntryTypeLocalService.getFolderFileEntryTypes(groupIds, folderId, true);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() != fileEntryTypeId) continue;
            return;
        }
        throw new InvalidFileEntryTypeException(StringBundler.concat("Invalid file entry type ", fileEntryTypeId, " for folder ", folderId));
    }

    @Deprecated
    protected void validateFileExtension(String extension) throws PortalException {
        if (Validator.isNull(extension)) {
            return;
        }
        int maxLength = ModelHintsUtil.getMaxLength(DLFileEntry.class.getName(), "extension");
        if (extension.length() > maxLength) {
            throw new FileExtensionException(extension + " exceeds max length of " + maxLength);
        }
    }

    protected void validateFileExtension(String fileName, String extension) throws PortalException {
        if (Validator.isNull(extension)) {
            return;
        }
        int maxLength = ModelHintsUtil.getMaxLength(DLFileEntry.class.getName(), "extension");
        if (extension.length() > maxLength) {
            throw new FileExtensionException(StringBundler.concat(extension, " of file ", fileName, " exceeds max length of ", maxLength));
        }
    }

    private DLFileEntry _checkOutDLFileEntryModel(long userId, long fileEntryId, long fileEntryTypeId, ServiceContext serviceContext) throws PortalException {
        return this._checkOutDLFileEntryModel(userId, fileEntryId, fileEntryTypeId, "", DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    private DLFileEntry _checkOutDLFileEntryModel(long userId, long fileEntryId, long fileEntryTypeId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        String version;
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        boolean hasLock = this.hasFileEntryLock(userId, fileEntryId, dlFileEntry.getFolderId());
        if (!hasLock) {
            if (expirationTime <= 0L || expirationTime > DLFileEntryImpl.LOCK_EXPIRATION_TIME) {
                expirationTime = DLFileEntryImpl.LOCK_EXPIRATION_TIME;
            }
            LockManagerUtil.lock(userId, DLFileEntry.class.getName(), fileEntryId, owner, false, expirationTime);
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        serviceContext.setCompanyId(user.getCompanyId());
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(fileEntryId, false);
        serviceContext.setUserId(userId);
        boolean manualCheckinRequired = GetterUtil.getBoolean(serviceContext.getAttribute("manualCheckInRequired"));
        if (dlFileEntry.isManualCheckInRequired() ^ manualCheckinRequired) {
            dlFileEntry.setManualCheckInRequired(manualCheckinRequired);
            this.dlFileEntryPersistence.update(dlFileEntry);
        }
        if (!(version = dlFileVersion.getVersion()).equals("PWC")) {
            DLFileVersion oldDLFileVersion = dlFileVersion;
            long oldDLFileVersionId = dlFileVersion.getFileVersionId();
            long existingDLFileVersionId = ParamUtil.getLong(serviceContext, "existingDLFileVersionId");
            if (existingDLFileVersionId > 0L) {
                DLFileVersion existingDLFileVersion = this.dlFileVersionPersistence.findByPrimaryKey(existingDLFileVersionId);
                dlFileVersion = this.updateFileVersion(user, existingDLFileVersion, null, existingDLFileVersion.getFileName(), existingDLFileVersion.getExtension(), existingDLFileVersion.getMimeType(), existingDLFileVersion.getTitle(), existingDLFileVersion.getDescription(), existingDLFileVersion.getChangeLog(), existingDLFileVersion.getExtraSettings(), existingDLFileVersion.getFileEntryTypeId(), null, "PWC", existingDLFileVersion.getSize(), 2, serviceContext.getModifiedDate(null), serviceContext);
            } else {
                dlFileVersion = this.addFileVersion(user, dlFileEntry, oldDLFileVersion.getFileName(), oldDLFileVersion.getExtension(), oldDLFileVersion.getMimeType(), oldDLFileVersion.getTitle(), oldDLFileVersion.getDescription(), oldDLFileVersion.getChangeLog(), oldDLFileVersion.getExtraSettings(), oldDLFileVersion.getFileEntryTypeId(), null, "PWC", oldDLFileVersion.getSize(), 2, serviceContext);
                this.copyExpandoRowModifiedDate(dlFileEntry.getCompanyId(), oldDLFileVersionId, dlFileVersion.getFileVersionId());
            }
            Serializable validateDDMFormValues = serviceContext.getAttribute("validateDDMFormValues");
            serviceContext.setAttribute("validateDDMFormValues", Boolean.FALSE);
            if (fileEntryTypeId == oldDLFileVersion.getFileEntryTypeId()) {
                this.copyFileEntryMetadata(dlFileEntry.getCompanyId(), fileEntryTypeId, fileEntryId, oldDLFileVersionId, dlFileVersion.getFileVersionId(), serviceContext);
            }
            serviceContext.setAttribute("validateDDMFormValues", validateDDMFormValues);
        }
        return dlFileEntry;
    }

    private DLVersionNumberIncrease _computeDLVersionNumberIncrease(DLVersionNumberIncrease dlVersionNumberIncrease, DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion, int workflowAction) {
        if (workflowAction == 2) {
            return DLVersionNumberIncrease.MINOR;
        }
        VersioningStrategy versioningStrategy = _versioningStrategy;
        if (versioningStrategy == null) {
            if (dlVersionNumberIncrease == null || dlVersionNumberIncrease == DLVersionNumberIncrease.AUTOMATIC) {
                return DLVersionNumberIncrease.NONE;
            }
            return dlVersionNumberIncrease;
        }
        if (versioningStrategy.isOverridable() && dlVersionNumberIncrease != null && dlVersionNumberIncrease != DLVersionNumberIncrease.AUTOMATIC) {
            return dlVersionNumberIncrease;
        }
        return versioningStrategy.computeDLVersionNumberIncrease(previousDLFileVersion, nextDLFileVersion);
    }

    private boolean _isValidFileVersionNumber(String version) {
        if (Validator.isNull(version)) {
            return false;
        }
        if (version.equals("PWC")) {
            return true;
        }
        Matcher matcher = _fileVersionPattern.matcher(version);
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _overwritePreviousFileVersion(User user, DLFileEntry dlFileEntry, DLFileVersion latestDLFileVersion, DLFileVersion lastDLFileVersion, ServiceContext serviceContext) throws PortalException {
        dlFileEntry.setModifiedDate(latestDLFileVersion.getModifiedDate());
        dlFileEntry.setFileName(latestDLFileVersion.getFileName());
        dlFileEntry.setExtension(latestDLFileVersion.getExtension());
        dlFileEntry.setMimeType(latestDLFileVersion.getMimeType());
        dlFileEntry.setTitle(latestDLFileVersion.getTitle());
        dlFileEntry.setDescription(latestDLFileVersion.getDescription());
        dlFileEntry.setExtraSettings(latestDLFileVersion.getExtraSettings());
        dlFileEntry.setFileEntryTypeId(latestDLFileVersion.getFileEntryTypeId());
        dlFileEntry.setSize(latestDLFileVersion.getSize());
        this.dlFileEntryPersistence.update(dlFileEntry);
        lastDLFileVersion.setUserId(latestDLFileVersion.getUserId());
        lastDLFileVersion.setUserName(latestDLFileVersion.getUserName());
        lastDLFileVersion.setModifiedDate(latestDLFileVersion.getModifiedDate());
        lastDLFileVersion.setFileName(latestDLFileVersion.getFileName());
        lastDLFileVersion.setExtension(latestDLFileVersion.getExtension());
        lastDLFileVersion.setMimeType(latestDLFileVersion.getMimeType());
        lastDLFileVersion.setTitle(latestDLFileVersion.getTitle());
        lastDLFileVersion.setDescription(latestDLFileVersion.getDescription());
        lastDLFileVersion.setChangeLog(latestDLFileVersion.getChangeLog());
        lastDLFileVersion.setExtraSettings(latestDLFileVersion.getExtraSettings());
        lastDLFileVersion.setFileEntryTypeId(latestDLFileVersion.getFileEntryTypeId());
        lastDLFileVersion.setSize(latestDLFileVersion.getSize());
        ExpandoBridgeUtil.copyExpandoBridgeAttributes(lastDLFileVersion.getExpandoBridge(), latestDLFileVersion.getExpandoBridge());
        this.dlFileVersionPersistence.update(lastDLFileVersion);
        Serializable validateDDMFormValues = serviceContext.getAttribute("validateDDMFormValues");
        try {
            serviceContext.setAttribute("validateDDMFormValues", Boolean.FALSE);
            this.copyFileEntryMetadata(dlFileEntry.getCompanyId(), dlFileEntry.getFileEntryTypeId(), dlFileEntry.getFileEntryId(), latestDLFileVersion.getFileVersionId(), lastDLFileVersion.getFileVersionId(), serviceContext);
        }
        finally {
            serviceContext.setAttribute("validateDDMFormValues", validateDDMFormValues);
        }
        AssetEntry latestDLFileVersionAssetEntry = this.assetEntryLocalService.fetchEntry(DLFileEntryConstants.getClassName(), latestDLFileVersion.getPrimaryKey());
        if (latestDLFileVersionAssetEntry != null) {
            this.assetEntryLocalService.updateEntry(lastDLFileVersion.getUserId(), lastDLFileVersion.getGroupId(), DLFileEntryConstants.getClassName(), lastDLFileVersion.getPrimaryKey(), latestDLFileVersionAssetEntry.getCategoryIds(), latestDLFileVersionAssetEntry.getTagNames());
        }
        DLStoreUtil.deleteFile(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), lastDLFileVersion.getVersion());
        DLStoreUtil.copyFileVersion(user.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), "PWC", lastDLFileVersion.getVersion());
        this.removeFileVersion(dlFileEntry, latestDLFileVersion);
    }
}

