/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.service.DLTrashServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileEntrySoap;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.FolderSoap;
import com.liferay.portal.kernel.service.ServiceContext;
import java.rmi.RemoteException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLTrashServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLTrashServiceSoap.class);

    public static FileEntrySoap moveFileEntryFromTrash(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            FileEntry returnValue = DLTrashServiceUtil.moveFileEntryFromTrash(fileEntryId, newFolderId, serviceContext);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap moveFileEntryToTrash(long fileEntryId) throws RemoteException {
        try {
            FileEntry returnValue = DLTrashServiceUtil.moveFileEntryToTrash(fileEntryId);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap moveFolderFromTrash(long folderId, long parentFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            Folder returnValue = DLTrashServiceUtil.moveFolderFromTrash(folderId, parentFolderId, serviceContext);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap moveFolderToTrash(long folderId) throws RemoteException {
        try {
            Folder returnValue = DLTrashServiceUtil.moveFolderToTrash(folderId);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void restoreFileEntryFromTrash(long fileEntryId) throws RemoteException {
        try {
            DLTrashServiceUtil.restoreFileEntryFromTrash(fileEntryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void restoreFileShortcutFromTrash(long fileShortcutId) throws RemoteException {
        try {
            DLTrashServiceUtil.restoreFileShortcutFromTrash(fileShortcutId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void restoreFolderFromTrash(long folderId) throws RemoteException {
        try {
            DLTrashServiceUtil.restoreFolderFromTrash(folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

