/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.service.DLTrashServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLTrashServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(DLTrashServiceHttp.class);
    private static final Class<?>[] _moveFileEntryFromTrashParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _moveFileEntryToTrashParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _moveFileShortcutFromTrashParameterTypes2 = new Class[]{Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _moveFileShortcutToTrashParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _moveFolderFromTrashParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _moveFolderToTrashParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreFileEntryFromTrashParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreFileShortcutFromTrashParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreFolderFromTrashParameterTypes8 = new Class[]{Long.TYPE};

    public static FileEntry moveFileEntryFromTrash(HttpPrincipal httpPrincipal, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "moveFileEntryFromTrash", _moveFileEntryFromTrashParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId, newFolderId, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static FileEntry moveFileEntryToTrash(HttpPrincipal httpPrincipal, long fileEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "moveFileEntryToTrash", _moveFileEntryToTrashParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static FileShortcut moveFileShortcutFromTrash(HttpPrincipal httpPrincipal, long fileShortcutId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "moveFileShortcutFromTrash", _moveFileShortcutFromTrashParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileShortcutId, newFolderId, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (FileShortcut)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static FileShortcut moveFileShortcutToTrash(HttpPrincipal httpPrincipal, long fileShortcutId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "moveFileShortcutToTrash", _moveFileShortcutToTrashParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileShortcutId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (FileShortcut)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Folder moveFolderFromTrash(HttpPrincipal httpPrincipal, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "moveFolderFromTrash", _moveFolderFromTrashParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, folderId, parentFolderId, serviceContext);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Folder)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static Folder moveFolderToTrash(HttpPrincipal httpPrincipal, long folderId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "moveFolderToTrash", _moveFolderToTrashParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, folderId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Folder)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void restoreFileEntryFromTrash(HttpPrincipal httpPrincipal, long fileEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "restoreFileEntryFromTrash", _restoreFileEntryFromTrashParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void restoreFileShortcutFromTrash(HttpPrincipal httpPrincipal, long fileShortcutId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "restoreFileShortcutFromTrash", _restoreFileShortcutFromTrashParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileShortcutId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static void restoreFolderFromTrash(HttpPrincipal httpPrincipal, long folderId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLTrashServiceUtil.class, "restoreFolderFromTrash", _restoreFolderFromTrashParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, folderId);
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

