/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderSoap;
import com.liferay.document.library.kernel.service.DLFolderServiceUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLFolderServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLFolderServiceSoap.class);

    public static DLFolderSoap addFolder(long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.addFolder(groupId, repositoryId, mountPoint, parentFolderId, name, description, serviceContext);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFolder(long folderId) throws RemoteException {
        try {
            DLFolderServiceUtil.deleteFolder(folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFolder(long folderId, boolean includeTrashedEntries) throws RemoteException {
        try {
            DLFolderServiceUtil.deleteFolder(folderId, includeTrashedEntries);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFolder(long groupId, long parentFolderId, String name) throws RemoteException {
        try {
            DLFolderServiceUtil.deleteFolder(groupId, parentFolderId, name);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFileEntriesAndFileShortcutsCount(groupId, folderId, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFileEntriesAndFileShortcutsCount(groupId, folderId, status, mimeTypes);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap getFolder(long folderId) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.getFolder(folderId);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap getFolder(long groupId, long parentFolderId, String name) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.getFolder(groupId, parentFolderId, name);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Long[] getFolderIds(long groupId, long folderId) throws RemoteException {
        try {
            List<Long> returnValue = DLFolderServiceUtil.getFolderIds(groupId, folderId);
            return returnValue.toArray(new Long[returnValue.size()]);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap[] getFolders(long groupId, long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator<DLFolder> obc) throws RemoteException {
        try {
            List<DLFolder> returnValue = DLFolderServiceUtil.getFolders(groupId, parentFolderId, status, includeMountfolders, start, end, obc);
            return DLFolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap[] getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) throws RemoteException {
        try {
            List<DLFolder> returnValue = DLFolderServiceUtil.getFolders(groupId, parentFolderId, start, end, obc);
            return DLFolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, status, includeMountFolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, status, mimeTypes, includeMountFolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersCount(long groupId, long parentFolderId) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFoldersCount(groupId, parentFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersCount(long groupId, long parentFolderId, int status, boolean includeMountfolders) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getFoldersCount(groupId, parentFolderId, status, includeMountfolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap[] getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> obc) throws RemoteException {
        try {
            List<DLFolder> returnValue = DLFolderServiceUtil.getMountFolders(groupId, parentFolderId, start, end, obc);
            return DLFolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getMountFoldersCount(long groupId, long parentFolderId) throws RemoteException {
        try {
            int returnValue = DLFolderServiceUtil.getMountFoldersCount(groupId, parentFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static void getSubfolderIds(Long[] folderIds, long groupId, long folderId) throws RemoteException {
        try {
            DLFolderServiceUtil.getSubfolderIds(ListUtil.toList(folderIds), groupId, folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void getSubfolderIds(Long[] folderIds, long groupId, long folderId, boolean recurse) throws RemoteException {
        try {
            DLFolderServiceUtil.getSubfolderIds(ListUtil.toList(folderIds), groupId, folderId, recurse);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Long[] getSubfolderIds(long groupId, long folderId, boolean recurse) throws RemoteException {
        try {
            List<Long> returnValue = DLFolderServiceUtil.getSubfolderIds(groupId, folderId, recurse);
            return returnValue.toArray(new Long[returnValue.size()]);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasFolderLock(long folderId) throws RemoteException {
        try {
            boolean returnValue = DLFolderServiceUtil.hasFolderLock(folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasInheritableLock(long folderId) throws RemoteException {
        try {
            boolean returnValue = DLFolderServiceUtil.hasInheritableLock(folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean isFolderLocked(long folderId) throws RemoteException {
        try {
            boolean returnValue = DLFolderServiceUtil.isFolderLocked(folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock lockFolder(long folderId) throws RemoteException {
        try {
            Lock returnValue = DLFolderServiceUtil.lockFolder(folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws RemoteException {
        try {
            Lock returnValue = DLFolderServiceUtil.lockFolder(folderId, owner, inheritable, expirationTime);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.moveFolder(folderId, parentFolderId, serviceContext);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws RemoteException {
        try {
            Lock returnValue = DLFolderServiceUtil.refreshFolderLock(lockUuid, companyId, expirationTime);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws RemoteException {
        try {
            DLFolderServiceUtil.unlockFolder(groupId, parentFolderId, name, lockUuid);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unlockFolder(long folderId, String lockUuid) throws RemoteException {
        try {
            DLFolderServiceUtil.unlockFolder(folderId, lockUuid);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, Long[] fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.updateFolder(folderId, parentFolderId, name, description, defaultFileEntryTypeId, ListUtil.toList(fileEntryTypeIds), restrictionType, serviceContext);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static DLFolderSoap updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, Long[] fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.updateFolder(folderId, name, description, defaultFileEntryTypeId, ListUtil.toList(fileEntryTypeIds), overrideFileEntryTypes, serviceContext);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFolderSoap updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, Long[] fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFolder returnValue = DLFolderServiceUtil.updateFolder(folderId, name, description, defaultFileEntryTypeId, ListUtil.toList(fileEntryTypeIds), restrictionType, serviceContext);
            return DLFolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyInheritableLock(long folderId, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLFolderServiceUtil.verifyInheritableLock(folderId, lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

