/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFileVersionSoap;
import com.liferay.document.library.kernel.service.DLFileVersionServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLFileVersionServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLFileVersionServiceSoap.class);

    public static DLFileVersionSoap getFileVersion(long fileVersionId) throws RemoteException {
        try {
            DLFileVersion returnValue = DLFileVersionServiceUtil.getFileVersion(fileVersionId);
            return DLFileVersionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileVersionSoap[] getFileVersions(long fileEntryId, int status) throws RemoteException {
        try {
            List<DLFileVersion> returnValue = DLFileVersionServiceUtil.getFileVersions(fileEntryId, status);
            return DLFileVersionSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileVersionsCount(long fileEntryId, int status) throws RemoteException {
        try {
            int returnValue = DLFileVersionServiceUtil.getFileVersionsCount(fileEntryId, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileVersionSoap getLatestFileVersion(long fileEntryId) throws RemoteException {
        try {
            DLFileVersion returnValue = DLFileVersionServiceUtil.getLatestFileVersion(fileEntryId);
            return DLFileVersionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileVersionSoap getLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) throws RemoteException {
        try {
            DLFileVersion returnValue = DLFileVersionServiceUtil.getLatestFileVersion(fileEntryId, excludeWorkingCopy);
            return DLFileVersionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

