/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileVersionServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLFileVersionServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(DLFileVersionServiceHttp.class);
    private static final Class<?>[] _getFileVersionParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getFileVersionsParameterTypes1 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getFileVersionsCountParameterTypes2 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getLatestFileVersionParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getLatestFileVersionParameterTypes4 = new Class[]{Long.TYPE, Boolean.TYPE};

    public static DLFileVersion getFileVersion(HttpPrincipal httpPrincipal, long fileVersionId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLFileVersionServiceUtil.class, "getFileVersion", _getFileVersionParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileVersionId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (DLFileVersion)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static List<DLFileVersion> getFileVersions(HttpPrincipal httpPrincipal, long fileEntryId, int status) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLFileVersionServiceUtil.class, "getFileVersions", _getFileVersionsParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId, status);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static int getFileVersionsCount(HttpPrincipal httpPrincipal, long fileEntryId, int status) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLFileVersionServiceUtil.class, "getFileVersionsCount", _getFileVersionsCountParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId, status);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static DLFileVersion getLatestFileVersion(HttpPrincipal httpPrincipal, long fileEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLFileVersionServiceUtil.class, "getLatestFileVersion", _getLatestFileVersionParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (DLFileVersion)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }

    public static DLFileVersion getLatestFileVersion(HttpPrincipal httpPrincipal, long fileEntryId, boolean excludeWorkingCopy) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(DLFileVersionServiceUtil.class, "getLatestFileVersion", _getLatestFileVersionParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, fileEntryId, excludeWorkingCopy);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)e;
                }
                throw new SystemException(e);
            }
            return (DLFileVersion)returnObj;
        }
        catch (SystemException se) {
            _log.error(se, se);
            throw se;
        }
    }
}

