/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileEntryTypeSoap;
import com.liferay.document.library.kernel.service.DLFileEntryTypeServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLFileEntryTypeServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryTypeServiceSoap.class);

    public static DLFileEntryTypeSoap addFileEntryType(long groupId, String fileEntryTypeKey, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, long[] ddmStructureIds, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            DLFileEntryType returnValue = DLFileEntryTypeServiceUtil.addFileEntryType(groupId, fileEntryTypeKey, nameMap, descriptionMap, ddmStructureIds, serviceContext);
            return DLFileEntryTypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap addFileEntryType(long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntryType returnValue = DLFileEntryTypeServiceUtil.addFileEntryType(groupId, name, description, ddmStructureIds, serviceContext);
            return DLFileEntryTypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntryType(long fileEntryTypeId) throws RemoteException {
        try {
            DLFileEntryTypeServiceUtil.deleteFileEntryType(fileEntryTypeId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap getFileEntryType(long fileEntryTypeId) throws RemoteException {
        try {
            DLFileEntryType returnValue = DLFileEntryTypeServiceUtil.getFileEntryType(fileEntryTypeId);
            return DLFileEntryTypeSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap[] getFileEntryTypes(long[] groupIds) throws RemoteException {
        try {
            List<DLFileEntryType> returnValue = DLFileEntryTypeServiceUtil.getFileEntryTypes(groupIds);
            return DLFileEntryTypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap[] getFileEntryTypes(long[] groupIds, int start, int end) throws RemoteException {
        try {
            List<DLFileEntryType> returnValue = DLFileEntryTypeServiceUtil.getFileEntryTypes(groupIds, start, end);
            return DLFileEntryTypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntryTypesCount(long[] groupIds) throws RemoteException {
        try {
            int returnValue = DLFileEntryTypeServiceUtil.getFileEntryTypesCount(groupIds);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap[] getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws RemoteException {
        try {
            List<DLFileEntryType> returnValue = DLFileEntryTypeServiceUtil.getFolderFileEntryTypes(groupIds, folderId, inherited);
            return DLFileEntryTypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap[] search(long companyId, long folderId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, boolean inherited, int start, int end) throws RemoteException {
        try {
            List<DLFileEntryType> returnValue = DLFileEntryTypeServiceUtil.search(companyId, folderId, groupIds, keywords, includeBasicFileEntryType, inherited, start, end);
            return DLFileEntryTypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntryTypeSoap[] search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator<DLFileEntryType> orderByComparator) throws RemoteException {
        try {
            List<DLFileEntryType> returnValue = DLFileEntryTypeServiceUtil.search(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
            return DLFileEntryTypeSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int searchCount(long companyId, long folderId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, boolean inherited) throws RemoteException {
        try {
            int returnValue = DLFileEntryTypeServiceUtil.searchCount(companyId, folderId, groupIds, keywords, includeBasicFileEntryType, inherited);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) throws RemoteException {
        try {
            int returnValue = DLFileEntryTypeServiceUtil.searchCount(companyId, groupIds, keywords, includeBasicFileEntryType);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateFileEntryType(long fileEntryTypeId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, long[] ddmStructureIds, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(nameMapLanguageIds, nameMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            DLFileEntryTypeServiceUtil.updateFileEntryType(fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateFileEntryType(long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntryTypeServiceUtil.updateFileEntryType(fileEntryTypeId, name, description, ddmStructureIds, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

