/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntrySoap;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFileVersionSoap;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLFileEntryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryServiceSoap.class);

    public static DLFileVersionSoap cancelCheckOut(long fileEntryId) throws RemoteException {
        try {
            DLFileVersion returnValue = DLFileEntryServiceUtil.cancelCheckOut(fileEntryId);
            return DLFileVersionSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static void checkInFileEntry(long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntryServiceUtil.checkInFileEntry(fileEntryId, major, changeLog, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void checkInFileEntry(long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntryServiceUtil.checkInFileEntry(fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntryServiceUtil.checkInFileEntry(fileEntryId, lockUuid, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.checkOutFileEntry(fileEntryId, serviceContext);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap copyFileEntry(long groupId, long repositoryId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.copyFileEntry(groupId, repositoryId, fileEntryId, destFolderId, serviceContext);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntry(long fileEntryId) throws RemoteException {
        try {
            DLFileEntryServiceUtil.deleteFileEntry(fileEntryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntry(long groupId, long folderId, String title) throws RemoteException {
        try {
            DLFileEntryServiceUtil.deleteFileEntry(groupId, folderId, title);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileVersion(long fileEntryId, String version) throws RemoteException {
        try {
            DLFileEntryServiceUtil.deleteFileVersion(fileEntryId, version);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap fetchFileEntryByImageId(long imageId) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.fetchFileEntryByImageId(imageId);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getFileEntries(groupId, folderId, status, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getFileEntries(groupId, folderId, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getFileEntries(groupId, folderId, fileEntryTypeId, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getFileEntries(groupId, folderId, mimeTypes, status, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getFileEntries(long groupId, long folderId, String[] mimeTypes, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getFileEntries(groupId, folderId, mimeTypes, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long groupId, long folderId) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFileEntriesCount(groupId, folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long groupId, long folderId, int status) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFileEntriesCount(groupId, folderId, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long groupId, long folderId, long fileEntryTypeId) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFileEntriesCount(groupId, folderId, fileEntryTypeId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long groupId, long folderId, String[] mimeTypes) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFileEntriesCount(groupId, folderId, mimeTypes);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long groupId, long folderId, String[] mimeTypes, int status) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFileEntriesCount(groupId, folderId, mimeTypes, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap getFileEntry(long fileEntryId) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.getFileEntry(fileEntryId);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap getFileEntry(long groupId, long folderId, String title) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.getFileEntry(groupId, folderId, title);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap getFileEntryByUuidAndGroupId(String uuid, long groupId) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock getFileEntryLock(long fileEntryId) throws RemoteException {
        try {
            Lock returnValue = DLFileEntryServiceUtil.getFileEntryLock(fileEntryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersFileEntriesCount(long groupId, Long[] folderIds, int status) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getFoldersFileEntriesCount(groupId, ListUtil.toList(folderIds), status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getGroupFileEntries(groupId, userId, rootFolderId, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getGroupFileEntries(long groupId, long userId, long repositoryId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getGroupFileEntries(groupId, userId, repositoryId, rootFolderId, mimeTypes, status, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap[] getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<DLFileEntry> obc) throws RemoteException {
        try {
            List<DLFileEntry> returnValue = DLFileEntryServiceUtil.getGroupFileEntries(groupId, userId, rootFolderId, mimeTypes, status, start, end, obc);
            return DLFileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getGroupFileEntriesCount(groupId, userId, rootFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId, long repositoryId, long rootFolderId, String[] mimeTypes, int status) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getGroupFileEntriesCount(groupId, userId, repositoryId, rootFolderId, mimeTypes, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws RemoteException {
        try {
            int returnValue = DLFileEntryServiceUtil.getGroupFileEntriesCount(groupId, userId, rootFolderId, mimeTypes, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasFileEntryLock(long fileEntryId) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.hasFileEntryLock(fileEntryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean isFileEntryCheckedOut(long fileEntryId) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.isFileEntryCheckedOut(fileEntryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static boolean isKeepFileVersionLabel(long fileEntryId, boolean majorVersion, ServiceContext serviceContext) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.isKeepFileVersionLabel(fileEntryId, majorVersion, serviceContext);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static boolean isKeepFileVersionLabel(long fileEntryId, ServiceContext serviceContext) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.isKeepFileVersionLabel(fileEntryId, serviceContext);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static DLFileEntrySoap moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntry returnValue = DLFileEntryServiceUtil.moveFileEntry(fileEntryId, newFolderId, serviceContext);
            return DLFileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws RemoteException {
        try {
            Lock returnValue = DLFileEntryServiceUtil.refreshFileEntryLock(lockUuid, companyId, expirationTime);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws RemoteException {
        try {
            DLFileEntryServiceUtil.revertFileEntry(fileEntryId, version, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.verifyFileEntryCheckOut(fileEntryId, lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLFileEntryServiceUtil.verifyFileEntryLock(fileEntryId, lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

